/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.ViewGroup;
import java.util.List;
import nu.annat.beholder.ComponentFactory;
import nu.annat.beholder.ComponentViewHolder;
import nu.annat.beholder.action.ActionHandler;
import nu.annat.beholder.presenter.ComponentInfo;

public class BeholderAdapter
extends RecyclerView.Adapter<ComponentViewHolder> {
    private static final String TAG = BeholderAdapter.class.getSimpleName();
    private final ActionHandler actionHandler;
    private final List<ComponentInfo> data;
    private ComponentFactory factory;
    private SparseArray<ComponentInfo> cachedPresenters = new SparseArray();

    public BeholderAdapter(ComponentFactory factory, List<ComponentInfo> data, ActionHandler actionHandler) {
        this.factory = factory;
        this.data = data;
        this.actionHandler = actionHandler;
    }

    public ComponentViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.factory.createReusable((ComponentInfo)this.cachedPresenters.get(viewType), parent, this.actionHandler);
    }

    public int getItemViewType(int position) {
        ComponentInfo componentInfo = this.getItem(position);
        int deepLayoutHash = componentInfo.deepLayoutHash();
        this.cachedPresenters.put(deepLayoutHash, (Object)componentInfo);
        return deepLayoutHash;
    }

    protected ComponentInfo getItem(int position) {
        return this.data.get(position);
    }

    public List<ComponentInfo> getData() {
        return this.data;
    }

    public void onBindViewHolder(ComponentViewHolder holder, int position) {
        this.factory.bindDeep(holder, this.getItem(position), true);
    }

    public int getItemCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public void close() {
        this.factory = null;
    }
}

