package nu.annat.beholder.presenter;

import java.util.ArrayList;

/**
 * Even if most presenters don't have children, the Android implementation of an empty
 * arrayList is so efficient that we don't have to separate non parents from parents.
 */
public class ComponentPresenter extends ArrayList<ComponentInfo> implements ComponentInfo {


	@Override
	public int layoutHash() {
		return this.getClass().getCanonicalName().hashCode();
	}

	@Override
	public int deepLayoutHash() {
		int hash = layoutHash();
		if (!isEmpty()) {
			for (ComponentInfo childComponentInfo : this) {
				hash = 31 * hash + childComponentInfo.deepLayoutHash();
			}
		}
		return hash;
	}
}
