/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder;

import android.databinding.ViewDataBinding;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import nu.annat.beholder.Action;
import nu.annat.beholder.ActionHandler;
import nu.annat.beholder.ViewInformation;
import nu.annat.beholder.presenter.ComponentInfo;

public abstract class ComponentViewHolder<BINDING extends ViewDataBinding, PRESENTER extends ComponentInfo>
extends RecyclerView.ViewHolder {
    protected final BINDING binding;
    protected final ActionHandler actionHandler;
    protected final ViewInformation viewInformation;
    private final int layoutId;
    private final int reuseId;
    private PRESENTER PRESENTER;
    private List<ComponentViewHolder> children;

    private ComponentViewHolder(View view) {
        super(view);
        this.binding = null;
        this.actionHandler = null;
        this.layoutId = 0;
        this.reuseId = 0;
        this.viewInformation = null;
    }

    public ComponentViewHolder(ViewInformation viewInformation, ViewDataBinding binding, ActionHandler actionHandler, int layoutId, int reuseId) {
        super(binding.getRoot());
        this.layoutId = layoutId;
        this.actionHandler = actionHandler;
        this.reuseId = reuseId;
        this.binding = binding;
        this.viewInformation = viewInformation;
        this.prepareBinding(this.binding);
    }

    protected abstract void prepareBinding(BINDING var1);

    public PRESENTER getPresenter() {
        return this.PRESENTER;
    }

    public void setData(PRESENTER PRESENTER, boolean force) {
        this.PRESENTER = PRESENTER;
        this.updateBindings(this.binding, PRESENTER);
        if (force) {
            this.binding.executePendingBindings();
        }
    }

    protected abstract void updateBindings(BINDING var1, PRESENTER var2);

    public int getLayoutId() {
        return this.layoutId;
    }

    public int getReuseId() {
        return this.reuseId;
    }

    private void ensureChildren() {
        this.children = this.children != null ? this.children : new ArrayList<ComponentViewHolder>();
    }

    public void addChild(ComponentViewHolder viewHolder) {
        this.ensureChildren();
        this.children.add(viewHolder);
    }

    public List<ComponentViewHolder> getChildren() {
        return this.children;
    }

    protected void act(Action action) {
        if (this.actionHandler != null) {
            this.actionHandler.handle(action);
        }
    }
}

