/*
 * Decompiled with CFR 0.152.
 */
package nu.annat.beholder.presenter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nu.annat.beholder.presenter.ComponentInfo;
import nu.annat.beholder.presenter.ComponentInfoDelegate;
import nu.annat.beholder.presenter.ExplodingComponentInfo;
import nu.annat.beholder.presenter.ParentComponentInfo;

public class ParentComponentInfoDelegate
implements ParentComponentInfo {
    ComponentInfoDelegate delegate = new ComponentInfoDelegate(this);
    List<ComponentInfo> subComponentInfos = new ArrayList<ComponentInfo>();
    private final Object parent;

    public ParentComponentInfoDelegate(Object parent) {
        this.parent = parent;
    }

    @Override
    public boolean add(ComponentInfo componentInfo) {
        if (componentInfo instanceof ExplodingComponentInfo) {
            for (ComponentInfo subComponentInfo : ((ExplodingComponentInfo)componentInfo).explode()) {
                this.subComponentInfos.add(subComponentInfo);
            }
            return true;
        }
        return this.subComponentInfos.add(componentInfo);
    }

    @Override
    public boolean addAll(Collection<ComponentInfo> componentInfos) {
        for (ComponentInfo componentInfo : componentInfos) {
            this.add(componentInfo);
        }
        return true;
    }

    @Override
    public List<ComponentInfo> subPresenters() {
        return this.subComponentInfos;
    }

    @Override
    public int layoutHash() {
        int hash = this.parent.getClass().getName().hashCode();
        return hash;
    }

    @Override
    public int deepLayoutHash() {
        int hash = this.layoutHash();
        for (ComponentInfo childComponentInfo : this.subComponentInfos) {
            hash = 31 * hash + childComponentInfo.deepLayoutHash();
        }
        return hash;
    }
}

