/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.util;

import com.rfksystems.blake2b.security.Blake2bProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.XECPrivateKey;
import java.security.interfaces.XECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.security.spec.XECPrivateKeySpec;
import java.security.spec.XECPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import no.uio.ifi.crypt4gh.pojo.key.Cipher;
import no.uio.ifi.crypt4gh.pojo.key.KDF;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

public class KeyUtils {
    public static final String CHA_CHA_20 = "ChaCha20";
    public static final String X25519 = "X25519";
    public static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    public static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String BEGIN_CRYPT4GH_PUBLIC_KEY = "-----BEGIN CRYPT4GH PUBLIC KEY-----";
    public static final String END_CRYPT4GH_PUBLIC_KEY = "-----END CRYPT4GH PUBLIC KEY-----";
    public static final String BEGIN_CRYPT4GH_ENCRYPTED_PRIVATE_KEY = "-----BEGIN CRYPT4GH ENCRYPTED PRIVATE KEY-----";
    public static final String END_CRYPT4GH_ENCRYPTED_PRIVATE_KEY = "-----END CRYPT4GH ENCRYPTED PRIVATE KEY-----";
    public static final String CRYPT4GH_AUTH_MAGIC = "c4gh-v1";
    private static KeyUtils ourInstance = new KeyUtils();

    public static KeyUtils getInstance() {
        return ourInstance;
    }

    private KeyUtils() {
        Security.addProvider((Provider)new Blake2bProvider());
    }

    public KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(X25519);
        return keyPairGenerator.generateKeyPair();
    }

    public byte[] encodeKey(Key key) throws GeneralSecurityException {
        if (key instanceof XECPublicKey) {
            return this.getU((PublicKey)key);
        }
        if (key instanceof XECPrivateKey) {
            return this.getScalar((PrivateKey)key);
        }
        throw new GeneralSecurityException("Expected either XECPublicKey or XECPrivateKey, but got: " + key.getClass());
    }

    public byte[] getU(PublicKey publicKey) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(X25519);
        XECPublicKeySpec publicKeySpec = keyFactory.getKeySpec(publicKey, XECPublicKeySpec.class);
        byte[] u = publicKeySpec.getU().toByteArray();
        ArrayUtils.reverse((byte[])u);
        return Arrays.copyOf(u, 32);
    }

    public byte[] getScalar(PrivateKey privateKey) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(X25519);
        XECPrivateKeySpec publicKeySpec = keyFactory.getKeySpec(privateKey, XECPrivateKeySpec.class);
        return publicKeySpec.getScalar();
    }

    public PrivateKey generatePrivateKey() throws GeneralSecurityException {
        byte[] scalar = new byte[32];
        SecureRandom.getInstanceStrong().nextBytes(scalar);
        return this.constructPrivateKey(scalar);
    }

    public PrivateKey constructPrivateKey(byte[] scalar) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(X25519);
        return keyFactory.generatePrivate(new XECPrivateKeySpec(new NamedParameterSpec(X25519), scalar));
    }

    public PublicKey constructPublicKey(byte[] u) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(X25519);
        u = (byte[])u.clone();
        ArrayUtils.reverse((byte[])u);
        return keyFactory.generatePublic(new XECPublicKeySpec(new NamedParameterSpec(X25519), new BigInteger(u)));
    }

    public PublicKey derivePublicKey(PrivateKey privateKey) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(X25519);
        keyPairGenerator.initialize(new NamedParameterSpec(X25519), (SecureRandom)new StaticSecureRandom(this.getScalar(privateKey)));
        return keyPairGenerator.generateKeyPair().getPublic();
    }

    public byte[] generateDiffieHellmanSharedKey(PrivateKey privateKey, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement keyAgreement = KeyAgreement.getInstance(X25519);
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement.generateSecret();
    }

    public SecretKey generateWriterSharedKey(PrivateKey writerPrivateKey, PublicKey readerPublicKey) throws GeneralSecurityException {
        PublicKey writerPublicKey = this.derivePublicKey(writerPrivateKey);
        byte[] diffieHellmanKey = this.generateDiffieHellmanSharedKey(writerPrivateKey, readerPublicKey);
        byte[] digest = MessageDigest.getInstance("BLAKE2B-512").digest(ArrayUtils.addAll((byte[])ArrayUtils.addAll((byte[])diffieHellmanKey, (byte[])this.encodeKey(readerPublicKey)), (byte[])this.encodeKey(writerPublicKey)));
        return new SecretKeySpec(Arrays.copyOfRange(digest, 0, 32), CHA_CHA_20);
    }

    public SecretKey generateReaderSharedKey(PrivateKey readerPrivateKey, PublicKey writerPublicKey) throws GeneralSecurityException {
        PublicKey readerPublicKey = this.derivePublicKey(readerPrivateKey);
        byte[] diffieHellmanKey = this.generateDiffieHellmanSharedKey(readerPrivateKey, writerPublicKey);
        byte[] digest = MessageDigest.getInstance("BLAKE2B-512").digest(ArrayUtils.addAll((byte[])ArrayUtils.addAll((byte[])diffieHellmanKey, (byte[])this.encodeKey(readerPublicKey)), (byte[])this.encodeKey(writerPublicKey)));
        return new SecretKeySpec(Arrays.copyOfRange(digest, 0, 32), CHA_CHA_20);
    }

    public SecretKey generateSessionKey() throws NoSuchAlgorithmException {
        return KeyGenerator.getInstance(CHA_CHA_20).generateKey();
    }

    public PublicKey readPublicKey(File keyFile) throws IOException, GeneralSecurityException {
        String keyLines = FileUtils.readFileToString((File)keyFile, (Charset)Charset.defaultCharset());
        return this.readPublicKey(keyLines);
    }

    public PublicKey readPublicKey(String keyMaterial) throws GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance(X25519);
        byte[] decodedKey = this.decodeKey(keyMaterial);
        try {
            return keyFactory.generatePublic(new X509EncodedKeySpec(decodedKey));
        }
        catch (InvalidKeySpecException e) {
            return this.constructPublicKey(decodedKey);
        }
    }

    public PrivateKey readPrivateKey(File keyFile, char[] password) throws IOException, GeneralSecurityException {
        String keyLines = FileUtils.readFileToString((File)keyFile, (Charset)Charset.defaultCharset());
        return this.readPrivateKey(keyLines, password);
    }

    public PrivateKey readPrivateKey(String keyMaterial, char[] password) throws GeneralSecurityException, IllegalArgumentException {
        KeyFactory keyFactory = KeyFactory.getInstance(X25519);
        byte[] decodedKey = this.decodeKey(keyMaterial);
        try {
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(decodedKey));
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            return this.readCrypt4GHPrivateKey(decodedKey, password);
        }
    }

    public PrivateKey readCrypt4GHPrivateKey(byte[] keyMaterial, char[] password) throws GeneralSecurityException, IllegalArgumentException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(keyMaterial).order(ByteOrder.BIG_ENDIAN);
        byteBuffer.get(new byte[CRYPT4GH_AUTH_MAGIC.length()]);
        KDF kdf = KDF.valueOf(this.decodeString(byteBuffer).toUpperCase());
        int rounds = 0;
        byte[] salt = new byte[]{};
        if (kdf != KDF.NONE) {
            if (password == null) {
                throw new IllegalArgumentException("Private key is password-protected, need a password for decryption");
            }
            short roundsAndSaltLength = byteBuffer.getShort();
            int saltLength = roundsAndSaltLength - 4;
            rounds = byteBuffer.getInt();
            salt = this.decodeArray(byteBuffer, saltLength);
        }
        Cipher cipher = Cipher.valueOf(this.decodeString(byteBuffer).toUpperCase());
        short payloadLength = byteBuffer.getShort();
        byte[] payload = this.decodeArray(byteBuffer, payloadLength);
        if (kdf == KDF.NONE) {
            if (cipher != Cipher.NONE) {
                throw new GeneralSecurityException("Invalid private key: KDF is 'none', but cipher is not 'none");
            }
            return this.constructPrivateKey(payload);
        }
        SecretKeySpec derivedKey = new SecretKeySpec(kdf.derive(rounds, password, salt), CHA_CHA_20);
        Arrays.fill(password, '\u0000');
        javax.crypto.Cipher decryption = javax.crypto.Cipher.getInstance("ChaCha20-Poly1305");
        byte[] nonce = Arrays.copyOfRange(payload, 0, 12);
        byte[] key = Arrays.copyOfRange(payload, 12, payload.length);
        decryption.init(2, (Key)derivedKey, new IvParameterSpec(nonce));
        byte[] decryptedPayload = decryption.doFinal(key);
        return this.constructPrivateKey(decryptedPayload);
    }

    public byte[] decodeKey(String keyMaterial) {
        keyMaterial = keyMaterial.replaceAll("-----(.*?)-----", "").replace(System.lineSeparator(), "").replace(" ", "").trim();
        return Base64.getDecoder().decode(keyMaterial);
    }

    public void writeOpenSSLKey(Writer writer, Key key) throws IOException {
        ArrayList<String> keyLines = new ArrayList<String>();
        boolean isPublic = key instanceof PublicKey;
        if (isPublic) {
            keyLines.add(BEGIN_PUBLIC_KEY);
        } else {
            keyLines.add(BEGIN_PRIVATE_KEY);
        }
        keyLines.add(Base64.getEncoder().encodeToString(key.getEncoded()));
        if (isPublic) {
            keyLines.add(END_PUBLIC_KEY);
        } else {
            keyLines.add(END_PRIVATE_KEY);
        }
        IOUtils.writeLines(keyLines, null, (Writer)writer);
    }

    public void writeCrypt4GHKey(Writer writer, Key key, char[] password) throws IOException, GeneralSecurityException {
        ArrayList<String> keyLines = new ArrayList<String>();
        boolean isPublic = key instanceof PublicKey;
        byte[] encodedKey = this.encodeKey(key);
        if (isPublic) {
            keyLines.add(BEGIN_CRYPT4GH_PUBLIC_KEY);
            keyLines.add(Base64.getEncoder().encodeToString(encodedKey));
            keyLines.add(END_CRYPT4GH_PUBLIC_KEY);
        } else {
            byte[] salt = new byte[16];
            SecureRandom.getInstanceStrong().nextBytes(salt);
            SecretKeySpec derivedKey = new SecretKeySpec(KDF.SCRYPT.derive(0, password, salt), CHA_CHA_20);
            Arrays.fill(password, '\u0000');
            byte[] nonce = new byte[12];
            SecureRandom.getInstanceStrong().nextBytes(nonce);
            javax.crypto.Cipher encryption = javax.crypto.Cipher.getInstance("ChaCha20-Poly1305");
            encryption.init(1, (Key)derivedKey, new IvParameterSpec(nonce));
            byte[] encryptedKey = encryption.doFinal(encodedKey);
            keyLines.add(BEGIN_CRYPT4GH_ENCRYPTED_PRIVATE_KEY);
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                byteArrayOutputStream.write(CRYPT4GH_AUTH_MAGIC.getBytes());
                byteArrayOutputStream.write(this.encodeString(KDF.SCRYPT.name().toLowerCase()));
                byteArrayOutputStream.write(this.encodeArray(ArrayUtils.addAll((byte[])new byte[4], (byte[])salt)));
                byteArrayOutputStream.write(this.encodeString(Cipher.CHACHA20_POLY1305.name().toLowerCase()));
                byteArrayOutputStream.write(this.encodeArray(ArrayUtils.addAll((byte[])nonce, (byte[])encryptedKey)));
                keyLines.add(Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray()));
            }
            keyLines.add(END_CRYPT4GH_ENCRYPTED_PRIVATE_KEY);
        }
        IOUtils.writeLines(keyLines, null, (Writer)writer);
    }

    public void writeOpenSSLKey(File keyFile, Key key) throws IOException {
        try (FileWriter fileWriter = new FileWriter(keyFile);){
            this.writeOpenSSLKey(fileWriter, key);
        }
    }

    public void writeCrypt4GHKey(File keyFile, Key key, char[] password) throws IOException, GeneralSecurityException {
        try (FileWriter fileWriter = new FileWriter(keyFile);){
            this.writeCrypt4GHKey(fileWriter, key, password);
        }
    }

    private String decodeString(ByteBuffer byteBuffer) {
        short length = byteBuffer.getShort();
        return new String(this.decodeArray(byteBuffer, length));
    }

    private byte[] decodeArray(ByteBuffer byteBuffer, int length) {
        byte[] array = new byte[length];
        byteBuffer.get(array);
        return array;
    }

    private byte[] encodeString(String string) {
        short length = (short)string.length();
        return ByteBuffer.allocate(2 + length).order(ByteOrder.BIG_ENDIAN).putShort(length).put(string.getBytes()).array();
    }

    private byte[] encodeArray(byte[] array) {
        short length = (short)array.length;
        return ByteBuffer.allocate(2 + length).order(ByteOrder.BIG_ENDIAN).putShort(length).put(array).array();
    }

    private static class StaticSecureRandom
    extends SecureRandom {
        private final byte[] privateKey;

        StaticSecureRandom(byte[] privateKey) {
            this.privateKey = (byte[])privateKey.clone();
        }

        @Override
        public void nextBytes(byte[] bytes) {
            System.arraycopy(this.privateKey, 0, bytes, 0, this.privateKey.length);
        }
    }
}

