/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.util;

import com.rfksystems.blake2b.security.Blake2bProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import no.uio.ifi.crypt4gh.pojo.header.Header;
import no.uio.ifi.crypt4gh.pojo.header.HeaderEncryptionMethod;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.X25519ChaCha20IETFPoly1305HeaderPacket;
import no.uio.ifi.crypt4gh.stream.Crypt4GHInputStream;

public class Crypt4GHUtils {
    private static Crypt4GHUtils ourInstance = new Crypt4GHUtils();

    public static Crypt4GHUtils getInstance() {
        return ourInstance;
    }

    private Crypt4GHUtils() {
        Security.addProvider((Provider)new Blake2bProvider());
    }

    public Header setRecipient(byte[] serializedHeader, PrivateKey privateKeyForDecryption, PublicKey newRecipientPublicKey) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream headerInputStream = new ByteArrayInputStream(serializedHeader);){
            Header header;
            try (Crypt4GHInputStream crypt4GHInputStream = new Crypt4GHInputStream(headerInputStream, privateKeyForDecryption);){
                Header header2 = crypt4GHInputStream.getHeader();
                List<HeaderPacket> headerPacketsWithNewRecipient = this.getHeaderPacketsWithNewRecipient(header2, privateKeyForDecryption, newRecipientPublicKey);
                header = new Header(headerPacketsWithNewRecipient);
            }
            return header;
        }
    }

    public Header addRecipient(byte[] serializedHeader, PrivateKey privateKeyForDecryption, PublicKey newRecipientPublicKey) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream headerInputStream = new ByteArrayInputStream(serializedHeader);){
            Header header;
            try (Crypt4GHInputStream crypt4GHInputStream = new Crypt4GHInputStream(headerInputStream, privateKeyForDecryption);){
                Header header2 = crypt4GHInputStream.getHeader();
                List<HeaderPacket> headerPacketsWithNewRecipient = this.getHeaderPacketsWithNewRecipient(header2, privateKeyForDecryption, newRecipientPublicKey);
                header2.getHeaderPackets().addAll(headerPacketsWithNewRecipient);
                header = header2;
            }
            return header;
        }
    }

    private List<HeaderPacket> getHeaderPacketsWithNewRecipient(Header header, PrivateKey privateKeyForDecryption, PublicKey newRecipientPublicKey) throws IOException, GeneralSecurityException {
        ArrayList<HeaderPacket> result = new ArrayList<HeaderPacket>();
        block3: for (HeaderPacket headerPacket : header.getHeaderPackets()) {
            HeaderEncryptionMethod packetEncryption = headerPacket.getPacketEncryption();
            switch (packetEncryption) {
                case X25519_CHACHA20_IETF_POLY1305: {
                    X25519ChaCha20IETFPoly1305HeaderPacket newHeaderPacket = new X25519ChaCha20IETFPoly1305HeaderPacket(headerPacket.getEncryptablePayload(), privateKeyForDecryption, newRecipientPublicKey);
                    result.add(newHeaderPacket);
                    continue block3;
                }
            }
            throw new GeneralSecurityException("Header Encryption Method not supported: " + packetEncryption.getCode());
        }
        return result;
    }
}

