/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.crypto.SecretKey;
import no.uio.ifi.crypt4gh.pojo.body.Segment;
import no.uio.ifi.crypt4gh.pojo.header.ChaCha20IETFPoly1305EncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.DataEditList;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.Header;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.X25519ChaCha20IETFPoly1305HeaderPacket;
import no.uio.ifi.crypt4gh.util.KeyUtils;

public class Crypt4GHOutputStream
extends FilterOutputStream {
    private Header header;
    private byte[] buffer = new byte[65536];
    private int bytesCached;
    private DataEncryptionParameters dataEncryptionParameters;

    public Crypt4GHOutputStream(OutputStream out, PrivateKey writerPrivateKey, PublicKey readerPublicKey) throws IOException, GeneralSecurityException {
        super(out);
        KeyUtils keyUtils = KeyUtils.getInstance();
        SecretKey dataKey = keyUtils.generateSessionKey();
        this.dataEncryptionParameters = new ChaCha20IETFPoly1305EncryptionParameters(dataKey);
        X25519ChaCha20IETFPoly1305HeaderPacket headerPacket = new X25519ChaCha20IETFPoly1305HeaderPacket(this.dataEncryptionParameters, writerPrivateKey, readerPublicKey);
        List<HeaderPacket> headerPackets = Collections.singletonList(headerPacket);
        this.header = new Header(headerPackets);
        out.write(this.header.serialize());
    }

    public Crypt4GHOutputStream(OutputStream out, DataEditList dataEditList, PrivateKey writerPrivateKey, PublicKey readerPublicKey) throws IOException, GeneralSecurityException {
        super(out);
        KeyUtils keyUtils = KeyUtils.getInstance();
        SecretKey dataKey = keyUtils.generateSessionKey();
        this.dataEncryptionParameters = new ChaCha20IETFPoly1305EncryptionParameters(dataKey);
        X25519ChaCha20IETFPoly1305HeaderPacket dataEncryptionParametersHeaderPacket = new X25519ChaCha20IETFPoly1305HeaderPacket(this.dataEncryptionParameters, writerPrivateKey, readerPublicKey);
        X25519ChaCha20IETFPoly1305HeaderPacket dataEditListHeaderPacket = new X25519ChaCha20IETFPoly1305HeaderPacket(dataEditList, writerPrivateKey, readerPublicKey);
        ArrayList<HeaderPacket> headerPackets = new ArrayList<HeaderPacket>(List.of(dataEncryptionParametersHeaderPacket, dataEditListHeaderPacket));
        this.header = new Header(headerPackets);
        out.write(this.header.serialize());
    }

    public Header getHeader() {
        return this.header;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.bytesCached == this.buffer.length) {
            try {
                this.flushBuffer();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        this.buffer[this.bytesCached++] = (byte)b;
    }

    protected void flushBuffer() throws IOException, GeneralSecurityException {
        Segment segment = Segment.create(Arrays.copyOfRange(this.buffer, 0, this.bytesCached), this.dataEncryptionParameters);
        this.out.write(segment.serialize());
        this.bytesCached = 0;
    }

    @Override
    public void flush() throws IOException {
        try {
            this.flushBuffer();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        super.flush();
    }
}

