/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import no.uio.ifi.crypt4gh.pojo.body.Segment;
import no.uio.ifi.crypt4gh.pojo.header.DataEditList;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Crypt4GHInputStreamInternal
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(Crypt4GHInputStreamInternal.class);
    private Header header;
    private int[] buffer;
    private int bytesRead;
    private Collection<DataEncryptionParameters> dataEncryptionParametersList;
    private Optional<DataEditList> dataEditList;
    private int encryptedSegmentSize;
    private int lastDecryptedSegment = -1;

    Crypt4GHInputStreamInternal(InputStream in, PrivateKey readerPrivateKey) throws IOException, GeneralSecurityException {
        super(in);
        this.header = new Header(in, readerPrivateKey);
        this.dataEncryptionParametersList = this.header.getDataEncryptionParametersList();
        DataEncryptionParameters firstDataEncryptionParameters = this.dataEncryptionParametersList.iterator().next();
        for (DataEncryptionParameters encryptionParameters : this.dataEncryptionParametersList) {
            if (firstDataEncryptionParameters.getDataEncryptionMethod() == encryptionParameters.getDataEncryptionMethod()) continue;
            throw new GeneralSecurityException("Different Data Encryption Methods are not supported");
        }
        this.encryptedSegmentSize = firstDataEncryptionParameters.getDataEncryptionMethod().getEncryptedSegmentSize();
        this.dataEditList = this.header.getDataEditList();
    }

    Optional<DataEditList> getDataEditList() {
        return this.dataEditList;
    }

    Header getHeader() {
        return this.header;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null || this.buffer.length == this.bytesRead) {
            this.fillBuffer();
        }
        return this.buffer[this.bytesRead++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException ee) {
            log.error(ee.getMessage(), (Throwable)ee);
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        long delta;
        long currentDecryptedPosition;
        long newDecryptedPosition;
        long newSegmentNumber;
        if (n <= 0L) {
            return 0L;
        }
        if (this.buffer == null || this.buffer.length == this.bytesRead) {
            this.fillBuffer();
        }
        if ((newSegmentNumber = (newDecryptedPosition = (currentDecryptedPosition = (long)(this.lastDecryptedSegment * 65536 + this.bytesRead)) + n) / 65536L) != (long)this.lastDecryptedSegment) {
            long segmentsToSkip = newSegmentNumber - (long)this.lastDecryptedSegment - 1L;
            this.skipSegments(segmentsToSkip);
            this.fillBuffer();
            currentDecryptedPosition = this.lastDecryptedSegment * 65536;
        }
        if ((long)this.bytesRead + (delta = newDecryptedPosition - currentDecryptedPosition) > (long)this.buffer.length) {
            long missingBytes = (long)this.bytesRead + delta - (long)this.buffer.length;
            this.bytesRead = (int)((long)this.bytesRead + (delta - missingBytes));
            return n - missingBytes;
        }
        this.bytesRead = (int)((long)this.bytesRead + delta);
        return n;
    }

    private synchronized void skipSegments(long n) throws IOException {
        this.in.skip(n * (long)this.encryptedSegmentSize);
        this.lastDecryptedSegment = (int)((long)this.lastDecryptedSegment + n);
    }

    private synchronized void fillBuffer() throws IOException {
        try {
            byte[] encryptedSegmentBytes = this.in.readNBytes(this.encryptedSegmentSize);
            if (encryptedSegmentBytes.length == 0) {
                Arrays.fill(this.buffer, -1);
            } else {
                this.decryptSegment(encryptedSegmentBytes);
            }
            this.bytesRead = 0;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized void decryptSegment(byte[] encryptedSegmentBytes) throws GeneralSecurityException {
        Segment segment = Segment.create(encryptedSegmentBytes, this.dataEncryptionParametersList);
        byte[] unencryptedData = segment.getUnencryptedData();
        this.buffer = new int[unencryptedData.length];
        for (int i = 0; i < unencryptedData.length; ++i) {
            this.buffer[i] = unencryptedData[i] & 0xFF;
        }
        ++this.lastDecryptedSegment;
    }
}

