/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import no.uio.ifi.crypt4gh.pojo.header.DataEditList;
import no.uio.ifi.crypt4gh.pojo.header.Header;
import no.uio.ifi.crypt4gh.stream.Crypt4GHInputStreamInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypt4GHInputStream
extends FilterInputStream {
    private static final Logger log = LoggerFactory.getLogger(Crypt4GHInputStream.class);
    private boolean useDataEditList;
    private Queue<DataEditListEntry> lengths = new ArrayDeque<DataEditListEntry>();
    private long bytesRead;

    public Crypt4GHInputStream(InputStream in, PrivateKey readerPrivateKey) throws IOException, GeneralSecurityException {
        super(new Crypt4GHInputStreamInternal(in, readerPrivateKey));
        Optional<DataEditList> dataEditListOptional = ((Crypt4GHInputStreamInternal)this.in).getDataEditList();
        this.useDataEditList = dataEditListOptional.isPresent();
        long[] lengthsArray = dataEditListOptional.map(DataEditList::getLengths).orElse(new long[0]);
        boolean skip = true;
        for (long length : lengthsArray) {
            this.lengths.add(new DataEditListEntry(length, skip));
            skip = !skip;
        }
    }

    public Crypt4GHInputStream(InputStream in, DataEditList dataEditList, PrivateKey readerPrivateKey) throws IOException, GeneralSecurityException {
        super(new Crypt4GHInputStreamInternal(in, readerPrivateKey));
        this.useDataEditList = true;
        long[] lengthsArray = dataEditList.getLengths();
        boolean skip = true;
        for (long length : lengthsArray) {
            this.lengths.add(new DataEditListEntry(length, skip));
            skip = !skip;
        }
    }

    public Header getHeader() {
        return ((Crypt4GHInputStreamInternal)this.in).getHeader();
    }

    @Override
    public int read() throws IOException {
        return this.useDataEditList ? this.readWithDataEditList() : this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                b[off + i] = (byte)c;
            }
        }
        catch (IOException ee) {
            log.error(ee.getMessage(), (Throwable)ee);
        }
        return i;
    }

    private synchronized int readWithDataEditList() throws IOException {
        DataEditListEntry dataEditListEntry;
        if (!this.lengths.isEmpty()) {
            dataEditListEntry = this.lengths.peek();
            if (dataEditListEntry.skip) {
                this.in.skip(dataEditListEntry.length);
                this.lengths.remove();
            }
        }
        if (!this.lengths.isEmpty()) {
            dataEditListEntry = this.lengths.peek();
            long length = dataEditListEntry.length;
            if (this.bytesRead == length) {
                this.lengths.remove();
                this.bytesRead = 0L;
                return this.readWithDataEditList();
            }
            ++this.bytesRead;
            return this.in.read();
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.useDataEditList ? this.skipWithDataEditList(n) : this.in.skip(n);
    }

    private synchronized long skipWithDataEditList(long n) throws IOException {
        long length;
        DataEditListEntry dataEditListEntry;
        long bytesSkipped = 0L;
        if (!this.lengths.isEmpty()) {
            dataEditListEntry = this.lengths.peek();
            if (dataEditListEntry.skip) {
                this.in.skip(dataEditListEntry.length);
                this.lengths.remove();
            } else {
                length = dataEditListEntry.length;
                if (this.bytesRead == length) {
                    this.lengths.remove();
                    this.bytesRead = 0L;
                } else {
                    long bytesLeftToRead = length - this.bytesRead;
                    if (n <= bytesLeftToRead) {
                        this.bytesRead += n;
                        return this.in.skip(n);
                    }
                    bytesSkipped += this.in.skip(bytesLeftToRead);
                    n -= bytesLeftToRead;
                    this.lengths.remove();
                    this.bytesRead = 0L;
                }
            }
        }
        while (!this.lengths.isEmpty() && n != 0L) {
            dataEditListEntry = this.lengths.peek();
            if (dataEditListEntry.skip) {
                this.in.skip(dataEditListEntry.length);
                this.lengths.remove();
                continue;
            }
            length = dataEditListEntry.length;
            if (n <= length) {
                long bytesSkippedJustNow = this.in.skip(n);
                this.bytesRead += bytesSkippedJustNow;
                return bytesSkipped += bytesSkippedJustNow;
            }
            bytesSkipped += this.in.skip(length);
            n -= length;
            this.lengths.remove();
        }
        return bytesSkipped;
    }

    private static class DataEditListEntry {
        private long length;
        private boolean skip;

        public String toString() {
            return "Crypt4GHInputStream.DataEditListEntry(length=" + this.getLength() + ", skip=" + this.isSkip() + ")";
        }

        public DataEditListEntry(long length, boolean skip) {
            this.length = length;
            this.skip = skip;
        }

        public long getLength() {
            return this.length;
        }

        public boolean isSkip() {
            return this.skip;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public void setSkip(boolean skip) {
            this.skip = skip;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataEditListEntry)) {
                return false;
            }
            DataEditListEntry other = (DataEditListEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLength() != other.getLength()) {
                return false;
            }
            return this.isSkip() == other.isSkip();
        }

        protected boolean canEqual(Object other) {
            return other instanceof DataEditListEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $length = this.getLength();
            result = result * 59 + (int)($length >>> 32 ^ $length);
            result = result * 59 + (this.isSkip() ? 79 : 97);
            return result;
        }
    }
}

