/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.key;

import at.favre.lib.crypto.bkdf.BKDF;
import com.lambdaworks.crypto.SCrypt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public enum KDF {
    SCRYPT,
    BCRYPT,
    PBKDF2_HMAC_SHA256,
    NONE;

    public static final int KEY_LENGTH = 32;
    public static final String PBKDF_2_WITH_HMAC_SHA_256 = "PBKDF2WithHmacSHA256";

    public byte[] derive(int rounds, char[] password, byte[] salt) throws GeneralSecurityException {
        switch (this) {
            case SCRYPT: {
                return SCrypt.scrypt((byte[])this.toBytes(password), (byte[])salt, (int)16384, (int)8, (int)1, (int)32);
            }
            case BCRYPT: {
                return BKDF.createKdf().derive(salt, password, (int)(Math.log(rounds) / Math.log(2.0)), null, 32);
            }
            case PBKDF2_HMAC_SHA256: {
                PBEKeySpec spec = new PBEKeySpec(password, salt, rounds, 32);
                SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF_2_WITH_HMAC_SHA_256);
                return factory.generateSecret(spec).getEncoded();
            }
            case NONE: {
                throw new GeneralSecurityException("Can't derive key with 'none' KDF");
            }
        }
        throw new GeneralSecurityException("KDF not found");
    }

    private byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

