/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import no.uio.ifi.crypt4gh.pojo.EncryptableEntity;
import no.uio.ifi.crypt4gh.pojo.header.EncryptableHeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.HeaderEncryptionMethod;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacket;
import no.uio.ifi.crypt4gh.util.KeyUtils;
import org.apache.commons.lang3.ArrayUtils;

public class X25519ChaCha20IETFPoly1305HeaderPacket
extends HeaderPacket
implements EncryptableEntity {
    public static final String CHA_CHA_20_POLY_1305 = "ChaCha20-Poly1305";
    public static final int NONCE_SIZE = 12;
    public static final int MAC_SIZE = 16;
    private PublicKey writerPublicKey;
    private byte[] nonce = new byte[12];
    private byte[] encryptedPayload;
    private byte[] mac = new byte[16];

    public X25519ChaCha20IETFPoly1305HeaderPacket(EncryptableHeaderPacket encryptablePayload, PrivateKey writerPrivateKey, PublicKey readerPublicKey) throws GeneralSecurityException, IOException {
        this.packetEncryption = HeaderEncryptionMethod.X25519_CHACHA20_IETF_POLY1305;
        this.writerPublicKey = KeyUtils.getInstance().derivePublicKey(writerPrivateKey);
        this.encryptablePayload = encryptablePayload;
        SecretKey sharedKey = KeyUtils.getInstance().generateWriterSharedKey(writerPrivateKey, readerPublicKey);
        this.encrypt(encryptablePayload.serialize(), sharedKey);
        this.packetLength = 52 + this.encryptedPayload.length + 16;
    }

    public X25519ChaCha20IETFPoly1305HeaderPacket(int packetLength, byte[] headerPacketBody, PrivateKey readerPrivateKey) throws IOException, GeneralSecurityException {
        this.packetEncryption = HeaderEncryptionMethod.X25519_CHACHA20_IETF_POLY1305;
        this.writerPublicKey = KeyUtils.getInstance().constructPublicKey(Arrays.copyOfRange(headerPacketBody, 0, 32));
        this.nonce = Arrays.copyOfRange(headerPacketBody, 32, 44);
        this.encryptedPayload = Arrays.copyOfRange(headerPacketBody, 44, headerPacketBody.length - 16);
        this.mac = Arrays.copyOfRange(headerPacketBody, headerPacketBody.length - 16, headerPacketBody.length);
        this.packetLength = packetLength;
        SecretKey sharedKey = KeyUtils.getInstance().generateReaderSharedKey(readerPrivateKey, this.writerPublicKey);
        byte[] decryptedPayloadBytes = this.decrypt(sharedKey);
        this.encryptablePayload = EncryptableHeaderPacket.create(new ByteArrayInputStream(decryptedPayloadBytes));
    }

    @Override
    public byte[] serialize() throws IOException, GeneralSecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.packetLength).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.packetEncryption.getCode()).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(32).order(ByteOrder.LITTLE_ENDIAN).put(KeyUtils.getInstance().encodeKey(this.writerPublicKey)).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN).put(this.nonce).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(this.encryptedPayload.length).order(ByteOrder.LITTLE_ENDIAN).put(this.encryptedPayload).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).put(this.mac).array());
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encrypt(byte[] unencryptedBytes, SecretKey sharedKey) throws GeneralSecurityException {
        SecureRandom.getInstanceStrong().nextBytes(this.nonce);
        Cipher cipher = Cipher.getInstance(CHA_CHA_20_POLY_1305);
        cipher.init(1, (Key)sharedKey, new IvParameterSpec(this.nonce));
        byte[] encryptedPayloadWithMAC = cipher.doFinal(unencryptedBytes);
        this.encryptedPayload = Arrays.copyOfRange(encryptedPayloadWithMAC, 0, encryptedPayloadWithMAC.length - 16);
        this.mac = Arrays.copyOfRange(encryptedPayloadWithMAC, encryptedPayloadWithMAC.length - 16, encryptedPayloadWithMAC.length);
    }

    @Override
    public byte[] decrypt(SecretKey sharedKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(CHA_CHA_20_POLY_1305);
        cipher.init(2, (Key)sharedKey, new IvParameterSpec(this.nonce));
        return cipher.doFinal(ArrayUtils.addAll((byte[])this.encryptedPayload, (byte[])this.mac));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X25519ChaCha20IETFPoly1305HeaderPacket)) {
            return false;
        }
        X25519ChaCha20IETFPoly1305HeaderPacket other = (X25519ChaCha20IETFPoly1305HeaderPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicKey this$writerPublicKey = this.getWriterPublicKey();
        PublicKey other$writerPublicKey = other.getWriterPublicKey();
        if (this$writerPublicKey == null ? other$writerPublicKey != null : !this$writerPublicKey.equals(other$writerPublicKey)) {
            return false;
        }
        if (!Arrays.equals(this.getNonce(), other.getNonce())) {
            return false;
        }
        if (!Arrays.equals(this.getEncryptedPayload(), other.getEncryptedPayload())) {
            return false;
        }
        return Arrays.equals(this.getMac(), other.getMac());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof X25519ChaCha20IETFPoly1305HeaderPacket;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PublicKey $writerPublicKey = this.getWriterPublicKey();
        result = result * 59 + ($writerPublicKey == null ? 43 : $writerPublicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getNonce());
        result = result * 59 + Arrays.hashCode(this.getEncryptedPayload());
        result = result * 59 + Arrays.hashCode(this.getMac());
        return result;
    }

    @Override
    public String toString() {
        return "X25519ChaCha20IETFPoly1305HeaderPacket(writerPublicKey=" + this.getWriterPublicKey() + ", nonce=" + Arrays.toString(this.getNonce()) + ", encryptedPayload=" + Arrays.toString(this.getEncryptedPayload()) + ", mac=" + Arrays.toString(this.getMac()) + ")";
    }

    public PublicKey getWriterPublicKey() {
        return this.writerPublicKey;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getEncryptedPayload() {
        return this.encryptedPayload;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public void setWriterPublicKey(PublicKey writerPublicKey) {
        this.writerPublicKey = writerPublicKey;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void setEncryptedPayload(byte[] encryptedPayload) {
        this.encryptedPayload = encryptedPayload;
    }

    public void setMac(byte[] mac) {
        this.mac = mac;
    }
}

