/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Optional;
import no.uio.ifi.crypt4gh.pojo.Crypt4GHEntity;
import no.uio.ifi.crypt4gh.pojo.header.EncryptableHeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.HeaderEncryptionMethod;
import no.uio.ifi.crypt4gh.pojo.header.X25519ChaCha20IETFPoly1305HeaderPacket;

public abstract class HeaderPacket
implements Crypt4GHEntity {
    protected int packetLength;
    protected HeaderEncryptionMethod packetEncryption;
    protected EncryptableHeaderPacket encryptablePayload;

    static Optional<HeaderPacket> create(InputStream inputStream, PrivateKey readerPrivateKey) throws IOException, GeneralSecurityException {
        int packetLength = Crypt4GHEntity.getInt(inputStream.readNBytes(4));
        int packetEncryptionCode = Crypt4GHEntity.getInt(inputStream.readNBytes(4));
        HeaderEncryptionMethod packetEncryption = HeaderEncryptionMethod.getByCode(packetEncryptionCode);
        byte[] encryptedPayload = inputStream.readNBytes(packetLength - 4 - 4);
        switch (packetEncryption) {
            case X25519_CHACHA20_IETF_POLY1305: {
                try {
                    return Optional.of(new X25519ChaCha20IETFPoly1305HeaderPacket(packetLength, encryptedPayload, readerPrivateKey));
                }
                catch (GeneralSecurityException e) {
                    return Optional.empty();
                }
            }
        }
        throw new GeneralSecurityException("Header Encryption Method not found for code: " + packetEncryptionCode);
    }

    public String toString() {
        return "HeaderPacket(packetLength=" + this.getPacketLength() + ", packetEncryption=" + this.getPacketEncryption() + ", encryptablePayload=" + this.getEncryptablePayload() + ")";
    }

    public int getPacketLength() {
        return this.packetLength;
    }

    public HeaderEncryptionMethod getPacketEncryption() {
        return this.packetEncryption;
    }

    public EncryptableHeaderPacket getEncryptablePayload() {
        return this.encryptablePayload;
    }

    public void setPacketLength(int packetLength) {
        this.packetLength = packetLength;
    }

    public void setPacketEncryption(HeaderEncryptionMethod packetEncryption) {
        this.packetEncryption = packetEncryption;
    }

    public void setEncryptablePayload(EncryptableHeaderPacket encryptablePayload) {
        this.encryptablePayload = encryptablePayload;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeaderPacket)) {
            return false;
        }
        HeaderPacket other = (HeaderPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPacketLength() != other.getPacketLength()) {
            return false;
        }
        HeaderEncryptionMethod this$packetEncryption = this.getPacketEncryption();
        HeaderEncryptionMethod other$packetEncryption = other.getPacketEncryption();
        if (this$packetEncryption == null ? other$packetEncryption != null : !((Object)((Object)this$packetEncryption)).equals((Object)other$packetEncryption)) {
            return false;
        }
        EncryptableHeaderPacket this$encryptablePayload = this.getEncryptablePayload();
        EncryptableHeaderPacket other$encryptablePayload = other.getEncryptablePayload();
        return !(this$encryptablePayload == null ? other$encryptablePayload != null : !((Object)this$encryptablePayload).equals(other$encryptablePayload));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeaderPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPacketLength();
        HeaderEncryptionMethod $packetEncryption = this.getPacketEncryption();
        result = result * 59 + ($packetEncryption == null ? 43 : ((Object)((Object)$packetEncryption)).hashCode());
        EncryptableHeaderPacket $encryptablePayload = this.getEncryptablePayload();
        result = result * 59 + ($encryptablePayload == null ? 43 : ((Object)$encryptablePayload).hashCode());
        return result;
    }
}

