/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import no.uio.ifi.crypt4gh.pojo.Crypt4GHEntity;
import no.uio.ifi.crypt4gh.pojo.header.DataEditList;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.EncryptableHeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacketType;

public class Header
implements Crypt4GHEntity {
    public static final int UNENCRYPTED_HEADER_LENGTH = 16;
    public static final String MAGIC_WORD = "crypt4gh";
    public static final int VERSION = 1;
    private final List<HeaderPacket> headerPackets;

    public Header(InputStream inputStream, PrivateKey readerPrivateKey) throws IOException, GeneralSecurityException {
        byte[] unencryptedHeaderBytes = inputStream.readNBytes(16);
        String magicWord = new String(Arrays.copyOfRange(unencryptedHeaderBytes, 0, 8));
        if (!MAGIC_WORD.equals(magicWord)) {
            throw new GeneralSecurityException("Not a Crypt4GH stream");
        }
        int version = Crypt4GHEntity.getInt(Arrays.copyOfRange(unencryptedHeaderBytes, 8, 12));
        if (1 != version) {
            throw new GeneralSecurityException("Unsupported Crypt4GH version: " + version);
        }
        int headerPacketCount = Crypt4GHEntity.getInt(Arrays.copyOfRange(unencryptedHeaderBytes, 12, 16));
        this.headerPackets = new ArrayList<HeaderPacket>();
        for (int i = 0; i < headerPacketCount; ++i) {
            Optional<HeaderPacket> headerPacketOptional = HeaderPacket.create(inputStream, readerPrivateKey);
            headerPacketOptional.ifPresent(this.headerPackets::add);
        }
    }

    public Collection<DataEncryptionParameters> getDataEncryptionParametersList() throws GeneralSecurityException {
        ArrayList<DataEncryptionParameters> result = new ArrayList<DataEncryptionParameters>();
        for (HeaderPacket headerPacket : this.headerPackets) {
            EncryptableHeaderPacket encryptablePayload = headerPacket.getEncryptablePayload();
            HeaderPacketType packetType = encryptablePayload.getPacketType();
            if (packetType != HeaderPacketType.DATA_ENCRYPTION_PARAMETERS) continue;
            result.add((DataEncryptionParameters)encryptablePayload);
        }
        if (result.isEmpty()) {
            throw new GeneralSecurityException("Data Encryption Parameters not found in the Header");
        }
        return result;
    }

    public void removeDataEditList() {
        Iterator<HeaderPacket> iterator = this.headerPackets.iterator();
        while (iterator.hasNext()) {
            HeaderPacket headerPacket = iterator.next();
            EncryptableHeaderPacket encryptablePayload = headerPacket.getEncryptablePayload();
            HeaderPacketType packetType = encryptablePayload.getPacketType();
            if (packetType != HeaderPacketType.DATA_EDIT_LIST) continue;
            iterator.remove();
        }
    }

    public Optional<DataEditList> getDataEditList() {
        for (HeaderPacket headerPacket : this.headerPackets) {
            EncryptableHeaderPacket encryptablePayload = headerPacket.getEncryptablePayload();
            HeaderPacketType packetType = encryptablePayload.getPacketType();
            if (packetType != HeaderPacketType.DATA_EDIT_LIST) continue;
            return Optional.of((DataEditList)encryptablePayload);
        }
        return Optional.empty();
    }

    @Override
    public byte[] serialize() throws IOException, GeneralSecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).put(MAGIC_WORD.getBytes()).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(1).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.headerPackets.size()).array());
        for (HeaderPacket headerPacket : this.headerPackets) {
            byteArrayOutputStream.write(headerPacket.serialize());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String toString() {
        return "Header(headerPackets=" + this.getHeaderPackets() + ")";
    }

    public Header(List<HeaderPacket> headerPackets) {
        this.headerPackets = headerPackets;
    }

    public List<HeaderPacket> getHeaderPackets() {
        return this.headerPackets;
    }
}

