/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import no.uio.ifi.crypt4gh.pojo.Crypt4GHEntity;
import no.uio.ifi.crypt4gh.pojo.header.DataEditList;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacketType;

public abstract class EncryptableHeaderPacket
implements Crypt4GHEntity {
    protected HeaderPacketType packetType;

    static EncryptableHeaderPacket create(InputStream inputStream) throws IOException, GeneralSecurityException {
        int headerPacketTypeCode = Crypt4GHEntity.getInt(inputStream.readNBytes(4));
        HeaderPacketType headerPacketType = HeaderPacketType.getByCode(headerPacketTypeCode);
        switch (headerPacketType) {
            case DATA_ENCRYPTION_PARAMETERS: {
                return DataEncryptionParameters.create(inputStream);
            }
            case DATA_EDIT_LIST: {
                return new DataEditList(inputStream);
            }
        }
        throw new GeneralSecurityException("Header Packet Type not found for code: " + headerPacketTypeCode);
    }

    public String toString() {
        return "EncryptableHeaderPacket(packetType=" + this.getPacketType() + ")";
    }

    public HeaderPacketType getPacketType() {
        return this.packetType;
    }

    public void setPacketType(HeaderPacketType packetType) {
        this.packetType = packetType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptableHeaderPacket)) {
            return false;
        }
        EncryptableHeaderPacket other = (EncryptableHeaderPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HeaderPacketType this$packetType = this.getPacketType();
        HeaderPacketType other$packetType = other.getPacketType();
        return !(this$packetType == null ? other$packetType != null : !((Object)((Object)this$packetType)).equals((Object)other$packetType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EncryptableHeaderPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HeaderPacketType $packetType = this.getPacketType();
        result = result * 59 + ($packetType == null ? 43 : ((Object)((Object)$packetType)).hashCode());
        return result;
    }
}

