/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import no.uio.ifi.crypt4gh.pojo.Crypt4GHEntity;
import no.uio.ifi.crypt4gh.pojo.header.ChaCha20IETFPoly1305EncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionMethod;
import no.uio.ifi.crypt4gh.pojo.header.EncryptableHeaderPacket;

public abstract class DataEncryptionParameters
extends EncryptableHeaderPacket {
    protected DataEncryptionMethod dataEncryptionMethod;

    public static DataEncryptionParameters create(InputStream inputStream) throws IOException, GeneralSecurityException {
        int dataEncryptionMethodCode = Crypt4GHEntity.getInt(inputStream.readNBytes(4));
        DataEncryptionMethod dataEncryptionMethod = DataEncryptionMethod.getByCode(dataEncryptionMethodCode);
        switch (dataEncryptionMethod) {
            case CHACHA20_IETF_POLY1305: {
                return new ChaCha20IETFPoly1305EncryptionParameters(inputStream);
            }
        }
        throw new GeneralSecurityException("Data Encryption Method not found for code: " + dataEncryptionMethodCode);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEncryptionParameters)) {
            return false;
        }
        DataEncryptionParameters other = (DataEncryptionParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataEncryptionMethod this$dataEncryptionMethod = this.getDataEncryptionMethod();
        DataEncryptionMethod other$dataEncryptionMethod = other.getDataEncryptionMethod();
        return !(this$dataEncryptionMethod == null ? other$dataEncryptionMethod != null : !((Object)((Object)this$dataEncryptionMethod)).equals((Object)other$dataEncryptionMethod));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataEncryptionParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DataEncryptionMethod $dataEncryptionMethod = this.getDataEncryptionMethod();
        result = result * 59 + ($dataEncryptionMethod == null ? 43 : ((Object)((Object)$dataEncryptionMethod)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DataEncryptionParameters(dataEncryptionMethod=" + this.getDataEncryptionMethod() + ")";
    }

    public DataEncryptionMethod getDataEncryptionMethod() {
        return this.dataEncryptionMethod;
    }

    public void setDataEncryptionMethod(DataEncryptionMethod dataEncryptionMethod) {
        this.dataEncryptionMethod = dataEncryptionMethod;
    }
}

