/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import no.uio.ifi.crypt4gh.pojo.Crypt4GHEntity;
import no.uio.ifi.crypt4gh.pojo.header.EncryptableHeaderPacket;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacketType;

public class DataEditList
extends EncryptableHeaderPacket {
    private int numberLengths;
    private long[] lengths;

    public DataEditList(long[] lengths) {
        this.packetType = HeaderPacketType.DATA_EDIT_LIST;
        this.numberLengths = lengths.length;
        this.lengths = lengths;
    }

    DataEditList(InputStream inputStream) throws IOException {
        this.packetType = HeaderPacketType.DATA_EDIT_LIST;
        this.numberLengths = Crypt4GHEntity.getInt(inputStream.readNBytes(4));
        this.lengths = new long[this.numberLengths];
        for (int i = 0; i < this.numberLengths; ++i) {
            this.lengths[i] = Crypt4GHEntity.getLong(inputStream.readNBytes(8));
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.packetType.getCode()).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.numberLengths).array());
        for (long length : this.lengths) {
            byteArrayOutputStream.write(ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(length).array());
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataEditList)) {
            return false;
        }
        DataEditList other = (DataEditList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getNumberLengths() != other.getNumberLengths()) {
            return false;
        }
        return Arrays.equals(this.getLengths(), other.getLengths());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DataEditList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getNumberLengths();
        result = result * 59 + Arrays.hashCode(this.getLengths());
        return result;
    }

    @Override
    public String toString() {
        return "DataEditList(numberLengths=" + this.getNumberLengths() + ", lengths=" + Arrays.toString(this.getLengths()) + ")";
    }

    public int getNumberLengths() {
        return this.numberLengths;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public void setNumberLengths(int numberLengths) {
        this.numberLengths = numberLengths;
    }

    public void setLengths(long[] lengths) {
        this.lengths = lengths;
    }
}

