/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.header;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionMethod;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.HeaderPacketType;

public class ChaCha20IETFPoly1305EncryptionParameters
extends DataEncryptionParameters {
    public static final String CHA_CHA_20 = "ChaCha20";
    private SecretKey dataKey;

    public ChaCha20IETFPoly1305EncryptionParameters(SecretKey dataKey) {
        this.packetType = HeaderPacketType.DATA_ENCRYPTION_PARAMETERS;
        this.dataEncryptionMethod = DataEncryptionMethod.CHACHA20_IETF_POLY1305;
        this.dataKey = dataKey;
    }

    ChaCha20IETFPoly1305EncryptionParameters(InputStream inputStream) throws IOException {
        this.packetType = HeaderPacketType.DATA_ENCRYPTION_PARAMETERS;
        this.dataEncryptionMethod = DataEncryptionMethod.CHACHA20_IETF_POLY1305;
        this.dataKey = new SecretKeySpec(inputStream.readNBytes(32), CHA_CHA_20);
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.packetType.getCode()).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.dataEncryptionMethod.getCode()).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(32).order(ByteOrder.LITTLE_ENDIAN).put(this.dataKey.getEncoded()).array());
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChaCha20IETFPoly1305EncryptionParameters)) {
            return false;
        }
        ChaCha20IETFPoly1305EncryptionParameters other = (ChaCha20IETFPoly1305EncryptionParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretKey this$dataKey = this.getDataKey();
        SecretKey other$dataKey = other.getDataKey();
        return !(this$dataKey == null ? other$dataKey != null : !this$dataKey.equals(other$dataKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChaCha20IETFPoly1305EncryptionParameters;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SecretKey $dataKey = this.getDataKey();
        result = result * 59 + ($dataKey == null ? 43 : $dataKey.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ChaCha20IETFPoly1305EncryptionParameters(dataKey=" + this.getDataKey() + ")";
    }

    public SecretKey getDataKey() {
        return this.dataKey;
    }

    public void setDataKey(SecretKey dataKey) {
        this.dataKey = dataKey;
    }
}

