/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.body;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import no.uio.ifi.crypt4gh.pojo.Crypt4GHEntity;
import no.uio.ifi.crypt4gh.pojo.body.ChaCha20IETFPoly1305Segment;
import no.uio.ifi.crypt4gh.pojo.header.ChaCha20IETFPoly1305EncryptionParameters;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionMethod;
import no.uio.ifi.crypt4gh.pojo.header.DataEncryptionParameters;

public abstract class Segment
implements Crypt4GHEntity {
    public static final int UNENCRYPTED_DATA_SEGMENT_SIZE = 65536;
    protected byte[] unencryptedData;

    public static Segment create(byte[] unencryptedData, DataEncryptionParameters dataEncryptionParameters) throws GeneralSecurityException {
        DataEncryptionMethod dataEncryptionMethod = dataEncryptionParameters.getDataEncryptionMethod();
        switch (dataEncryptionMethod) {
            case CHACHA20_IETF_POLY1305: {
                return new ChaCha20IETFPoly1305Segment(unencryptedData, (ChaCha20IETFPoly1305EncryptionParameters)dataEncryptionParameters, true);
            }
        }
        throw new GeneralSecurityException("Data Encryption Method not found for code: " + dataEncryptionMethod.getCode());
    }

    public static Segment create(byte[] encryptedData, Collection<DataEncryptionParameters> dataEncryptionParametersList) throws GeneralSecurityException {
        for (DataEncryptionParameters dataEncryptionParameters : dataEncryptionParametersList) {
            Optional<Segment> segmentOptional = Segment.tryCreate(encryptedData, dataEncryptionParameters);
            if (!segmentOptional.isPresent()) continue;
            return segmentOptional.get();
        }
        throw new GeneralSecurityException("Data Segment can't be decrypted with any of Header keys");
    }

    private static Optional<Segment> tryCreate(byte[] encryptedData, DataEncryptionParameters dataEncryptionParameters) throws GeneralSecurityException {
        DataEncryptionMethod dataEncryptionMethod = dataEncryptionParameters.getDataEncryptionMethod();
        switch (dataEncryptionMethod) {
            case CHACHA20_IETF_POLY1305: {
                try {
                    return Optional.of(new ChaCha20IETFPoly1305Segment(encryptedData, (ChaCha20IETFPoly1305EncryptionParameters)dataEncryptionParameters, false));
                }
                catch (GeneralSecurityException e) {
                    return Optional.empty();
                }
            }
        }
        throw new GeneralSecurityException("Data Encryption Method not found for code: " + dataEncryptionMethod.getCode());
    }

    public String toString() {
        return "Segment(unencryptedData=" + Arrays.toString(this.getUnencryptedData()) + ")";
    }

    public byte[] getUnencryptedData() {
        return this.unencryptedData;
    }

    public void setUnencryptedData(byte[] unencryptedData) {
        this.unencryptedData = unencryptedData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment other = (Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getUnencryptedData(), other.getUnencryptedData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Segment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getUnencryptedData());
        return result;
    }
}

