/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.pojo.body;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import no.uio.ifi.crypt4gh.pojo.EncryptableEntity;
import no.uio.ifi.crypt4gh.pojo.body.Segment;
import no.uio.ifi.crypt4gh.pojo.header.ChaCha20IETFPoly1305EncryptionParameters;
import org.apache.commons.lang3.ArrayUtils;

public class ChaCha20IETFPoly1305Segment
extends Segment
implements EncryptableEntity {
    public static final int NONCE_SIZE = 12;
    public static final int MAC_SIZE = 16;
    private byte[] nonce = new byte[12];
    private byte[] encryptedData;
    private byte[] mac = new byte[16];

    ChaCha20IETFPoly1305Segment(byte[] data, ChaCha20IETFPoly1305EncryptionParameters dataEncryptionParameters, boolean encrypt) throws GeneralSecurityException {
        if (encrypt) {
            this.unencryptedData = data;
            this.encrypt(data, dataEncryptionParameters.getDataKey());
        } else {
            this.nonce = Arrays.copyOfRange(data, 0, 12);
            this.encryptedData = Arrays.copyOfRange(data, 12, data.length - 16);
            this.mac = Arrays.copyOfRange(data, data.length - 16, data.length);
            this.unencryptedData = this.decrypt(dataEncryptionParameters.getDataKey());
        }
    }

    @Override
    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN).put(this.nonce).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(this.encryptedData.length).order(ByteOrder.LITTLE_ENDIAN).put(this.encryptedData).array());
        byteArrayOutputStream.write(ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).put(this.mac).array());
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void encrypt(byte[] unencryptedData, SecretKey sharedKey) throws GeneralSecurityException {
        SecureRandom.getInstanceStrong().nextBytes(this.nonce);
        Cipher cipher = Cipher.getInstance("ChaCha20-Poly1305");
        cipher.init(1, (Key)sharedKey, new IvParameterSpec(this.nonce));
        byte[] encryptedPayloadWithMAC = cipher.doFinal(unencryptedData);
        this.encryptedData = Arrays.copyOfRange(encryptedPayloadWithMAC, 0, encryptedPayloadWithMAC.length - 16);
        this.mac = Arrays.copyOfRange(encryptedPayloadWithMAC, encryptedPayloadWithMAC.length - 16, encryptedPayloadWithMAC.length);
    }

    @Override
    public byte[] decrypt(SecretKey sharedKey) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("ChaCha20-Poly1305");
        cipher.init(2, (Key)sharedKey, new IvParameterSpec(this.nonce));
        return cipher.doFinal(ArrayUtils.addAll((byte[])this.encryptedData, (byte[])this.mac));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChaCha20IETFPoly1305Segment)) {
            return false;
        }
        ChaCha20IETFPoly1305Segment other = (ChaCha20IETFPoly1305Segment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getNonce(), other.getNonce())) {
            return false;
        }
        if (!Arrays.equals(this.getEncryptedData(), other.getEncryptedData())) {
            return false;
        }
        return Arrays.equals(this.getMac(), other.getMac());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChaCha20IETFPoly1305Segment;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getNonce());
        result = result * 59 + Arrays.hashCode(this.getEncryptedData());
        result = result * 59 + Arrays.hashCode(this.getMac());
        return result;
    }

    @Override
    public String toString() {
        return "ChaCha20IETFPoly1305Segment(nonce=" + Arrays.toString(this.getNonce()) + ", encryptedData=" + Arrays.toString(this.getEncryptedData()) + ", mac=" + Arrays.toString(this.getMac()) + ")";
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public byte[] getEncryptedData() {
        return this.encryptedData;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public void setEncryptedData(byte[] encryptedData) {
        this.encryptedData = encryptedData;
    }

    public void setMac(byte[] mac) {
        this.mac = mac;
    }
}

