/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashSet;
import no.uio.ifi.crypt4gh.app.ConsoleUtils;
import no.uio.ifi.crypt4gh.pojo.key.Format;
import no.uio.ifi.crypt4gh.stream.Crypt4GHInputStream;
import no.uio.ifi.crypt4gh.stream.Crypt4GHOutputStream;
import no.uio.ifi.crypt4gh.util.KeyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

class Crypt4GHUtils {
    private static Crypt4GHUtils ourInstance = new Crypt4GHUtils();
    private KeyUtils keyUtils = KeyUtils.getInstance();
    private ConsoleUtils consoleUtils = ConsoleUtils.getInstance();

    static Crypt4GHUtils getInstance() {
        return ourInstance;
    }

    private Crypt4GHUtils() {
    }

    void generateX25519KeyPair(String keyName, String keyFormat, String keyPassword) throws Exception {
        File secFile;
        KeyUtils keyUtils = KeyUtils.getInstance();
        KeyPair keyPair = keyUtils.generateKeyPair();
        File pubFile = new File(keyName + ".pub.pem");
        if (!pubFile.exists() || pubFile.exists() && this.consoleUtils.promptForConfirmation("Public key file already exists: do you want to overwrite it?")) {
            if (Format.CRYPT4GH.name().equalsIgnoreCase(keyFormat)) {
                keyUtils.writeCrypt4GHKey(pubFile, (Key)keyPair.getPublic(), null);
            } else {
                keyUtils.writeOpenSSLKey(pubFile, (Key)keyPair.getPublic());
            }
        }
        if (!(secFile = new File(keyName + ".sec.pem")).exists() || secFile.exists() && this.consoleUtils.promptForConfirmation("Private key file already exists: do you want to overwrite it?")) {
            if (Format.CRYPT4GH.name().equalsIgnoreCase(keyFormat)) {
                char[] password = StringUtils.isEmpty((CharSequence)keyPassword) ? this.consoleUtils.readPassword("Password for the private key: ", 4) : (keyPassword.length() < 4 ? this.consoleUtils.readPassword("Password for the private key: ", 4) : keyPassword.toCharArray());
                keyUtils.writeCrypt4GHKey(secFile, (Key)keyPair.getPrivate(), password);
            } else {
                keyUtils.writeOpenSSLKey(secFile, (Key)keyPair.getPrivate());
            }
        }
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        Files.setPosixFilePermissions(secFile.toPath(), perms);
    }

    void encryptFile(String dataFilePath, String privateKeyFilePath, String publicKeyFilePath) throws IOException, GeneralSecurityException {
        File dataInFile = new File(dataFilePath);
        File dataOutFile = new File(dataFilePath + ".enc");
        if (dataOutFile.exists() && !ConsoleUtils.getInstance().promptForConfirmation(dataOutFile.getAbsolutePath() + " already exists. Overwrite?")) {
            return;
        }
        PrivateKey privateKey = this.readPrivateKey(privateKeyFilePath);
        PublicKey publicKey = this.keyUtils.readPublicKey(new File(publicKeyFilePath));
        try (FileInputStream inputStream = new FileInputStream(dataInFile);
             FileOutputStream outputStream = new FileOutputStream(dataOutFile);
             Crypt4GHOutputStream crypt4GHOutputStream = new Crypt4GHOutputStream(outputStream, privateKey, publicKey);){
            System.out.println("Encryption initialized...");
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)crypt4GHOutputStream);
            System.out.println("Done: " + dataOutFile.getAbsolutePath());
        }
        catch (GeneralSecurityException e) {
            System.err.println(e.getMessage());
            dataOutFile.delete();
        }
    }

    void decryptFile(String dataFilePath, String privateKeyFilePath) throws IOException, GeneralSecurityException {
        File dataInFile = new File(dataFilePath);
        File dataOutFile = new File(dataFilePath + ".dec");
        if (dataOutFile.exists() && !ConsoleUtils.getInstance().promptForConfirmation(dataOutFile.getAbsolutePath() + " already exists. Overwrite?")) {
            return;
        }
        PrivateKey privateKey = this.readPrivateKey(privateKeyFilePath);
        System.out.println("Decryption initialized...");
        try (FileInputStream inputStream = new FileInputStream(dataInFile);
             FileOutputStream outputStream = new FileOutputStream(dataOutFile);
             Crypt4GHInputStream crypt4GHInputStream = new Crypt4GHInputStream(inputStream, privateKey);){
            IOUtils.copyLarge((InputStream)crypt4GHInputStream, (OutputStream)outputStream);
            System.out.println("Done: " + dataOutFile.getAbsolutePath());
        }
        catch (GeneralSecurityException e) {
            System.err.println(e.getMessage());
            dataOutFile.delete();
        }
    }

    private PrivateKey readPrivateKey(String privateKeyFilePath) throws IOException, GeneralSecurityException {
        PrivateKey privateKey;
        try {
            privateKey = this.keyUtils.readPrivateKey(new File(privateKeyFilePath), null);
        }
        catch (IllegalArgumentException e) {
            char[] password = this.consoleUtils.readPassword("Password for the private key: ", 4);
            privateKey = this.keyUtils.readPrivateKey(new File(privateKeyFilePath), password);
        }
        return privateKey;
    }
}

