/*
 * Decompiled with CFR 0.152.
 */
package no.uio.ifi.crypt4gh.app;

import java.io.Console;

class ConsoleUtils {
    private static ConsoleUtils ourInstance = new ConsoleUtils();

    static ConsoleUtils getInstance() {
        return ourInstance;
    }

    private ConsoleUtils() {
    }

    boolean promptForConfirmation(String prompt) {
        Console console = System.console();
        Boolean confirm = null;
        while (confirm == null) {
            String response = console.readLine(prompt + " (y/n) ", new Object[0]);
            if (response.toLowerCase().startsWith("y")) {
                confirm = true;
                continue;
            }
            if (!response.toLowerCase().startsWith("n")) continue;
            confirm = false;
        }
        return confirm;
    }

    char[] readPassword(String prompt, int minLength) {
        char[] password;
        while ((password = System.console().readPassword(prompt, new Object[0])).length < minLength) {
            System.out.println("Passphrase is too short: min length is " + minLength);
        }
        return password;
    }
}

