/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackgroundStreamLogger
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundStreamLogger.class);
    private InputStream is;
    private String type;

    BackgroundStreamLogger(InputStream is, String type) {
        this.is = is;
        this.type = type;
    }

    @Override
    public void run() {
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                switch (this.type.toUpperCase()) {
                    case "ERROR": {
                        LOGGER.error(line);
                        break;
                    }
                    case "INFO": {
                        LOGGER.info(line);
                        break;
                    }
                    case "DEBUG": {
                        LOGGER.debug(line);
                    }
                }
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Reading process stream faled", (Throwable)ioe);
        }
    }
}

