/*
 * Decompiled with CFR 0.152.
 */
package no.oms.maven.precommit.lib;

import java.io.File;
import no.oms.maven.precommit.lib.ArchiveExtractionException;
import no.oms.maven.precommit.lib.ArchiveExtractor;
import no.oms.maven.precommit.lib.CacheDescriptor;
import no.oms.maven.precommit.lib.DownloadException;
import no.oms.maven.precommit.lib.FileDownloader;
import no.oms.maven.precommit.lib.InstallConfig;
import no.oms.maven.precommit.lib.InstallationException;
import no.oms.maven.precommit.lib.PythonException;
import no.oms.maven.precommit.lib.PythonHandle;
import no.oms.maven.precommit.lib.VirtualEnvDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryInstaller {
    public static final String INSTALL_PATH = "/pre-commit";
    public static final String DEFAULT_DOWNLOAD_ROOT = "https://github.com/pre-commit/pre-commit/archive/";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;
    private final PythonHandle pythonHandle;
    private String version;
    private String downloadRoot;

    public BinaryInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader, PythonHandle pythonHandle) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
        this.pythonHandle = pythonHandle;
    }

    public BinaryInstaller setVersion(String version) {
        this.version = version;
        return this;
    }

    public BinaryInstaller setDownloadRoot(String downloadRoot) {
        this.downloadRoot = downloadRoot;
        return this;
    }

    public void installBinary() throws InstallationException {
        try {
            this.logger.info("Installing pre-commit version {}", (Object)this.version);
            String downloadUrl = this.downloadRoot + this.version;
            String extension = "tar.gz";
            String fileEnding = "/" + this.version + "." + extension;
            downloadUrl = downloadUrl + fileEnding;
            CacheDescriptor cacheDescriptor = new CacheDescriptor("pre-commit", this.version, extension);
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive);
            File installDirectory = this.getInstallDirectory();
            this.extractFile(archive, installDirectory);
            File setupFile = new File(installDirectory + "/setup.py");
            if (!setupFile.exists()) {
                throw new InstallationException("Could not find setup.py in extracted archive");
            }
            VirtualEnvDescriptor env = this.pythonHandle.setupVirtualEnv(installDirectory, "pre-commit");
            this.pythonHandle.installIntoVirtualEnv(env, setupFile);
            this.logger.info("Installed pre-commit locally.");
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download pre-commit", e);
        }
        catch (ArchiveExtractionException e) {
            throw new InstallationException("Could not extract the pre-commit archive", e);
        }
        catch (PythonException e) {
            throw new InstallationException("Python encountered an issue when installing the pre-commit binary", e);
        }
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), INSTALL_PATH);
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void downloadFileIfMissing(String downloadUrl, File destination) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination);
        }
    }

    private void downloadFile(String downloadUrl, File destination) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath());
    }
}

