/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.support.v18.scanner;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.PendingIntentExecutor;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanFilter;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;

public class ScannerService
extends Service {
    private static final String TAG = "ScannerService";
    static final String EXTRA_PENDING_INTENT = "no.nordicsemi.android.support.v18.EXTRA_PENDING_INTENT";
    static final String EXTRA_REQUEST_CODE = "no.nordicsemi.android.support.v18.REQUEST_CODE";
    static final String EXTRA_FILTERS = "no.nordicsemi.android.support.v18.EXTRA_FILTERS";
    static final String EXTRA_SETTINGS = "no.nordicsemi.android.support.v18.EXTRA_SETTINGS";
    static final String EXTRA_START = "no.nordicsemi.android.support.v18.EXTRA_START";
    @NonNull
    private final Object LOCK = new Object();
    private HashMap<Integer, ScanCallback> callbacks;
    private Handler handler;

    public void onCreate() {
        super.onCreate();
        this.callbacks = new HashMap();
        this.handler = new Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            boolean knownCallback;
            boolean stop;
            PendingIntent callbackIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_PENDING_INTENT);
            int requestCode = intent.getIntExtra(EXTRA_REQUEST_CODE, 0);
            boolean start = intent.getBooleanExtra(EXTRA_START, false);
            boolean bl = stop = !start;
            if (callbackIntent == null) {
                boolean shouldStop;
                Object object = this.LOCK;
                synchronized (object) {
                    shouldStop = this.callbacks.isEmpty();
                }
                if (shouldStop) {
                    this.stopSelf();
                }
                return 2;
            }
            Object object = this.LOCK;
            synchronized (object) {
                knownCallback = this.callbacks.containsKey(requestCode);
            }
            if (start && !knownCallback) {
                ArrayList filters = intent.getParcelableArrayListExtra(EXTRA_FILTERS);
                ScanSettings settings = (ScanSettings)intent.getParcelableExtra(EXTRA_SETTINGS);
                this.startScan((List<ScanFilter>)(filters != null ? filters : Collections.emptyList()), settings != null ? settings : new ScanSettings.Builder().build(), callbackIntent, requestCode);
            } else if (stop && knownCallback) {
                this.stopScan(requestCode);
            }
        }
        return 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public void onDestroy() {
        BluetoothLeScannerCompat scannerCompat = BluetoothLeScannerCompat.getScanner();
        for (ScanCallback callback : this.callbacks.values()) {
            try {
                scannerCompat.stopScan(callback);
            }
            catch (Exception exception) {}
        }
        this.callbacks.clear();
        this.callbacks = null;
        this.handler = null;
        super.onDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    private void startScan(@NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull PendingIntent callbackIntent, int requestCode) {
        PendingIntentExecutor executor = new PendingIntentExecutor(callbackIntent, settings, this);
        Object object = this.LOCK;
        synchronized (object) {
            this.callbacks.put(requestCode, executor);
        }
        try {
            BluetoothLeScannerCompat scannerCompat = BluetoothLeScannerCompat.getScanner();
            scannerCompat.startScanInternal(filters, settings, executor, this.handler);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Starting scanning failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    private void stopScan(int requestCode) {
        boolean shouldStop;
        ScanCallback callback;
        Object object = this.LOCK;
        synchronized (object) {
            callback = this.callbacks.remove(requestCode);
            shouldStop = this.callbacks.isEmpty();
        }
        if (callback == null) {
            return;
        }
        try {
            BluetoothLeScannerCompat scannerCompat = BluetoothLeScannerCompat.getScanner();
            scannerCompat.stopScan(callback);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Stopping scanning failed", (Throwable)e);
        }
        if (shouldStop) {
            this.stopSelf();
        }
    }
}

