/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.concurrent.CancellationException;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.exception.BluetoothDisabledException;
import no.nordicsemi.android.ble.exception.DeviceDisconnectedException;
import no.nordicsemi.android.ble.exception.InvalidRequestException;
import no.nordicsemi.android.ble.exception.RequestFailedException;

public abstract class TimeoutableRequest
extends Request {
    @Nullable
    private Runnable timeoutCallback;
    protected boolean cancelled;
    protected long timeout;

    TimeoutableRequest(@NonNull Request.Type type) {
        super(type);
    }

    TimeoutableRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    TimeoutableRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    TimeoutableRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public TimeoutableRequest setHandler(@Nullable Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @NonNull
    public TimeoutableRequest timeout(@IntRange(from=0L) long timeout) {
        if (this.timeoutCallback != null) {
            throw new IllegalStateException("Request already started");
        }
        this.timeout = timeout;
        return this;
    }

    public void cancel() {
        if (!this.started) {
            this.cancelled = true;
            this.finished = true;
        } else if (!this.finished) {
            this.cancelled = true;
            this.requestHandler.cancelCurrent();
        }
    }

    @Override
    public final void enqueue() {
        super.enqueue();
    }

    @Deprecated
    public final void enqueue(@IntRange(from=0L) long timeout) {
        this.timeout(timeout).enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await() throws RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        TimeoutableRequest.assertNotMainThread();
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.finished || this.enqueued) {
            throw new IllegalStateException();
        }
        SuccessCallback sc = this.successCallback;
        FailCallback fc = this.failCallback;
        try {
            this.syncLock.close();
            Request.RequestCallback callback = new Request.RequestCallback();
            this.done(callback).fail(callback).invalid(callback).enqueue();
            if (!this.syncLock.block(this.timeout)) {
                throw new InterruptedException();
            }
            if (!callback.isSuccess()) {
                if (callback.status == -7) {
                    throw new CancellationException();
                }
                if (callback.status == -1) {
                    throw new DeviceDisconnectedException();
                }
                if (callback.status == -100) {
                    throw new BluetoothDisabledException();
                }
                if (callback.status == -1000000) {
                    throw new InvalidRequestException(this);
                }
                throw new RequestFailedException(this, callback.status);
            }
        }
        finally {
            this.successCallback = sc;
            this.failCallback = fc;
        }
    }

    @Deprecated
    public final void await(@IntRange(from=0L) long timeout) throws RequestFailedException, InterruptedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, CancellationException {
        this.timeout(timeout).await();
    }

    @Override
    void notifyStarted(@NonNull BluetoothDevice device) {
        if (this.timeout > 0L) {
            this.timeoutCallback = () -> {
                this.timeoutCallback = null;
                if (!this.finished) {
                    this.requestHandler.onRequestTimeout(device, this);
                }
            };
            this.handler.postDelayed(this.timeoutCallback, this.timeout);
        }
        super.notifyStarted(device);
    }

    @Override
    boolean notifySuccess(@NonNull BluetoothDevice device) {
        if (this.timeoutCallback != null) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        return super.notifySuccess(device);
    }

    @Override
    void notifyFail(@NonNull BluetoothDevice device, int status) {
        if (this.timeoutCallback != null) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifyFail(device, status);
    }

    @Override
    void notifyInvalidRequest() {
        if (this.timeoutCallback != null) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifyInvalidRequest();
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }
}

