/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble.utils;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class ParserUtils {
    protected static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String parse(@NonNull BluetoothGattCharacteristic characteristic) {
        return ParserUtils.parse(characteristic.getValue());
    }

    public static String parse(@NonNull BluetoothGattDescriptor descriptor) {
        return ParserUtils.parse(descriptor.getValue());
    }

    public static String parse(@Nullable byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        char[] out = new char[data.length * 3 - 1];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 3] = HEX_ARRAY[v >>> 4];
            out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j == data.length - 1) continue;
            out[j * 3 + 2] = 45;
        }
        return "(0x) " + new String(out);
    }

    public static String parseDebug(@Nullable byte[] data) {
        if (data == null || data.length == 0) {
            return "null";
        }
        char[] out = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 2] = HEX_ARRAY[v >>> 4];
            out[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return "0x" + new String(out);
    }

    @NonNull
    public static String pairingVariantToString(int variant) {
        return switch (variant) {
            case 0 -> "PAIRING_VARIANT_PIN";
            case 1 -> "PAIRING_VARIANT_PASSKEY";
            case 2 -> "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            case 3 -> "PAIRING_VARIANT_CONSENT";
            case 4 -> "PAIRING_VARIANT_DISPLAY_PASSKEY";
            case 5 -> "PAIRING_VARIANT_DISPLAY_PIN";
            case 6 -> "PAIRING_VARIANT_OOB_CONSENT";
            default -> "UNKNOWN (" + variant + ")";
        };
    }

    @NonNull
    public static String bondStateToString(int state) {
        return switch (state) {
            case 10 -> "BOND_NONE";
            case 11 -> "BOND_BONDING";
            case 12 -> "BOND_BONDED";
            default -> "UNKNOWN (" + state + ")";
        };
    }

    @NonNull
    public static String writeTypeToString(int type) {
        return switch (type) {
            case 2 -> "WRITE REQUEST";
            case 1 -> "WRITE COMMAND";
            case 4 -> "WRITE SIGNED";
            default -> "UNKNOWN (" + type + ")";
        };
    }

    @NonNull
    public static String stateToString(int state) {
        return switch (state) {
            case 2 -> "CONNECTED";
            case 1 -> "CONNECTING";
            case 3 -> "DISCONNECTING";
            case 0 -> "DISCONNECTED";
            default -> "UNKNOWN (" + state + ")";
        };
    }

    @NonNull
    public static String phyToString(int phy) {
        return switch (phy) {
            case 1 -> "LE 1M";
            case 2 -> "LE 2M";
            case 3 -> "LE Coded";
            default -> "UNKNOWN (" + phy + ")";
        };
    }

    @NonNull
    public static String phyMaskToString(int mask) {
        return switch (mask) {
            case 1 -> "LE 1M";
            case 2 -> "LE 2M";
            case 4 -> "LE Coded";
            case 3 -> "LE 1M or LE 2M";
            case 5 -> "LE 1M or LE Coded";
            case 6 -> "LE 2M or LE Coded";
            case 7 -> "LE 1M, LE 2M or LE Coded";
            default -> "UNKNOWN (" + mask + ")";
        };
    }

    @NonNull
    public static String phyCodedOptionToString(int option) {
        return switch (option) {
            case 0 -> "No preferred";
            case 1 -> "S2";
            case 2 -> "S8";
            default -> "UNKNOWN (" + option + ")";
        };
    }
}

