/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.SimpleValueRequest;
import no.nordicsemi.android.ble.callback.AfterCallback;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.ConnectionPriorityCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.exception.BluetoothDisabledException;
import no.nordicsemi.android.ble.exception.DeviceDisconnectedException;
import no.nordicsemi.android.ble.exception.InvalidRequestException;
import no.nordicsemi.android.ble.exception.RequestFailedException;

public final class ConnectionPriorityRequest
extends SimpleValueRequest<ConnectionPriorityCallback>
implements Operation {
    public static final int CONNECTION_PRIORITY_BALANCED = 0;
    public static final int CONNECTION_PRIORITY_HIGH = 1;
    public static final int CONNECTION_PRIORITY_LOW_POWER = 2;
    private final int value;

    ConnectionPriorityRequest(@NonNull Request.Type type, int priority) {
        super(type);
        if (priority < 0 || priority > 2) {
            priority = 0;
        }
        this.value = priority;
    }

    @Override
    @NonNull
    ConnectionPriorityRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ConnectionPriorityRequest setHandler(@Nullable Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ConnectionPriorityRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectionPriorityRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectionPriorityRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectionPriorityRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectionPriorityRequest then(@NonNull AfterCallback callback) {
        super.then(callback);
        return this;
    }

    @RequiresApi(value=26)
    @NonNull
    public ConnectionPriorityRequest with(@NonNull ConnectionPriorityCallback callback) {
        super.with(callback);
        return this;
    }

    @Override
    @RequiresApi(value=26)
    @NonNull
    public <E extends ConnectionPriorityCallback> E await(@NonNull Class<E> responseClass) throws RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        return (E)((ConnectionPriorityCallback)super.await(responseClass));
    }

    @Override
    @RequiresApi(value=26)
    @NonNull
    public <E extends ConnectionPriorityCallback> E await(@NonNull E response) throws RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        return super.await(response);
    }

    @RequiresApi(api=26)
    void notifyConnectionPriorityChanged(@NonNull BluetoothDevice device, @IntRange(from=6L, to=3200L) int interval, @IntRange(from=0L, to=499L) int latency, @IntRange(from=10L, to=3200L) int timeout) {
        if (this.valueCallback != null) {
            ((ConnectionPriorityCallback)this.valueCallback).onConnectionUpdated(device, interval, latency, timeout);
        }
    }

    int getRequiredPriority() {
        return this.value;
    }
}

