/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.ble.Bytes;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.SimpleRequest;
import no.nordicsemi.android.ble.callback.AfterCallback;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public final class SetValueRequest
extends SimpleRequest {
    private final byte[] data;
    private boolean longReadSupported = true;

    SetValueRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, characteristic);
        this.data = Bytes.copy(data, offset, length);
    }

    SetValueRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, descriptor);
        this.data = Bytes.copy(data, offset, length);
    }

    @Override
    @NonNull
    SetValueRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest then(@NonNull AfterCallback callback) {
        super.then(callback);
        return this;
    }

    @NonNull
    public SetValueRequest allowLongRead(boolean longReadSupported) {
        this.longReadSupported = longReadSupported;
        return this;
    }

    byte[] getData(@IntRange(from=23L, to=517L) int mtu) {
        int maxLength;
        int n = maxLength = this.longReadSupported ? 512 : mtu - 3;
        if (this.data.length < maxLength) {
            return this.data;
        }
        return Bytes.copy(this.data, 0, maxLength);
    }
}

