/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Deque;
import java.util.LinkedList;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.exception.BluetoothDisabledException;
import no.nordicsemi.android.ble.exception.DeviceDisconnectedException;
import no.nordicsemi.android.ble.exception.InvalidRequestException;
import no.nordicsemi.android.ble.exception.RequestFailedException;

public class RequestQueue
extends Request {
    @NonNull
    private final Deque<Request> requests = new LinkedList<Request>();

    RequestQueue() {
        super(Request.Type.SET);
    }

    @Override
    @NonNull
    RequestQueue setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public RequestQueue add(@NonNull Operation operation) {
        if (operation instanceof Request) {
            Request request = (Request)((Object)operation);
            if (request.enqueued) {
                throw new IllegalStateException("Request already enqueued");
            }
            request.internalFail(this::notifyFail);
            this.requests.add(request);
            request.enqueued = true;
            return this;
        }
        throw new IllegalArgumentException("Operation does not extend Request");
    }

    void addFirst(@NonNull Request request) {
        this.requests.addFirst(request);
    }

    @IntRange(from=0L)
    public int size() {
        return this.requests.size();
    }

    public boolean isEmpty() {
        return this.requests.isEmpty();
    }

    public void cancelQueue() {
        this.requests.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await() throws RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        RequestQueue.assertNotMainThread();
        BeforeCallback bc = this.beforeCallback;
        SuccessCallback sc = this.successCallback;
        FailCallback fc = this.failCallback;
        try {
            this.syncLock.close();
            Request.RequestCallback callback = new Request.RequestCallback(this);
            this.beforeCallback = null;
            this.done(callback).fail(callback).invalid(callback).enqueue();
            this.syncLock.block();
            if (!callback.isSuccess()) {
                if (callback.status == -1) {
                    throw new DeviceDisconnectedException();
                }
                if (callback.status == -100) {
                    throw new BluetoothDisabledException();
                }
                if (callback.status == -5) {
                    throw new InterruptedException();
                }
                if (callback.status == -1000000) {
                    throw new InvalidRequestException(this);
                }
                throw new RequestFailedException(this, callback.status);
            }
        }
        finally {
            this.beforeCallback = bc;
            this.successCallback = sc;
            this.failCallback = fc;
        }
    }

    @Nullable
    Request getNext() {
        try {
            return this.requests.remove();
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean hasMore() {
        return !this.finished && !this.requests.isEmpty();
    }
}

