/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.os.Handler;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.ble.AwaitingRequest;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public final class ConditionalWaitRequest<T>
extends AwaitingRequest
implements Operation {
    @NonNull
    private final Condition<T> condition;
    @Nullable
    private final T parameter;
    private boolean expected = false;

    ConditionalWaitRequest(@NonNull Request.Type type, @NonNull Condition<T> condition, @Nullable T parameter) {
        super(type);
        this.condition = condition;
        this.parameter = parameter;
    }

    @Override
    @NonNull
    ConditionalWaitRequest<T> setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ConditionalWaitRequest<T> before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public ConditionalWaitRequest<T> negate() {
        this.expected = true;
        return this;
    }

    boolean isFulfilled() {
        try {
            return this.condition.predicate(this.parameter) == this.expected;
        }
        catch (Exception e) {
            Log.e((String)"ConditionalWaitRequest", (String)"Error while checking predicate", (Throwable)e);
            return true;
        }
    }

    public static interface Condition<T> {
        public boolean predicate(@Nullable T var1);
    }
}

