/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble.data;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.ble.data.Data;

public class MutableData
extends Data {
    private static final int SFLOAT_POSITIVE_INFINITY = 2046;
    private static final int SFLOAT_NAN = 2047;
    private static final int SFLOAT_NEGATIVE_INFINITY = 2050;
    private static final int SFLOAT_MANTISSA_MAX = 2045;
    private static final int SFLOAT_EXPONENT_MAX = 7;
    private static final int SFLOAT_EXPONENT_MIN = -8;
    private static final float SFLOAT_MAX = 2.045E10f;
    private static final float SFLOAT_MIN = -2.045E10f;
    private static final int SFLOAT_PRECISION = 10000;
    private static final int FLOAT_POSITIVE_INFINITY = 0x7FFFFE;
    private static final int FLOAT_NAN = 0x7FFFFF;
    private static final int FLOAT_NEGATIVE_INFINITY = 0x800002;
    private static final int FLOAT_MANTISSA_MAX = 0x7FFFFD;
    private static final int FLOAT_EXPONENT_MAX = 127;
    private static final int FLOAT_EXPONENT_MIN = -128;
    private static final int FLOAT_PRECISION = 10000000;

    public MutableData() {
    }

    public MutableData(@Nullable byte[] data) {
        super(data);
    }

    public static MutableData from(@NonNull BluetoothGattCharacteristic characteristic) {
        return new MutableData(characteristic.getValue());
    }

    public static MutableData from(@NonNull BluetoothGattDescriptor descriptor) {
        return new MutableData(descriptor.getValue());
    }

    public boolean setValue(@Nullable byte[] value) {
        this.mValue = value;
        return true;
    }

    public boolean setByte(int value, @IntRange(from=0L) int offset) {
        int len = offset + 1;
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        this.mValue[offset] = (byte)value;
        return true;
    }

    public boolean setValue(int value, int formatType, @IntRange(from=0L) int offset) {
        int len = offset + MutableData.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 33: {
                value = MutableData.intToSignedBits(value, 8);
            }
            case 17: {
                this.mValue[offset] = (byte)(value & 0xFF);
                break;
            }
            case 34: {
                value = MutableData.intToSignedBits(value, 16);
            }
            case 18: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset] = (byte)(value >> 8 & 0xFF);
                break;
            }
            case 35: {
                value = MutableData.intToSignedBits(value, 24);
            }
            case 19: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                this.mValue[offset] = (byte)(value >> 16 & 0xFF);
                break;
            }
            case 36: {
                value = MutableData.intToSignedBits(value, 32);
            }
            case 20: {
                this.mValue[offset++] = (byte)(value & 0xFF);
                this.mValue[offset++] = (byte)(value >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(value >> 16 & 0xFF);
                this.mValue[offset] = (byte)(value >> 24 & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValue(int mantissa, int exponent, int formatType, @IntRange(from=0L) int offset) {
        int len = offset + MutableData.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 50: {
                mantissa = MutableData.intToSignedBits(mantissa, 12);
                exponent = MutableData.intToSignedBits(exponent, 4);
                this.mValue[offset++] = (byte)(mantissa & 0xFF);
                this.mValue[offset] = (byte)(mantissa >> 8 & 0xF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)((exponent & 0xF) << 4));
                break;
            }
            case 52: {
                mantissa = MutableData.intToSignedBits(mantissa, 24);
                exponent = MutableData.intToSignedBits(exponent, 8);
                this.mValue[offset++] = (byte)(mantissa & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(mantissa >> 16 & 0xFF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)(exponent & 0xFF));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValue(long value, int formatType, @IntRange(from=0L) int offset) {
        int len = offset + MutableData.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 36: {
                value = MutableData.longToSignedBits(value, 32);
            }
            case 20: {
                this.mValue[offset++] = (byte)(value & 0xFFL);
                this.mValue[offset++] = (byte)(value >> 8 & 0xFFL);
                this.mValue[offset++] = (byte)(value >> 16 & 0xFFL);
                this.mValue[offset] = (byte)(value >> 24 & 0xFFL);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValue(float value, int formatType, @IntRange(from=0L) int offset) {
        int len = offset + MutableData.getTypeLen(formatType);
        if (this.mValue == null) {
            this.mValue = new byte[len];
        }
        if (len > this.mValue.length) {
            return false;
        }
        switch (formatType) {
            case 50: {
                int sfloatAsInt = MutableData.sfloatToInt(value);
                this.mValue[offset++] = (byte)(sfloatAsInt & 0xFF);
                this.mValue[offset] = (byte)(sfloatAsInt >> 8 & 0xFF);
                break;
            }
            case 52: {
                int floatAsInt = MutableData.floatToInt(value);
                this.mValue[offset++] = (byte)(floatAsInt & 0xFF);
                this.mValue[offset++] = (byte)(floatAsInt >> 8 & 0xFF);
                this.mValue[offset++] = (byte)(floatAsInt >> 16 & 0xFF);
                int n = offset;
                this.mValue[n] = (byte)(this.mValue[n] + (byte)(floatAsInt >> 24 & 0xFF));
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static int sfloatToInt(float value) {
        float mantissa;
        if (Float.isNaN(value)) {
            return 2047;
        }
        if (value > 2.045E10f) {
            return 2046;
        }
        if (value < -2.045E10f) {
            return 2050;
        }
        int sign = value >= 0.0f ? 1 : -1;
        int exponent = 0;
        for (mantissa = Math.abs(value); mantissa > 2045.0f; mantissa /= 10.0f) {
            if (++exponent <= 7) continue;
            if (sign > 0) {
                return 2046;
            }
            return 2050;
        }
        while (mantissa < 1.0f) {
            mantissa *= 10.0f;
            if (--exponent >= -8) continue;
            return 0;
        }
        double smantissa = Math.round(mantissa * 10000.0f);
        double rmantissa = Math.round(mantissa) * 10000;
        double mdiff = Math.abs(smantissa - rmantissa);
        while (mdiff > 0.5 && exponent > -8 && mantissa * 10.0f <= 2045.0f) {
            --exponent;
            smantissa = Math.round((mantissa *= 10.0f) * 10000.0f);
            rmantissa = Math.round(mantissa) * 10000;
            mdiff = Math.abs(smantissa - rmantissa);
        }
        int int_mantissa = Math.round((float)sign * mantissa);
        return (exponent & 0xF) << 12 | int_mantissa & 0xFFF;
    }

    private static int floatToInt(float value) {
        float mantissa;
        if (Float.isNaN(value)) {
            return 0x7FFFFF;
        }
        if (value == Float.POSITIVE_INFINITY) {
            return 0x7FFFFE;
        }
        if (value == Float.NEGATIVE_INFINITY) {
            return 0x800002;
        }
        int sign = value >= 0.0f ? 1 : -1;
        int exponent = 0;
        for (mantissa = Math.abs(value); mantissa > 8388605.0f; mantissa /= 10.0f) {
            if (++exponent <= 127) continue;
            if (sign > 0) {
                return 0x7FFFFE;
            }
            return 0x800002;
        }
        while (mantissa < 1.0f) {
            mantissa *= 10.0f;
            if (--exponent >= -128) continue;
            return 0;
        }
        double smantissa = Math.round(mantissa * 1.0E7f);
        double rmantissa = Math.round(mantissa) * 10000000;
        double mdiff = Math.abs(smantissa - rmantissa);
        while (mdiff > 0.5 && exponent > -128 && mantissa * 10.0f <= 8388605.0f) {
            --exponent;
            smantissa = Math.round((mantissa *= 10.0f) * 1.0E7f);
            rmantissa = Math.round(mantissa) * 10000000;
            mdiff = Math.abs(smantissa - rmantissa);
        }
        int int_mantissa = Math.round((float)sign * mantissa);
        return exponent << 24 | int_mantissa & 0xFFFFFF;
    }

    private static int intToSignedBits(int i, int size) {
        if (i < 0) {
            i = (1 << size - 1) + (i & (1 << size - 1) - 1);
        }
        return i;
    }

    private static long longToSignedBits(long i, int size) {
        if (i < 0L) {
            i = (1L << size - 1) + (i & (1L << size - 1) - 1L);
        }
        return i;
    }
}

