/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.LinkedList;
import java.util.Queue;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.SimpleRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public class RequestQueue
extends SimpleRequest {
    @NonNull
    private final Queue<Request> requests = new LinkedList<Request>();

    RequestQueue() {
        super(Request.Type.SET);
    }

    @Override
    @NonNull
    RequestQueue setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public RequestQueue before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public RequestQueue add(@NonNull Operation operation) {
        if (operation instanceof Request) {
            Request request = (Request)((Object)operation);
            if (request.enqueued) {
                throw new IllegalStateException("Request already enqueued");
            }
            this.requests.add(request);
            request.enqueued = true;
            return this;
        }
        throw new IllegalArgumentException("Operation does not extend Request");
    }

    @IntRange(from=0L)
    public int size() {
        return this.requests.size();
    }

    public boolean isEmpty() {
        return this.requests.isEmpty();
    }

    public void cancelQueue() {
        this.requests.clear();
    }

    @Nullable
    Request getNext() {
        try {
            return this.requests.remove();
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean hasMore() {
        return !this.requests.isEmpty();
    }
}

