/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import no.nordicsemi.android.ble.AwaitingRequest;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.BleManagerCallbacks;
import no.nordicsemi.android.ble.BleServerManager;
import no.nordicsemi.android.ble.Bytes;
import no.nordicsemi.android.ble.ConditionalWaitRequest;
import no.nordicsemi.android.ble.ConnectRequest;
import no.nordicsemi.android.ble.ConnectionPriorityRequest;
import no.nordicsemi.android.ble.MtuRequest;
import no.nordicsemi.android.ble.PhyRequest;
import no.nordicsemi.android.ble.ReadRequest;
import no.nordicsemi.android.ble.ReadRssiRequest;
import no.nordicsemi.android.ble.ReliableWriteRequest;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.RequestQueue;
import no.nordicsemi.android.ble.SetValueRequest;
import no.nordicsemi.android.ble.SleepRequest;
import no.nordicsemi.android.ble.TimeoutableRequest;
import no.nordicsemi.android.ble.ValueChangedCallback;
import no.nordicsemi.android.ble.WaitForReadRequest;
import no.nordicsemi.android.ble.WaitForValueChangedRequest;
import no.nordicsemi.android.ble.WriteRequest;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.error.GattError;
import no.nordicsemi.android.ble.observer.BondingObserver;
import no.nordicsemi.android.ble.observer.ConnectionObserver;
import no.nordicsemi.android.ble.utils.ParserUtils;

abstract class BleManagerHandler
extends RequestHandler {
    private static final String TAG = "BleManager";
    private static final String ERROR_CONNECTION_STATE_CHANGE = "Error on connection state change";
    private static final String ERROR_DISCOVERY_SERVICE = "Error on discovering services";
    private static final String ERROR_AUTH_ERROR_WHILE_BONDED = "Phone has lost bonding information";
    private static final String ERROR_READ_CHARACTERISTIC = "Error on reading characteristic";
    private static final String ERROR_WRITE_CHARACTERISTIC = "Error on writing characteristic";
    private static final String ERROR_READ_DESCRIPTOR = "Error on reading descriptor";
    private static final String ERROR_WRITE_DESCRIPTOR = "Error on writing descriptor";
    private static final String ERROR_MTU_REQUEST = "Error on mtu request";
    private static final String ERROR_CONNECTION_PRIORITY_REQUEST = "Error on connection priority request";
    private static final String ERROR_READ_RSSI = "Error on RSSI read";
    private static final String ERROR_READ_PHY = "Error on PHY read";
    private static final String ERROR_PHY_UPDATE = "Error on PHY update";
    private static final String ERROR_RELIABLE_WRITE = "Error on Execute Reliable Write";
    private static final String ERROR_NOTIFY = "Error on sending notification/indication";
    private final Object LOCK = new Object();
    private BluetoothDevice bluetoothDevice;
    private BluetoothGatt bluetoothGatt;
    private BleManager manager;
    private BleServerManager serverManager;
    private Handler handler;
    private final Deque<Request> taskQueue = new LinkedBlockingDeque<Request>();
    private Deque<Request> initQueue;
    private boolean initInProgress;
    private static final long CONNECTION_TIMEOUT_THRESHOLD = 20000L;
    private boolean servicesDiscovered;
    private boolean serviceDiscoveryRequested;
    private long connectionTime;
    private int connectionCount = 0;
    private boolean connected;
    private boolean ready;
    private boolean operationInProgress;
    private boolean userDisconnected;
    private boolean initialConnection;
    private int connectionState = 0;
    private boolean connectionPriorityOperationInProgress = false;
    private boolean reliableWriteInProgress;
    private int mtu = 23;
    @Deprecated
    @IntRange(from=-1L, to=100L)
    private int batteryValue = -1;
    private Map<BluetoothGattCharacteristic, byte[]> characteristicValues;
    private Map<BluetoothGattDescriptor, byte[]> descriptorValues;
    private Deque<Pair<Object, byte[]>> preparedValues;
    private int prepareError;
    private ConnectRequest connectRequest;
    private Request request;
    private RequestQueue requestQueue;
    @NonNull
    private final HashMap<Object, ValueChangedCallback> valueChangedCallbacks = new HashMap();
    @Deprecated
    @Nullable
    private ValueChangedCallback batteryLevelNotificationCallback;
    @Nullable
    private AwaitingRequest awaitingRequest;
    private final BroadcastReceiver bluetoothStateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 10);
            int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 10);
            String stateString = "[Broadcast] Action received: android.bluetooth.adapter.action.STATE_CHANGED, state changed to " + this.state2String(state);
            BleManagerHandler.this.log(3, stateString);
            switch (state) {
                case 10: 
                case 13: {
                    if (previousState != 13 && previousState != 10) {
                        BleManagerHandler.this.operationInProgress = true;
                        BleManagerHandler.this.taskQueue.clear();
                        BleManagerHandler.this.initQueue = null;
                        BluetoothDevice device = BleManagerHandler.this.bluetoothDevice;
                        if (device != null) {
                            if (BleManagerHandler.this.request != null && ((BleManagerHandler)BleManagerHandler.this).request.type != Request.Type.DISCONNECT) {
                                BleManagerHandler.this.request.notifyFail(device, -100);
                                BleManagerHandler.this.request = null;
                            }
                            if (BleManagerHandler.this.awaitingRequest != null) {
                                BleManagerHandler.this.awaitingRequest.notifyFail(device, -100);
                                BleManagerHandler.this.awaitingRequest = null;
                            }
                            if (BleManagerHandler.this.connectRequest != null) {
                                BleManagerHandler.this.connectRequest.notifyFail(device, -100);
                                BleManagerHandler.this.connectRequest = null;
                            }
                        }
                        BleManagerHandler.this.userDisconnected = true;
                        BleManagerHandler.this.operationInProgress = false;
                        if (device == null) break;
                        BleManagerHandler.this.notifyDeviceDisconnected(device, 1);
                        break;
                    }
                    BleManagerHandler.this.close();
                }
            }
        }

        private String state2String(int state) {
            switch (state) {
                case 11: {
                    return "TURNING ON";
                }
                case 12: {
                    return "ON";
                }
                case 13: {
                    return "TURNING OFF";
                }
                case 10: {
                    return "OFF";
                }
            }
            return "UNKNOWN (" + state + ")";
        }
    };
    private final BroadcastReceiver mBondingBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
            int previousBondState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
            if (BleManagerHandler.this.bluetoothDevice == null || device == null || !device.getAddress().equals(BleManagerHandler.this.bluetoothDevice.getAddress())) {
                return;
            }
            BleManagerHandler.this.log(3, "[Broadcast] Action received: android.bluetooth.device.action.BOND_STATE_CHANGED, bond state changed to: " + ParserUtils.bondStateToString(bondState) + " (" + bondState + ")");
            switch (bondState) {
                case 10: {
                    if (previousBondState == 11) {
                        BleManagerHandler.this.postCallback(c -> c.onBondingFailed(device));
                        BleManagerHandler.this.postBondingStateChange(o -> o.onBondingFailed(device));
                        BleManagerHandler.this.log(5, "Bonding failed");
                        if (BleManagerHandler.this.request == null) break;
                        BleManagerHandler.this.request.notifyFail(device, -4);
                        BleManagerHandler.this.request = null;
                        break;
                    }
                    if (previousBondState != 12) break;
                    if (BleManagerHandler.this.request != null && ((BleManagerHandler)BleManagerHandler.this).request.type == Request.Type.REMOVE_BOND) {
                        BleManagerHandler.this.log(4, "Bond information removed");
                        BleManagerHandler.this.request.notifySuccess(device);
                        BleManagerHandler.this.request = null;
                    }
                    BleManagerHandler.this.close();
                    break;
                }
                case 11: {
                    BleManagerHandler.this.postCallback(c -> c.onBondingRequired(device));
                    BleManagerHandler.this.postBondingStateChange(o -> o.onBondingRequired(device));
                    return;
                }
                case 12: {
                    BleManagerHandler.this.log(4, "Device bonded");
                    BleManagerHandler.this.postCallback(c -> c.onBonded(device));
                    BleManagerHandler.this.postBondingStateChange(o -> o.onBonded(device));
                    if (BleManagerHandler.this.request != null && ((BleManagerHandler)BleManagerHandler.this).request.type == Request.Type.CREATE_BOND) {
                        BleManagerHandler.this.request.notifySuccess(device);
                        BleManagerHandler.this.request = null;
                        break;
                    }
                    if (!BleManagerHandler.this.servicesDiscovered && !BleManagerHandler.this.serviceDiscoveryRequested) {
                        BleManagerHandler.this.serviceDiscoveryRequested = true;
                        BleManagerHandler.this.post(() -> {
                            BleManagerHandler.this.log(2, "Discovering services...");
                            BleManagerHandler.this.log(3, "gatt.discoverServices()");
                            BleManagerHandler.this.bluetoothGatt.discoverServices();
                        });
                        return;
                    }
                    if (Build.VERSION.SDK_INT < 26 && BleManagerHandler.this.request != null) {
                        BleManagerHandler.this.enqueueFirst(BleManagerHandler.this.request);
                        break;
                    }
                    return;
                }
            }
            BleManagerHandler.this.nextRequest(true);
        }
    };
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public final void onConnectionStateChange(@NonNull BluetoothGatt gatt, int status, int newState) {
            BleManagerHandler.this.log(3, "[Callback] Connection state changed with status: " + status + " and new state: " + newState + " (" + ParserUtils.stateToString(newState) + ")");
            if (status == 0 && newState == 2) {
                if (BleManagerHandler.this.bluetoothDevice == null) {
                    Log.e((String)BleManagerHandler.TAG, (String)"Device received notification after disconnection.");
                    BleManagerHandler.this.log(3, "gatt.close()");
                    try {
                        gatt.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                BleManagerHandler.this.log(4, "Connected to " + gatt.getDevice().getAddress());
                BleManagerHandler.this.connected = true;
                BleManagerHandler.this.connectionTime = 0L;
                BleManagerHandler.this.connectionState = 2;
                BleManagerHandler.this.postCallback(c -> c.onDeviceConnected(gatt.getDevice()));
                BleManagerHandler.this.postConnectionStateChange(o -> o.onDeviceConnected(gatt.getDevice()));
                if (!BleManagerHandler.this.serviceDiscoveryRequested) {
                    boolean bonded = gatt.getDevice().getBondState() == 12;
                    int delay = BleManagerHandler.this.manager.getServiceDiscoveryDelay(bonded);
                    if (delay > 0) {
                        BleManagerHandler.this.log(3, "wait(" + delay + ")");
                    }
                    int connectionCount = ++BleManagerHandler.this.connectionCount;
                    BleManagerHandler.this.postDelayed(() -> {
                        if (connectionCount != BleManagerHandler.this.connectionCount) {
                            return;
                        }
                        if (BleManagerHandler.this.connected && gatt.getDevice().getBondState() != 11) {
                            BleManagerHandler.this.serviceDiscoveryRequested = true;
                            BleManagerHandler.this.log(2, "Discovering services...");
                            BleManagerHandler.this.log(3, "gatt.discoverServices()");
                            gatt.discoverServices();
                        }
                    }, delay);
                }
            } else {
                if (newState == 0) {
                    boolean timeout;
                    long now = SystemClock.elapsedRealtime();
                    boolean canTimeout = BleManagerHandler.this.connectionTime > 0L;
                    boolean bl = timeout = canTimeout && now > BleManagerHandler.this.connectionTime + 20000L;
                    if (status != 0) {
                        BleManagerHandler.this.log(5, "Error: (0x" + Integer.toHexString(status) + "): " + GattError.parseConnectionError(status));
                    }
                    if (status != 0 && canTimeout && !timeout && BleManagerHandler.this.connectRequest != null && BleManagerHandler.this.connectRequest.canRetry()) {
                        int delay = BleManagerHandler.this.connectRequest.getRetryDelay();
                        if (delay > 0) {
                            BleManagerHandler.this.log(3, "wait(" + delay + ")");
                        }
                        BleManagerHandler.this.postDelayed(() -> BleManagerHandler.this.internalConnect(gatt.getDevice(), BleManagerHandler.this.connectRequest), delay);
                        return;
                    }
                    BleManagerHandler.this.operationInProgress = true;
                    BleManagerHandler.this.taskQueue.clear();
                    BleManagerHandler.this.initQueue = null;
                    BleManagerHandler.this.ready = false;
                    boolean wasConnected = BleManagerHandler.this.connected;
                    BleManagerHandler.this.notifyDeviceDisconnected(gatt.getDevice(), timeout ? 10 : (BleManagerHandler.this.servicesDiscovered ? 4 : BleManagerHandler.this.mapDisconnectStatusToReason(status)));
                    if (BleManagerHandler.this.request != null && ((BleManagerHandler)BleManagerHandler.this).request.type != Request.Type.DISCONNECT && ((BleManagerHandler)BleManagerHandler.this).request.type != Request.Type.REMOVE_BOND) {
                        BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status == 0 ? -1 : status);
                        BleManagerHandler.this.request = null;
                    }
                    if (BleManagerHandler.this.awaitingRequest != null) {
                        BleManagerHandler.this.awaitingRequest.notifyFail(gatt.getDevice(), -1);
                        BleManagerHandler.this.awaitingRequest = null;
                    }
                    if (BleManagerHandler.this.connectRequest != null) {
                        int reason = BleManagerHandler.this.servicesDiscovered ? -2 : (status == 0 ? -1 : (status == 133 && timeout ? -5 : status));
                        BleManagerHandler.this.connectRequest.notifyFail(gatt.getDevice(), reason);
                        BleManagerHandler.this.connectRequest = null;
                    }
                    BleManagerHandler.this.operationInProgress = false;
                    if (wasConnected && BleManagerHandler.this.initialConnection) {
                        BleManagerHandler.this.internalConnect(gatt.getDevice(), null);
                    } else {
                        BleManagerHandler.this.initialConnection = false;
                        BleManagerHandler.this.nextRequest(false);
                    }
                    if (wasConnected || status == 0) {
                        return;
                    }
                } else if (status != 0) {
                    BleManagerHandler.this.log(6, "Error (0x" + Integer.toHexString(status) + "): " + GattError.parseConnectionError(status));
                }
                BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_CONNECTION_STATE_CHANGE, status));
            }
        }

        public final void onServicesDiscovered(@NonNull BluetoothGatt gatt, int status) {
            BleManagerHandler.this.serviceDiscoveryRequested = false;
            if (status == 0) {
                BleManagerHandler.this.log(4, "Services discovered");
                BleManagerHandler.this.servicesDiscovered = true;
                if (BleManagerHandler.this.isRequiredServiceSupported(gatt)) {
                    boolean deprecatedApiUsed;
                    BluetoothGattServer server;
                    BleManagerHandler.this.log(2, "Primary service found");
                    boolean optionalServicesFound = BleManagerHandler.this.isOptionalServiceSupported(gatt);
                    if (optionalServicesFound) {
                        BleManagerHandler.this.log(2, "Secondary service found");
                    }
                    BleManagerHandler.this.postCallback(c -> c.onServicesDiscovered(gatt.getDevice(), optionalServicesFound));
                    if (BleManagerHandler.this.serverManager != null && (server = BleManagerHandler.this.serverManager.getServer()) != null) {
                        for (BluetoothGattService service : server.getServices()) {
                            for (BluetoothGattCharacteristic characteristic : service.getCharacteristics()) {
                                if (!BleManagerHandler.this.serverManager.isShared(characteristic)) {
                                    if (BleManagerHandler.this.characteristicValues == null) {
                                        BleManagerHandler.this.characteristicValues = new HashMap();
                                    }
                                    BleManagerHandler.this.characteristicValues.put(characteristic, characteristic.getValue());
                                }
                                for (BluetoothGattDescriptor descriptor : characteristic.getDescriptors()) {
                                    if (BleManagerHandler.this.serverManager.isShared(descriptor)) continue;
                                    if (BleManagerHandler.this.descriptorValues == null) {
                                        BleManagerHandler.this.descriptorValues = new HashMap();
                                    }
                                    BleManagerHandler.this.descriptorValues.put(descriptor, descriptor.getValue());
                                }
                            }
                        }
                        BleManagerHandler.this.onServerReady(server);
                    }
                    BleManagerHandler.this.initInProgress = true;
                    BleManagerHandler.this.operationInProgress = true;
                    BleManagerHandler.this.initQueue = BleManagerHandler.this.initGatt(gatt);
                    boolean bl = deprecatedApiUsed = BleManagerHandler.this.initQueue != null;
                    if (deprecatedApiUsed) {
                        for (Request request : BleManagerHandler.this.initQueue) {
                            request.enqueued = true;
                        }
                    }
                    if (BleManagerHandler.this.initQueue == null) {
                        BleManagerHandler.this.initQueue = new LinkedBlockingDeque();
                    }
                    if (Build.VERSION.SDK_INT < 23 || Build.VERSION.SDK_INT == 26 || Build.VERSION.SDK_INT == 27 || Build.VERSION.SDK_INT == 28) {
                        BleManagerHandler.this.enqueueFirst(Request.newEnableServiceChangedIndicationsRequest().setRequestHandler(BleManagerHandler.this));
                    }
                    if (deprecatedApiUsed) {
                        BleManagerHandler.this.manager.readBatteryLevel();
                        if (((BleManagerHandler)BleManagerHandler.this).manager.callbacks != null && ((BleManagerHandler)BleManagerHandler.this).manager.callbacks.shouldEnableBatteryLevelNotifications(gatt.getDevice())) {
                            BleManagerHandler.this.manager.enableBatteryLevelNotifications();
                        }
                    }
                    BleManagerHandler.this.initialize();
                    BleManagerHandler.this.initInProgress = false;
                    BleManagerHandler.this.nextRequest(true);
                } else {
                    BleManagerHandler.this.log(5, "Device is not supported");
                    BleManagerHandler.this.postCallback(c -> c.onDeviceNotSupported(gatt.getDevice()));
                    BleManagerHandler.this.internalDisconnect();
                }
            } else {
                Log.e((String)BleManagerHandler.TAG, (String)("onServicesDiscovered error " + status));
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_DISCOVERY_SERVICE, status);
                if (BleManagerHandler.this.connectRequest != null) {
                    BleManagerHandler.this.connectRequest.notifyFail(gatt.getDevice(), -4);
                    BleManagerHandler.this.connectRequest = null;
                }
                BleManagerHandler.this.internalDisconnect();
            }
        }

        public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            byte[] data = characteristic.getValue();
            if (status == 0) {
                BleManagerHandler.this.log(4, "Read Response received from " + characteristic.getUuid() + ", value: " + ParserUtils.parse(data));
                BleManagerHandler.this.onCharacteristicRead(gatt, characteristic);
                if (BleManagerHandler.this.request instanceof ReadRequest) {
                    ReadRequest rr = (ReadRequest)BleManagerHandler.this.request;
                    boolean matches = rr.matches(data);
                    if (matches) {
                        rr.notifyValueChanged(gatt.getDevice(), data);
                    }
                    if (!matches || rr.hasMore()) {
                        BleManagerHandler.this.enqueueFirst(rr);
                    } else {
                        rr.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManagerHandler.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManagerHandler.TAG, (String)BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED, status));
                    }
                    return;
                }
                Log.e((String)BleManagerHandler.TAG, (String)("onCharacteristicRead error " + status));
                if (BleManagerHandler.this.request instanceof ReadRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                }
                BleManagerHandler.this.awaitingRequest = null;
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_READ_CHARACTERISTIC, status);
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
            byte[] data = characteristic.getValue();
            if (status == 0) {
                BleManagerHandler.this.log(4, "Data written to " + characteristic.getUuid() + ", value: " + ParserUtils.parse(data));
                BleManagerHandler.this.onCharacteristicWrite(gatt, characteristic);
                if (BleManagerHandler.this.request instanceof WriteRequest) {
                    WriteRequest wr = (WriteRequest)BleManagerHandler.this.request;
                    boolean valid = wr.notifyPacketSent(gatt.getDevice(), data);
                    if (!valid && BleManagerHandler.this.requestQueue instanceof ReliableWriteRequest) {
                        wr.notifyFail(gatt.getDevice(), -6);
                        BleManagerHandler.this.requestQueue.cancelQueue();
                    } else if (wr.hasMore()) {
                        BleManagerHandler.this.enqueueFirst(wr);
                    } else {
                        wr.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManagerHandler.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManagerHandler.TAG, (String)BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED, status));
                    }
                    return;
                }
                Log.e((String)BleManagerHandler.TAG, (String)("onCharacteristicWrite error " + status));
                if (BleManagerHandler.this.request instanceof WriteRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                    if (BleManagerHandler.this.requestQueue instanceof ReliableWriteRequest) {
                        BleManagerHandler.this.requestQueue.cancelQueue();
                    }
                }
                BleManagerHandler.this.awaitingRequest = null;
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_WRITE_CHARACTERISTIC, status);
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        public final void onReliableWriteCompleted(@NonNull BluetoothGatt gatt, int status) {
            boolean execute = ((BleManagerHandler)BleManagerHandler.this).request.type == Request.Type.EXECUTE_RELIABLE_WRITE;
            BleManagerHandler.this.reliableWriteInProgress = false;
            if (status == 0) {
                if (execute) {
                    BleManagerHandler.this.log(4, "Reliable Write executed");
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                } else {
                    BleManagerHandler.this.log(5, "Reliable Write aborted");
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                    BleManagerHandler.this.requestQueue.notifyFail(gatt.getDevice(), -4);
                }
            } else {
                Log.e((String)BleManagerHandler.TAG, (String)("onReliableWriteCompleted execute " + execute + ", error " + status));
                BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_RELIABLE_WRITE, status);
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        public void onDescriptorRead(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            byte[] data = descriptor.getValue();
            if (status == 0) {
                BleManagerHandler.this.log(4, "Read Response received from descr. " + descriptor.getUuid() + ", value: " + ParserUtils.parse(data));
                BleManagerHandler.this.onDescriptorRead(gatt, descriptor);
                if (BleManagerHandler.this.request instanceof ReadRequest) {
                    ReadRequest request = (ReadRequest)BleManagerHandler.this.request;
                    request.notifyValueChanged(gatt.getDevice(), data);
                    if (request.hasMore()) {
                        BleManagerHandler.this.enqueueFirst(request);
                    } else {
                        request.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManagerHandler.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManagerHandler.TAG, (String)BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED, status));
                    }
                    return;
                }
                Log.e((String)BleManagerHandler.TAG, (String)("onDescriptorRead error " + status));
                if (BleManagerHandler.this.request instanceof ReadRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                }
                BleManagerHandler.this.awaitingRequest = null;
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_READ_DESCRIPTOR, status);
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
            byte[] data = descriptor.getValue();
            if (status == 0) {
                BleManagerHandler.this.log(4, "Data written to descr. " + descriptor.getUuid() + ", value: " + ParserUtils.parse(data));
                if (BleManagerHandler.this.isServiceChangedCCCD(descriptor)) {
                    BleManagerHandler.this.log(4, "Service Changed notifications enabled");
                } else if (BleManagerHandler.this.isCCCD(descriptor)) {
                    if (data != null && data.length == 2 && data[1] == 0) {
                        switch (data[0]) {
                            case 0: {
                                BleManagerHandler.this.log(4, "Notifications and indications disabled");
                                break;
                            }
                            case 1: {
                                BleManagerHandler.this.log(4, "Notifications enabled");
                                break;
                            }
                            case 2: {
                                BleManagerHandler.this.log(4, "Indications enabled");
                            }
                        }
                        BleManagerHandler.this.onDescriptorWrite(gatt, descriptor);
                    }
                } else {
                    BleManagerHandler.this.onDescriptorWrite(gatt, descriptor);
                }
                if (BleManagerHandler.this.request instanceof WriteRequest) {
                    WriteRequest wr = (WriteRequest)BleManagerHandler.this.request;
                    boolean valid = wr.notifyPacketSent(gatt.getDevice(), data);
                    if (!valid && BleManagerHandler.this.requestQueue instanceof ReliableWriteRequest) {
                        wr.notifyFail(gatt.getDevice(), -6);
                        BleManagerHandler.this.requestQueue.cancelQueue();
                    } else if (wr.hasMore()) {
                        BleManagerHandler.this.enqueueFirst(wr);
                    } else {
                        wr.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManagerHandler.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManagerHandler.TAG, (String)BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_AUTH_ERROR_WHILE_BONDED, status));
                    }
                    return;
                }
                Log.e((String)BleManagerHandler.TAG, (String)("onDescriptorWrite error " + status));
                if (BleManagerHandler.this.request instanceof WriteRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                    if (BleManagerHandler.this.requestQueue instanceof ReliableWriteRequest) {
                        BleManagerHandler.this.requestQueue.cancelQueue();
                    }
                }
                BleManagerHandler.this.awaitingRequest = null;
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_WRITE_DESCRIPTOR, status);
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
            byte[] data = characteristic.getValue();
            if (BleManagerHandler.this.isServiceChangedCharacteristic(characteristic)) {
                BleManagerHandler.this.operationInProgress = true;
                BleManagerHandler.this.taskQueue.clear();
                BleManagerHandler.this.initQueue = null;
                BleManagerHandler.this.log(4, "Service Changed indication received");
                BleManagerHandler.this.log(2, "Discovering Services...");
                BleManagerHandler.this.log(3, "gatt.discoverServices()");
                gatt.discoverServices();
            } else {
                WaitForValueChangedRequest valueChangedRequest;
                ValueChangedCallback request;
                BluetoothGattDescriptor cccd = characteristic.getDescriptor(BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID);
                boolean notifications = cccd == null || cccd.getValue() == null || cccd.getValue().length != 2 || cccd.getValue()[0] == 1;
                String dataString = ParserUtils.parse(data);
                if (notifications) {
                    BleManagerHandler.this.log(4, "Notification received from " + characteristic.getUuid() + ", value: " + dataString);
                    BleManagerHandler.this.onCharacteristicNotified(gatt, characteristic);
                } else {
                    BleManagerHandler.this.log(4, "Indication received from " + characteristic.getUuid() + ", value: " + dataString);
                    BleManagerHandler.this.onCharacteristicIndicated(gatt, characteristic);
                }
                if (BleManagerHandler.this.batteryLevelNotificationCallback != null && BleManagerHandler.this.isBatteryLevelCharacteristic(characteristic)) {
                    BleManagerHandler.this.batteryLevelNotificationCallback.notifyValueChanged(gatt.getDevice(), data);
                }
                if ((request = (ValueChangedCallback)BleManagerHandler.this.valueChangedCallbacks.get(characteristic)) != null && request.matches(data)) {
                    request.notifyValueChanged(gatt.getDevice(), data);
                }
                if (BleManagerHandler.this.awaitingRequest instanceof WaitForValueChangedRequest && ((BleManagerHandler)BleManagerHandler.this).awaitingRequest.characteristic == characteristic && !BleManagerHandler.this.awaitingRequest.isTriggerPending() && (valueChangedRequest = (WaitForValueChangedRequest)BleManagerHandler.this.awaitingRequest).matches(data)) {
                    valueChangedRequest.notifyValueChanged(gatt.getDevice(), data);
                    if (!valueChangedRequest.hasMore()) {
                        valueChangedRequest.notifySuccess(gatt.getDevice());
                        BleManagerHandler.this.awaitingRequest = null;
                        if (valueChangedRequest.isTriggerCompleteOrNull()) {
                            BleManagerHandler.this.nextRequest(true);
                        }
                    }
                }
                if (BleManagerHandler.this.checkCondition()) {
                    BleManagerHandler.this.nextRequest(true);
                }
            }
        }

        @RequiresApi(api=21)
        public final void onMtuChanged(@NonNull BluetoothGatt gatt, @IntRange(from=23L, to=517L) int mtu, int status) {
            if (status == 0) {
                BleManagerHandler.this.log(4, "MTU changed to: " + mtu);
                BleManagerHandler.this.mtu = mtu;
                BleManagerHandler.this.onMtuChanged(gatt, mtu);
                if (BleManagerHandler.this.request instanceof MtuRequest) {
                    ((MtuRequest)BleManagerHandler.this.request).notifyMtuChanged(gatt.getDevice(), mtu);
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                }
            } else {
                Log.e((String)BleManagerHandler.TAG, (String)("onMtuChanged error: " + status + ", mtu: " + mtu));
                if (BleManagerHandler.this.request instanceof MtuRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                    BleManagerHandler.this.awaitingRequest = null;
                }
                BleManagerHandler.this.onError(gatt.getDevice(), BleManagerHandler.ERROR_MTU_REQUEST, status);
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        @RequiresApi(api=26)
        public final void onConnectionUpdated(@NonNull BluetoothGatt gatt, @IntRange(from=6L, to=3200L) int interval, @IntRange(from=0L, to=499L) int latency, @IntRange(from=10L, to=3200L) int timeout, int status) {
            if (status == 0) {
                BleManagerHandler.this.log(4, "Connection parameters updated (interval: " + (double)interval * 1.25 + "ms, latency: " + latency + ", timeout: " + timeout * 10 + "ms)");
                BleManagerHandler.this.onConnectionUpdated(gatt, interval, latency, timeout);
                if (BleManagerHandler.this.request instanceof ConnectionPriorityRequest) {
                    ((ConnectionPriorityRequest)BleManagerHandler.this.request).notifyConnectionPriorityChanged(gatt.getDevice(), interval, latency, timeout);
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                }
            } else if (status == 59) {
                Log.e((String)BleManagerHandler.TAG, (String)("onConnectionUpdated received status: Unacceptable connection interval, interval: " + interval + ", latency: " + latency + ", timeout: " + timeout));
                BleManagerHandler.this.log(5, "Connection parameters update failed with status: UNACCEPT CONN INTERVAL (0x3b) (interval: " + (double)interval * 1.25 + "ms, latency: " + latency + ", timeout: " + timeout * 10 + "ms)");
                if (BleManagerHandler.this.request instanceof ConnectionPriorityRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                    BleManagerHandler.this.awaitingRequest = null;
                }
            } else {
                Log.e((String)BleManagerHandler.TAG, (String)("onConnectionUpdated received status: " + status + ", interval: " + interval + ", latency: " + latency + ", timeout: " + timeout));
                BleManagerHandler.this.log(5, "Connection parameters update failed with status " + status + " (interval: " + (double)interval * 1.25 + "ms, latency: " + latency + ", timeout: " + timeout * 10 + "ms)");
                if (BleManagerHandler.this.request instanceof ConnectionPriorityRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                    BleManagerHandler.this.awaitingRequest = null;
                }
                BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_CONNECTION_PRIORITY_REQUEST, status));
            }
            if (BleManagerHandler.this.connectionPriorityOperationInProgress) {
                BleManagerHandler.this.connectionPriorityOperationInProgress = false;
                BleManagerHandler.this.checkCondition();
                BleManagerHandler.this.nextRequest(true);
            }
        }

        @RequiresApi(api=26)
        public final void onPhyUpdate(@NonNull BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
            if (status == 0) {
                BleManagerHandler.this.log(4, "PHY updated (TX: " + ParserUtils.phyToString(txPhy) + ", RX: " + ParserUtils.phyToString(rxPhy) + ")");
                if (BleManagerHandler.this.request instanceof PhyRequest) {
                    ((PhyRequest)BleManagerHandler.this.request).notifyPhyChanged(gatt.getDevice(), txPhy, rxPhy);
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                }
            } else {
                BleManagerHandler.this.log(5, "PHY updated failed with status " + status);
                if (BleManagerHandler.this.request instanceof PhyRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                    BleManagerHandler.this.awaitingRequest = null;
                }
                BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_PHY_UPDATE, status));
            }
            if (BleManagerHandler.this.checkCondition() || BleManagerHandler.this.request instanceof PhyRequest) {
                BleManagerHandler.this.nextRequest(true);
            }
        }

        @RequiresApi(api=26)
        public final void onPhyRead(@NonNull BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
            if (status == 0) {
                BleManagerHandler.this.log(4, "PHY read (TX: " + ParserUtils.phyToString(txPhy) + ", RX: " + ParserUtils.phyToString(rxPhy) + ")");
                if (BleManagerHandler.this.request instanceof PhyRequest) {
                    ((PhyRequest)BleManagerHandler.this.request).notifyPhyChanged(gatt.getDevice(), txPhy, rxPhy);
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                }
            } else {
                BleManagerHandler.this.log(5, "PHY read failed with status " + status);
                if (BleManagerHandler.this.request instanceof PhyRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                }
                BleManagerHandler.this.awaitingRequest = null;
                BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_READ_PHY, status));
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }

        public final void onReadRemoteRssi(@NonNull BluetoothGatt gatt, @IntRange(from=-128L, to=20L) int rssi, int status) {
            if (status == 0) {
                BleManagerHandler.this.log(4, "Remote RSSI received: " + rssi + " dBm");
                if (BleManagerHandler.this.request instanceof ReadRssiRequest) {
                    ((ReadRssiRequest)BleManagerHandler.this.request).notifyRssiRead(gatt.getDevice(), rssi);
                    BleManagerHandler.this.request.notifySuccess(gatt.getDevice());
                }
            } else {
                BleManagerHandler.this.log(5, "Reading remote RSSI failed with status " + status);
                if (BleManagerHandler.this.request instanceof ReadRssiRequest) {
                    BleManagerHandler.this.request.notifyFail(gatt.getDevice(), status);
                }
                BleManagerHandler.this.awaitingRequest = null;
                BleManagerHandler.this.postCallback(c -> c.onError(gatt.getDevice(), BleManagerHandler.ERROR_READ_RSSI, status));
            }
            BleManagerHandler.this.checkCondition();
            BleManagerHandler.this.nextRequest(true);
        }
    };

    BleManagerHandler() {
    }

    void init(@NonNull BleManager manager, @NonNull Handler handler) {
        this.manager = manager;
        this.handler = handler;
    }

    void useServer(@Nullable BleServerManager server) {
        this.serverManager = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            Context context = this.manager.getContext();
            context.unregisterReceiver(this.bluetoothStateBroadcastReceiver);
            context.unregisterReceiver(this.mBondingBroadcastReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.bluetoothGatt != null) {
                if (this.manager.shouldClearCacheWhenDisconnected()) {
                    if (this.internalRefreshDeviceCache()) {
                        this.log(4, "Cache refreshed");
                    } else {
                        this.log(5, "Refreshing failed");
                    }
                }
                this.log(3, "gatt.close()");
                try {
                    this.bluetoothGatt.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.bluetoothGatt = null;
            }
            this.reliableWriteInProgress = false;
            this.initialConnection = false;
            this.valueChangedCallbacks.clear();
            this.taskQueue.clear();
            this.initQueue = null;
            this.bluetoothDevice = null;
        }
    }

    public BluetoothDevice getBluetoothDevice() {
        return this.bluetoothDevice;
    }

    @Nullable
    public final byte[] getCharacteristicValue(@NonNull BluetoothGattCharacteristic serverCharacteristic) {
        if (this.characteristicValues != null && this.characteristicValues.containsKey(serverCharacteristic)) {
            return this.characteristicValues.get(serverCharacteristic);
        }
        return serverCharacteristic.getValue();
    }

    @Nullable
    public final byte[] getDescriptorValue(@NonNull BluetoothGattDescriptor serverDescriptor) {
        if (this.descriptorValues != null && this.descriptorValues.containsKey(serverDescriptor)) {
            return this.descriptorValues.get(serverDescriptor);
        }
        return serverDescriptor.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean internalConnect(@NonNull BluetoothDevice device, @Nullable ConnectRequest connectRequest) {
        boolean bluetoothEnabled = BluetoothAdapter.getDefaultAdapter().isEnabled();
        if (this.connected || !bluetoothEnabled) {
            BluetoothDevice currentDevice = this.bluetoothDevice;
            if (bluetoothEnabled && currentDevice != null && currentDevice.equals((Object)device)) {
                this.connectRequest.notifySuccess(device);
            } else if (this.connectRequest != null) {
                this.connectRequest.notifyFail(device, bluetoothEnabled ? -4 : -100);
            }
            this.connectRequest = null;
            this.nextRequest(true);
            return true;
        }
        Context context = this.manager.getContext();
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.bluetoothGatt != null) {
            if (this.initialConnection) {
                this.initialConnection = false;
                this.connectionTime = 0L;
                this.connectionState = 1;
                this.log(2, "Connecting...");
                this.postCallback(c -> c.onDeviceConnecting(device));
                this.postConnectionStateChange(o -> o.onDeviceConnecting(device));
                this.log(3, "gatt.connect()");
                this.bluetoothGatt.connect();
                // MONITOREXIT : object
                return true;
            }
            this.log(3, "gatt.close()");
            try {
                this.bluetoothGatt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.bluetoothGatt = null;
            try {
                this.log(3, "wait(200)");
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            context.registerReceiver(this.bluetoothStateBroadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
            context.registerReceiver(this.mBondingBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
        }
        // MONITOREXIT : object
        if (connectRequest == null) {
            return false;
        }
        boolean shouldAutoConnect = connectRequest.shouldAutoConnect();
        boolean bl = this.userDisconnected = !shouldAutoConnect;
        if (shouldAutoConnect) {
            this.initialConnection = true;
        }
        this.bluetoothDevice = device;
        this.log(2, connectRequest.isFirstAttempt() ? "Connecting..." : "Retrying...");
        this.connectionState = 1;
        this.postCallback(c -> c.onDeviceConnecting(device));
        this.postConnectionStateChange(o -> o.onDeviceConnecting(device));
        this.connectionTime = SystemClock.elapsedRealtime();
        if (Build.VERSION.SDK_INT >= 26) {
            int preferredPhy = connectRequest.getPreferredPhy();
            this.log(3, "gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE, " + ParserUtils.phyMaskToString(preferredPhy) + ")");
            this.bluetoothGatt = device.connectGatt(context, false, this.gattCallback, 2, preferredPhy);
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.log(3, "gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE)");
            this.bluetoothGatt = device.connectGatt(context, false, this.gattCallback, 2);
            return true;
        }
        this.log(3, "gatt = device.connectGatt(autoConnect = false)");
        this.bluetoothGatt = device.connectGatt(context, false, this.gattCallback);
        return true;
    }

    private boolean internalDisconnect() {
        this.userDisconnected = true;
        this.initialConnection = false;
        this.ready = false;
        if (this.bluetoothGatt != null) {
            this.connectionState = 3;
            this.log(2, this.connected ? "Disconnecting..." : "Cancelling connection...");
            this.postCallback(c -> c.onDeviceDisconnecting(this.bluetoothGatt.getDevice()));
            this.postConnectionStateChange(o -> o.onDeviceDisconnecting(this.bluetoothGatt.getDevice()));
            boolean wasConnected = this.connected;
            this.log(3, "gatt.disconnect()");
            this.bluetoothGatt.disconnect();
            if (wasConnected) {
                return true;
            }
            this.connectionState = 0;
            this.log(4, "Disconnected");
            this.postCallback(c -> c.onDeviceDisconnected(this.bluetoothGatt.getDevice()));
            this.postConnectionStateChange(o -> o.onDeviceDisconnected(this.bluetoothGatt.getDevice(), 0));
        }
        if (this.request != null && this.request.type == Request.Type.DISCONNECT) {
            if (this.bluetoothDevice != null) {
                this.request.notifySuccess(this.bluetoothDevice);
            } else {
                this.request.notifyInvalidRequest();
            }
        }
        this.nextRequest(true);
        return true;
    }

    private boolean internalCreateBond() {
        BluetoothDevice device = this.bluetoothDevice;
        if (device == null) {
            return false;
        }
        this.log(2, "Starting pairing...");
        if (device.getBondState() == 12) {
            this.log(5, "Device already bonded");
            this.request.notifySuccess(device);
            this.nextRequest(true);
            return true;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.log(3, "device.createBond()");
            return device.createBond();
        }
        try {
            Method createBond = device.getClass().getMethod("createBond", new Class[0]);
            this.log(3, "device.createBond() (hidden)");
            return (Boolean)createBond.invoke((Object)device, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while creating bond", (Throwable)e);
            return false;
        }
    }

    private boolean internalRemoveBond() {
        BluetoothDevice device = this.bluetoothDevice;
        if (device == null) {
            return false;
        }
        this.log(2, "Removing bond information...");
        if (device.getBondState() == 10) {
            this.log(5, "Device is not bonded");
            this.request.notifySuccess(device);
            this.nextRequest(true);
            return true;
        }
        try {
            Method removeBond = device.getClass().getMethod("removeBond", new Class[0]);
            this.log(3, "device.removeBond() (hidden)");
            return (Boolean)removeBond.invoke((Object)device, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while removing bond", (Throwable)e);
            return false;
        }
    }

    private boolean ensureServiceChangedEnabled() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        BluetoothDevice device = gatt.getDevice();
        if (device.getBondState() != 12) {
            return false;
        }
        BluetoothGattService gaService = gatt.getService(BleManager.GENERIC_ATTRIBUTE_SERVICE);
        if (gaService == null) {
            return false;
        }
        BluetoothGattCharacteristic scCharacteristic = gaService.getCharacteristic(BleManager.SERVICE_CHANGED_CHARACTERISTIC);
        if (scCharacteristic == null) {
            return false;
        }
        this.log(4, "Service Changed characteristic found on a bonded device");
        return this.internalEnableIndications(scCharacteristic);
    }

    private boolean internalEnableNotifications(@Nullable BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || characteristic == null || !this.connected) {
            return false;
        }
        BluetoothGattDescriptor descriptor = BleManagerHandler.getCccd(characteristic, 16);
        if (descriptor != null) {
            this.log(3, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", true)");
            gatt.setCharacteristicNotification(characteristic, true);
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            this.log(2, "Enabling notifications for " + characteristic.getUuid());
            this.log(3, "gatt.writeDescriptor(" + BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID + ", value=0x01-00)");
            return this.internalWriteDescriptorWorkaround(descriptor);
        }
        return false;
    }

    private boolean internalDisableNotifications(@Nullable BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || characteristic == null || !this.connected) {
            return false;
        }
        BluetoothGattDescriptor descriptor = BleManagerHandler.getCccd(characteristic, 16);
        if (descriptor != null) {
            this.log(3, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", false)");
            gatt.setCharacteristicNotification(characteristic, false);
            descriptor.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            this.log(2, "Disabling notifications and indications for " + characteristic.getUuid());
            this.log(3, "gatt.writeDescriptor(" + BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID + ", value=0x00-00)");
            return this.internalWriteDescriptorWorkaround(descriptor);
        }
        return false;
    }

    private boolean internalEnableIndications(@Nullable BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || characteristic == null || !this.connected) {
            return false;
        }
        BluetoothGattDescriptor descriptor = BleManagerHandler.getCccd(characteristic, 32);
        if (descriptor != null) {
            this.log(3, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", true)");
            gatt.setCharacteristicNotification(characteristic, true);
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
            this.log(2, "Enabling indications for " + characteristic.getUuid());
            this.log(3, "gatt.writeDescriptor(" + BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID + ", value=0x02-00)");
            return this.internalWriteDescriptorWorkaround(descriptor);
        }
        return false;
    }

    private boolean internalDisableIndications(@Nullable BluetoothGattCharacteristic characteristic) {
        return this.internalDisableNotifications(characteristic);
    }

    private boolean internalSendNotification(@Nullable BluetoothGattCharacteristic serverCharacteristic, boolean confirm) {
        byte[] value;
        int requiredProperty;
        if (this.serverManager == null || this.serverManager.getServer() == null || serverCharacteristic == null) {
            return false;
        }
        int n = requiredProperty = confirm ? 32 : 16;
        if ((serverCharacteristic.getProperties() & requiredProperty) == 0) {
            return false;
        }
        BluetoothGattDescriptor cccd = serverCharacteristic.getDescriptor(BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID);
        if (cccd == null) {
            return false;
        }
        byte[] byArray = value = this.descriptorValues.containsKey(cccd) ? this.descriptorValues.get(cccd) : cccd.getValue();
        if (value != null && value.length == 2 && value[0] != 0) {
            this.log(2, "[Server] Sending " + (confirm ? "indication" : "notification") + " to " + serverCharacteristic.getUuid());
            this.log(3, "server.notifyCharacteristicChanged(device, " + serverCharacteristic.getUuid() + ", " + confirm + ")");
            boolean result = this.serverManager.getServer().notifyCharacteristicChanged(this.bluetoothDevice, serverCharacteristic, confirm);
            if (result && Build.VERSION.SDK_INT < 21) {
                this.post(() -> {
                    this.notifyNotificationSent(this.bluetoothDevice);
                    this.nextRequest(true);
                });
            }
            return result;
        }
        this.nextRequest(true);
        return true;
    }

    private static BluetoothGattDescriptor getCccd(@Nullable BluetoothGattCharacteristic characteristic, int requiredProperty) {
        if (characteristic == null) {
            return null;
        }
        int properties = characteristic.getProperties();
        if ((properties & requiredProperty) == 0) {
            return null;
        }
        return characteristic.getDescriptor(BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID);
    }

    private boolean internalReadCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || characteristic == null || !this.connected) {
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 2) == 0) {
            return false;
        }
        this.log(2, "Reading characteristic " + characteristic.getUuid());
        this.log(3, "gatt.readCharacteristic(" + characteristic.getUuid() + ")");
        return gatt.readCharacteristic(characteristic);
    }

    private boolean internalWriteCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || characteristic == null || !this.connected) {
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 0xC) == 0) {
            return false;
        }
        this.log(2, "Writing characteristic " + characteristic.getUuid() + " (" + ParserUtils.writeTypeToString(characteristic.getWriteType()) + ")");
        this.log(3, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        return gatt.writeCharacteristic(characteristic);
    }

    private boolean internalReadDescriptor(@Nullable BluetoothGattDescriptor descriptor) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || descriptor == null || !this.connected) {
            return false;
        }
        this.log(2, "Reading descriptor " + descriptor.getUuid());
        this.log(3, "gatt.readDescriptor(" + descriptor.getUuid() + ")");
        return gatt.readDescriptor(descriptor);
    }

    private boolean internalWriteDescriptor(@Nullable BluetoothGattDescriptor descriptor) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || descriptor == null || !this.connected) {
            return false;
        }
        this.log(2, "Writing descriptor " + descriptor.getUuid());
        this.log(3, "gatt.writeDescriptor(" + descriptor.getUuid() + ")");
        return this.internalWriteDescriptorWorkaround(descriptor);
    }

    private boolean internalWriteDescriptorWorkaround(@Nullable BluetoothGattDescriptor descriptor) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || descriptor == null || !this.connected) {
            return false;
        }
        BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
        int originalWriteType = parentCharacteristic.getWriteType();
        parentCharacteristic.setWriteType(2);
        boolean result = gatt.writeDescriptor(descriptor);
        parentCharacteristic.setWriteType(originalWriteType);
        return result;
    }

    private boolean internalBeginReliableWrite() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        if (this.reliableWriteInProgress) {
            return true;
        }
        this.log(2, "Beginning reliable write...");
        this.log(3, "gatt.beginReliableWrite()");
        this.reliableWriteInProgress = gatt.beginReliableWrite();
        return this.reliableWriteInProgress;
    }

    private boolean internalExecuteReliableWrite() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        if (!this.reliableWriteInProgress) {
            return false;
        }
        this.log(2, "Executing reliable write...");
        this.log(3, "gatt.executeReliableWrite()");
        return gatt.executeReliableWrite();
    }

    private boolean internalAbortReliableWrite() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        if (!this.reliableWriteInProgress) {
            return false;
        }
        this.log(2, "Aborting reliable write...");
        if (Build.VERSION.SDK_INT >= 19) {
            this.log(3, "gatt.abortReliableWrite()");
            gatt.abortReliableWrite();
        } else {
            this.log(3, "gatt.abortReliableWrite(device)");
            gatt.abortReliableWrite(gatt.getDevice());
        }
        return true;
    }

    @Deprecated
    private boolean internalReadBatteryLevel() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        BluetoothGattService batteryService = gatt.getService(BleManager.BATTERY_SERVICE);
        if (batteryService == null) {
            return false;
        }
        BluetoothGattCharacteristic batteryLevelCharacteristic = batteryService.getCharacteristic(BleManager.BATTERY_LEVEL_CHARACTERISTIC);
        return this.internalReadCharacteristic(batteryLevelCharacteristic);
    }

    @Deprecated
    private boolean internalSetBatteryNotifications(boolean enable) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        BluetoothGattService batteryService = gatt.getService(BleManager.BATTERY_SERVICE);
        if (batteryService == null) {
            return false;
        }
        BluetoothGattCharacteristic batteryLevelCharacteristic = batteryService.getCharacteristic(BleManager.BATTERY_LEVEL_CHARACTERISTIC);
        if (enable) {
            return this.internalEnableNotifications(batteryLevelCharacteristic);
        }
        return this.internalDisableNotifications(batteryLevelCharacteristic);
    }

    @RequiresApi(api=21)
    private boolean internalRequestMtu(@IntRange(from=23L, to=517L) int mtu) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        this.log(2, "Requesting new MTU...");
        this.log(3, "gatt.requestMtu(" + mtu + ")");
        return gatt.requestMtu(mtu);
    }

    @RequiresApi(api=21)
    private boolean internalRequestConnectionPriority(int priority) {
        String priorityText;
        String text;
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        switch (priority) {
            case 1: {
                text = Build.VERSION.SDK_INT >= 23 ? "HIGH (11.25\u201315ms, 0, 20s)" : "HIGH (7.5\u201310ms, 0, 20s)";
                priorityText = "HIGH";
                break;
            }
            case 2: {
                text = "LOW POWER (100\u2013125ms, 2, 20s)";
                priorityText = "LOW POWER";
                break;
            }
            default: {
                text = "BALANCED (30\u201350ms, 0, 20s)";
                priorityText = "BALANCED";
            }
        }
        this.log(2, "Requesting connection priority: " + text + "...");
        this.log(3, "gatt.requestConnectionPriority(" + priorityText + ")");
        return gatt.requestConnectionPriority(priority);
    }

    @RequiresApi(api=26)
    private boolean internalSetPreferredPhy(int txPhy, int rxPhy, int phyOptions) {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        this.log(2, "Requesting preferred PHYs...");
        this.log(3, "gatt.setPreferredPhy(" + ParserUtils.phyMaskToString(txPhy) + ", " + ParserUtils.phyMaskToString(rxPhy) + ", coding option = " + ParserUtils.phyCodedOptionToString(phyOptions) + ")");
        gatt.setPreferredPhy(txPhy, rxPhy, phyOptions);
        return true;
    }

    @RequiresApi(api=26)
    private boolean internalReadPhy() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        this.log(2, "Reading PHY...");
        this.log(3, "gatt.readPhy()");
        gatt.readPhy();
        return true;
    }

    private boolean internalReadRssi() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null || !this.connected) {
            return false;
        }
        this.log(2, "Reading remote RSSI...");
        this.log(3, "gatt.readRemoteRssi()");
        return gatt.readRemoteRssi();
    }

    @NonNull
    ValueChangedCallback getValueChangedCallback(@Nullable Object attribute) {
        ValueChangedCallback callback = this.valueChangedCallbacks.get(attribute);
        if (callback == null) {
            callback = new ValueChangedCallback(this);
            if (attribute != null) {
                this.valueChangedCallbacks.put(attribute, callback);
            }
        }
        return callback.free();
    }

    void removeValueChangedCallback(@Nullable Object attribute) {
        this.valueChangedCallbacks.remove(attribute);
    }

    @Deprecated
    DataReceivedCallback getBatteryLevelCallback() {
        return (device, data) -> {
            if (data.size() == 1) {
                int batteryLevel = data.getIntValue(17, 0);
                this.log(4, "Battery Level received: " + batteryLevel + "%");
                this.batteryValue = batteryLevel;
                this.onBatteryValueReceived(this.bluetoothGatt, batteryLevel);
                this.postCallback(c -> c.onBatteryValueReceived(device, batteryLevel));
            }
        };
    }

    @Deprecated
    void setBatteryLevelNotificationCallback() {
        if (this.batteryLevelNotificationCallback == null) {
            this.batteryLevelNotificationCallback = new ValueChangedCallback(this).with((device, data) -> {
                if (data.size() == 1) {
                    int batteryLevel;
                    this.batteryValue = batteryLevel = data.getIntValue(17, 0).intValue();
                    this.onBatteryValueReceived(this.bluetoothGatt, batteryLevel);
                    this.postCallback(c -> c.onBatteryValueReceived(device, batteryLevel));
                }
            });
        }
    }

    private boolean internalRefreshDeviceCache() {
        BluetoothGatt gatt = this.bluetoothGatt;
        if (gatt == null) {
            return false;
        }
        this.log(2, "Refreshing device cache...");
        this.log(3, "gatt.refresh() (hidden)");
        try {
            Method refresh = gatt.getClass().getMethod("refresh", new Class[0]);
            return (Boolean)refresh.invoke((Object)gatt, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while refreshing device", (Throwable)e);
            this.log(5, "gatt.refresh() method not found");
            return false;
        }
    }

    @Override
    final void enqueueFirst(@NonNull Request request) {
        Deque<Request> queue = this.initInProgress ? this.initQueue : this.taskQueue;
        queue.addFirst(request);
        request.enqueued = true;
    }

    @Override
    final void enqueue(@NonNull Request request) {
        Deque<Request> queue = this.initInProgress ? this.initQueue : this.taskQueue;
        queue.add(request);
        request.enqueued = true;
        this.nextRequest(false);
    }

    @Override
    final void cancelQueue() {
        this.taskQueue.clear();
        this.initQueue = null;
        if (this.awaitingRequest != null) {
            this.awaitingRequest.notifyFail(this.bluetoothDevice, -7);
        }
        if (this.request != null && this.awaitingRequest != this.request) {
            this.request.notifyFail(this.bluetoothDevice, -7);
            this.request = null;
        }
        this.awaitingRequest = null;
        if (this.requestQueue != null) {
            this.requestQueue.notifyFail(this.bluetoothDevice, -7);
            this.requestQueue = null;
        }
        if (this.connectRequest != null) {
            this.connectRequest.notifyFail(this.bluetoothDevice, -7);
            this.connectRequest = null;
            this.internalDisconnect();
        } else {
            this.nextRequest(true);
        }
    }

    @Override
    final void onRequestTimeout(@NonNull TimeoutableRequest request) {
        this.request = null;
        this.awaitingRequest = null;
        if (request.type == Request.Type.CONNECT) {
            this.connectRequest = null;
            this.internalDisconnect();
            return;
        }
        if (request.type == Request.Type.DISCONNECT) {
            this.close();
            return;
        }
        this.nextRequest(true);
    }

    @Override
    public void post(@NonNull Runnable r) {
        this.handler.post(r);
    }

    @Override
    public void postDelayed(@NonNull Runnable r, long delayMillis) {
        this.handler.postDelayed(r, delayMillis);
    }

    @Override
    public void removeCallbacks(@NonNull Runnable r) {
        this.handler.removeCallbacks(r);
    }

    @Deprecated
    private void postCallback(@NonNull CallbackRunnable r) {
        BleManagerCallbacks callbacks = this.manager.callbacks;
        if (callbacks != null) {
            this.post(() -> r.run(callbacks));
        }
    }

    private void postBondingStateChange(@NonNull BondingObserverRunnable r) {
        BondingObserver observer = this.manager.bondingObserver;
        if (observer != null) {
            this.post(() -> r.run(observer));
        }
    }

    private void postConnectionStateChange(@NonNull ConnectionObserverRunnable r) {
        ConnectionObserver observer = this.manager.connectionObserver;
        if (observer != null) {
            this.post(() -> r.run(observer));
        }
    }

    final int getConnectionState() {
        return this.connectionState;
    }

    final boolean isConnected() {
        return this.connected;
    }

    @Deprecated
    final int getBatteryValue() {
        return this.batteryValue;
    }

    final boolean isReady() {
        return this.ready;
    }

    final boolean isReliableWriteInProgress() {
        return this.reliableWriteInProgress;
    }

    final int getMtu() {
        return this.mtu;
    }

    final void overrideMtu(@IntRange(from=23L, to=517L) int mtu) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mtu = mtu;
        }
    }

    protected abstract boolean isRequiredServiceSupported(@NonNull BluetoothGatt var1);

    protected boolean isOptionalServiceSupported(@NonNull BluetoothGatt gatt) {
        return false;
    }

    @Deprecated
    protected Deque<Request> initGatt(@NonNull BluetoothGatt gatt) {
        return null;
    }

    protected void initialize() {
    }

    protected void onServerReady(@NonNull BluetoothGattServer server) {
    }

    protected void onDeviceReady() {
    }

    protected void onManagerReady() {
    }

    protected abstract void onDeviceDisconnected();

    private void notifyDeviceDisconnected(@NonNull BluetoothDevice device, int status) {
        boolean wasConnected = this.connected;
        this.connected = false;
        this.servicesDiscovered = false;
        this.serviceDiscoveryRequested = false;
        this.initInProgress = false;
        this.connectionState = 0;
        this.checkCondition();
        if (!wasConnected) {
            this.log(5, "Connection attempt timed out");
            this.close();
            this.postCallback(c -> c.onDeviceDisconnected(device));
            this.postConnectionStateChange(o -> o.onDeviceFailedToConnect(device, status));
        } else if (this.userDisconnected) {
            this.log(4, "Disconnected");
            this.close();
            this.postCallback(c -> c.onDeviceDisconnected(device));
            this.postConnectionStateChange(o -> o.onDeviceDisconnected(device, status));
            Request request = this.request;
            if (request != null && request.type == Request.Type.DISCONNECT) {
                request.notifySuccess(device);
            }
        } else {
            this.log(5, "Connection lost");
            this.postCallback(c -> c.onLinkLossOccurred(device));
            this.postConnectionStateChange(o -> o.onDeviceDisconnected(device, 3));
        }
        this.onDeviceDisconnected();
    }

    @Deprecated
    protected void onCharacteristicRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
    }

    @Deprecated
    protected void onCharacteristicWrite(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
    }

    @Deprecated
    protected void onDescriptorRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor) {
    }

    @Deprecated
    protected void onDescriptorWrite(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor) {
    }

    @Deprecated
    protected void onBatteryValueReceived(@NonNull BluetoothGatt gatt, @IntRange(from=0L, to=100L) int value) {
    }

    @Deprecated
    protected void onCharacteristicNotified(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
    }

    @Deprecated
    protected void onCharacteristicIndicated(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
    }

    @Deprecated
    protected void onMtuChanged(@NonNull BluetoothGatt gatt, @IntRange(from=23L, to=517L) int mtu) {
    }

    @Deprecated
    @TargetApi(value=26)
    protected void onConnectionUpdated(@NonNull BluetoothGatt gatt, @IntRange(from=6L, to=3200L) int interval, @IntRange(from=0L, to=499L) int latency, @IntRange(from=10L, to=3200L) int timeout) {
    }

    private void onError(BluetoothDevice device, String message, int errorCode) {
        this.log(6, "Error (0x" + Integer.toHexString(errorCode) + "): " + GattError.parse(errorCode));
        this.postCallback(c -> c.onError(device, message, errorCode));
    }

    private int mapDisconnectStatusToReason(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case 22: {
                return 1;
            }
            case 19: {
                return 2;
            }
            case 8: {
                return 10;
            }
        }
        return -1;
    }

    final void onCharacteristicReadRequest(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int requestId, int offset, @NonNull BluetoothGattCharacteristic characteristic) {
        this.log(3, "[Server callback] Read request for characteristic " + characteristic.getUuid() + " (requestId=" + requestId + ", offset: " + offset + ")");
        if (offset == 0) {
            this.log(4, "[Server] READ request for characteristic " + characteristic.getUuid() + " received");
        }
        byte[] data = this.characteristicValues == null || !this.characteristicValues.containsKey(characteristic) ? characteristic.getValue() : this.characteristicValues.get(characteristic);
        WaitForReadRequest waitForReadRequest = null;
        if (this.awaitingRequest instanceof WaitForReadRequest && this.awaitingRequest.characteristic == characteristic && !this.awaitingRequest.isTriggerPending()) {
            waitForReadRequest = (WaitForReadRequest)this.awaitingRequest;
            waitForReadRequest.setDataIfNull(data);
            data = waitForReadRequest.getData(this.mtu);
        }
        if (data != null && data.length > this.mtu - 1) {
            data = Bytes.copy(data, offset, this.mtu - 1);
        }
        this.sendResponse(server, device, 0, requestId, offset, data);
        if (waitForReadRequest != null) {
            waitForReadRequest.notifyPacketRead(device, data);
            if (!(waitForReadRequest.hasMore() || data != null && data.length >= this.mtu - 1)) {
                waitForReadRequest.notifySuccess(device);
                this.awaitingRequest = null;
                this.nextRequest(true);
            }
        } else if (this.checkCondition()) {
            this.nextRequest(true);
        }
    }

    final void onCharacteristicWriteRequest(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int requestId, @NonNull BluetoothGattCharacteristic characteristic, boolean preparedWrite, boolean responseNeeded, int offset, @NonNull byte[] value) {
        this.log(3, "[Server callback] Write " + (responseNeeded ? "request" : "command") + " to characteristic " + characteristic.getUuid() + " (requestId=" + requestId + ", prepareWrite=" + preparedWrite + ", responseNeeded=" + responseNeeded + ", offset: " + offset + ", value=" + ParserUtils.parseDebug(value) + ")");
        if (offset == 0) {
            String type = responseNeeded ? "WRITE REQUEST" : "WRITE COMMAND";
            String option = preparedWrite ? "Prepare " : "";
            this.log(4, "[Server] " + option + type + " for characteristic " + characteristic.getUuid() + " received, value: " + ParserUtils.parse(value));
        }
        if (responseNeeded) {
            this.sendResponse(server, device, 0, requestId, offset, value);
        }
        if (preparedWrite) {
            if (this.preparedValues == null) {
                this.preparedValues = new LinkedList<Pair<Object, byte[]>>();
            }
            if (offset == 0) {
                this.preparedValues.offer((Pair<Object, byte[]>)new Pair((Object)characteristic, (Object)value));
            } else {
                Pair<Object, byte[]> last = this.preparedValues.peekLast();
                if (last != null && characteristic.equals(last.first)) {
                    this.preparedValues.pollLast();
                    this.preparedValues.offer((Pair<Object, byte[]>)new Pair((Object)characteristic, (Object)Bytes.concat((byte[])last.second, value, offset)));
                } else {
                    this.prepareError = 7;
                }
            }
        } else if (this.assignAndNotify(device, characteristic, value) || this.checkCondition()) {
            this.nextRequest(true);
        }
    }

    final void onDescriptorReadRequest(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int requestId, int offset, @NonNull BluetoothGattDescriptor descriptor) {
        this.log(3, "[Server callback] Read request for descriptor " + descriptor.getUuid() + " (requestId=" + requestId + ", offset: " + offset + ")");
        if (offset == 0) {
            this.log(4, "[Server] READ request for descriptor " + descriptor.getUuid() + " received");
        }
        byte[] data = this.descriptorValues == null || !this.descriptorValues.containsKey(descriptor) ? descriptor.getValue() : this.descriptorValues.get(descriptor);
        WaitForReadRequest waitForReadRequest = null;
        if (this.awaitingRequest instanceof WaitForReadRequest && this.awaitingRequest.descriptor == descriptor && !this.awaitingRequest.isTriggerPending()) {
            waitForReadRequest = (WaitForReadRequest)this.awaitingRequest;
            waitForReadRequest.setDataIfNull(data);
            data = waitForReadRequest.getData(this.mtu);
        }
        if (data != null && data.length > this.mtu - 1) {
            data = Bytes.copy(data, offset, this.mtu - 1);
        }
        this.sendResponse(server, device, 0, requestId, offset, data);
        if (waitForReadRequest != null) {
            waitForReadRequest.notifyPacketRead(device, data);
            if (!(waitForReadRequest.hasMore() || data != null && data.length >= this.mtu - 1)) {
                waitForReadRequest.notifySuccess(device);
                this.awaitingRequest = null;
                this.nextRequest(true);
            }
        } else if (this.checkCondition()) {
            this.nextRequest(true);
        }
    }

    final void onDescriptorWriteRequest(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int requestId, @NonNull BluetoothGattDescriptor descriptor, boolean preparedWrite, boolean responseNeeded, int offset, @NonNull byte[] value) {
        this.log(3, "[Server callback] Write " + (responseNeeded ? "request" : "command") + " to descriptor " + descriptor.getUuid() + " (requestId=" + requestId + ", prepareWrite=" + preparedWrite + ", responseNeeded=" + responseNeeded + ", offset: " + offset + ", value=" + ParserUtils.parseDebug(value) + ")");
        if (offset == 0) {
            String type = responseNeeded ? "WRITE REQUEST" : "WRITE COMMAND";
            String option = preparedWrite ? "Prepare " : "";
            this.log(4, "[Server] " + option + type + " request for descriptor " + descriptor.getUuid() + " received, value: " + ParserUtils.parse(value));
        }
        if (responseNeeded) {
            this.sendResponse(server, device, 0, requestId, offset, value);
        }
        if (preparedWrite) {
            if (this.preparedValues == null) {
                this.preparedValues = new LinkedList<Pair<Object, byte[]>>();
            }
            if (offset == 0) {
                this.preparedValues.offer((Pair<Object, byte[]>)new Pair((Object)descriptor, (Object)value));
            } else {
                Pair<Object, byte[]> last = this.preparedValues.peekLast();
                if (last != null && descriptor.equals(last.first)) {
                    this.preparedValues.pollLast();
                    this.preparedValues.offer((Pair<Object, byte[]>)new Pair((Object)descriptor, (Object)Bytes.concat((byte[])last.second, value, offset)));
                } else {
                    this.prepareError = 7;
                }
            }
        } else if (this.assignAndNotify(device, descriptor, value) || this.checkCondition()) {
            this.nextRequest(true);
        }
    }

    final void onExecuteWrite(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int requestId, boolean execute) {
        this.log(3, "[Server callback] Execute write request (requestId=" + requestId + ", execute=" + execute + ")");
        if (execute) {
            Deque<Pair<Object, byte[]>> values = this.preparedValues;
            this.log(4, "[Server] Execute write request received");
            this.preparedValues = null;
            if (this.prepareError != 0) {
                this.sendResponse(server, device, this.prepareError, requestId, 0, null);
                this.prepareError = 0;
                return;
            }
            this.sendResponse(server, device, 0, requestId, 0, null);
            if (values == null || values.isEmpty()) {
                return;
            }
            boolean startNextRequest = false;
            for (Pair<Object, byte[]> value : values) {
                if (value.first instanceof BluetoothGattCharacteristic) {
                    BluetoothGattCharacteristic characteristic = (BluetoothGattCharacteristic)value.first;
                    startNextRequest = this.assignAndNotify(device, characteristic, (byte[])value.second) || startNextRequest;
                    continue;
                }
                if (!(value.first instanceof BluetoothGattDescriptor)) continue;
                BluetoothGattDescriptor descriptor = (BluetoothGattDescriptor)value.first;
                startNextRequest = this.assignAndNotify(device, descriptor, (byte[])value.second) || startNextRequest;
            }
            if (this.checkCondition() || startNextRequest) {
                this.nextRequest(true);
            }
        } else {
            this.log(4, "[Server] Cancel write request received");
            this.preparedValues = null;
            this.sendResponse(server, device, 0, requestId, 0, null);
        }
    }

    final void onNotificationSent(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int status) {
        this.log(3, "[Server callback] Notification sent (status=" + status + ")");
        if (status == 0) {
            this.notifyNotificationSent(device);
        } else {
            Log.e((String)TAG, (String)("onNotificationSent error " + status));
            if (this.request instanceof WriteRequest) {
                this.request.notifyFail(device, status);
            }
            this.awaitingRequest = null;
            this.onError(device, ERROR_NOTIFY, status);
        }
        this.checkCondition();
        this.nextRequest(true);
    }

    @RequiresApi(api=22)
    final void onMtuChanged(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int mtu) {
        this.log(4, "[Server] MTU changed to: " + mtu);
        this.mtu = mtu;
        this.checkCondition();
        this.nextRequest(false);
    }

    private void notifyNotificationSent(@NonNull BluetoothDevice device) {
        if (this.request instanceof WriteRequest) {
            WriteRequest wr = (WriteRequest)this.request;
            switch (wr.type) {
                case NOTIFY: {
                    this.log(4, "[Server] Notification sent");
                    break;
                }
                case INDICATE: {
                    this.log(4, "[Server] Indication sent");
                }
            }
            wr.notifyPacketSent(device, wr.characteristic.getValue());
            if (wr.hasMore()) {
                this.enqueueFirst(wr);
            } else {
                wr.notifySuccess(device);
            }
        }
    }

    private boolean assignAndNotify(@NonNull BluetoothDevice device, @NonNull BluetoothGattCharacteristic characteristic, @NonNull byte[] value) {
        WaitForValueChangedRequest waitForWrite;
        boolean isShared;
        boolean bl = isShared = this.characteristicValues == null || !this.characteristicValues.containsKey(characteristic);
        if (isShared) {
            characteristic.setValue(value);
        } else {
            this.characteristicValues.put(characteristic, value);
        }
        ValueChangedCallback callback = this.valueChangedCallbacks.get(characteristic);
        if (callback != null) {
            callback.notifyValueChanged(device, value);
        }
        if (this.awaitingRequest instanceof WaitForValueChangedRequest && this.awaitingRequest.characteristic == characteristic && !this.awaitingRequest.isTriggerPending() && (waitForWrite = (WaitForValueChangedRequest)this.awaitingRequest).matches(value)) {
            waitForWrite.notifyValueChanged(device, value);
            if (!waitForWrite.hasMore()) {
                waitForWrite.notifySuccess(device);
                this.awaitingRequest = null;
                return waitForWrite.isTriggerCompleteOrNull();
            }
        }
        return false;
    }

    private boolean assignAndNotify(@NonNull BluetoothDevice device, @NonNull BluetoothGattDescriptor descriptor, @NonNull byte[] value) {
        WaitForValueChangedRequest waitForWrite;
        boolean isShared;
        boolean bl = isShared = this.descriptorValues == null || !this.descriptorValues.containsKey(descriptor);
        if (isShared) {
            descriptor.setValue(value);
        } else {
            this.descriptorValues.put(descriptor, value);
        }
        ValueChangedCallback callback = this.valueChangedCallbacks.get(descriptor);
        if (callback != null) {
            callback.notifyValueChanged(device, value);
        }
        if (this.awaitingRequest instanceof WaitForValueChangedRequest && this.awaitingRequest.descriptor == descriptor && !this.awaitingRequest.isTriggerPending() && (waitForWrite = (WaitForValueChangedRequest)this.awaitingRequest).matches(value)) {
            waitForWrite.notifyValueChanged(device, value);
            if (!waitForWrite.hasMore()) {
                waitForWrite.notifySuccess(device);
                this.awaitingRequest = null;
                return waitForWrite.isTriggerCompleteOrNull();
            }
        }
        return false;
    }

    private void sendResponse(@NonNull BluetoothGattServer server, @NonNull BluetoothDevice device, int status, int requestId, int offset, @Nullable byte[] response) {
        String msg;
        switch (status) {
            case 0: {
                msg = "GATT_SUCCESS";
                break;
            }
            case 6: {
                msg = "GATT_REQUEST_NOT_SUPPORTED";
                break;
            }
            case 7: {
                msg = "GATT_INVALID_OFFSET";
                break;
            }
            default: {
                throw new InvalidParameterException();
            }
        }
        this.log(3, "server.sendResponse(" + msg + ", offset=" + offset + ", value=" + ParserUtils.parseDebug(response) + ")");
        server.sendResponse(device, requestId, status, offset, response);
        this.log(2, "[Server] Response sent");
    }

    private boolean checkCondition() {
        ConditionalWaitRequest cwr;
        if (this.awaitingRequest instanceof ConditionalWaitRequest && (cwr = (ConditionalWaitRequest)this.awaitingRequest).isFulfilled()) {
            cwr.notifySuccess(this.bluetoothDevice);
            this.awaitingRequest = null;
            return true;
        }
        return false;
    }

    private synchronized void nextRequest(boolean force) {
        ConnectRequest cr;
        Request r;
        if (force) {
            boolean bl = this.operationInProgress = this.awaitingRequest != null;
        }
        if (this.operationInProgress) {
            return;
        }
        Request request = null;
        try {
            if (this.requestQueue != null) {
                if (this.requestQueue.hasMore()) {
                    request = this.requestQueue.getNext().setRequestHandler(this);
                } else {
                    this.requestQueue.notifySuccess(this.bluetoothDevice);
                    this.requestQueue = null;
                }
            }
            if (request == null) {
                request = this.initQueue != null ? this.initQueue.poll() : null;
            }
        }
        catch (Exception e) {
            request = null;
        }
        if (request == null) {
            if (this.initQueue != null) {
                this.initQueue = null;
                this.operationInProgress = true;
                this.ready = true;
                this.onDeviceReady();
                this.postCallback(c -> c.onDeviceReady(this.bluetoothGatt.getDevice()));
                this.postConnectionStateChange(o -> o.onDeviceReady(this.bluetoothGatt.getDevice()));
                if (this.connectRequest != null) {
                    this.connectRequest.notifySuccess(this.connectRequest.getDevice());
                    this.connectRequest = null;
                }
            }
            try {
                request = this.taskQueue.remove();
            }
            catch (Exception e) {
                this.operationInProgress = false;
                this.request = null;
                this.onManagerReady();
                return;
            }
        }
        boolean result = false;
        this.operationInProgress = true;
        this.request = request;
        if (request instanceof AwaitingRequest) {
            r = (AwaitingRequest)request;
            int requiredProperty = 0;
            switch (request.type) {
                case WAIT_FOR_NOTIFICATION: {
                    requiredProperty = 16;
                    break;
                }
                case WAIT_FOR_INDICATION: {
                    requiredProperty = 32;
                    break;
                }
                case WAIT_FOR_READ: {
                    requiredProperty = 2;
                    break;
                }
                case WAIT_FOR_WRITE: {
                    requiredProperty = 76;
                }
            }
            boolean bl = result = this.connected && this.bluetoothDevice != null && (((AwaitingRequest)r).characteristic == null || (((AwaitingRequest)r).characteristic.getProperties() & requiredProperty) != 0);
            if (result) {
                ConditionalWaitRequest cwr;
                if (r instanceof ConditionalWaitRequest && (cwr = (ConditionalWaitRequest)r).isFulfilled()) {
                    cwr.notifyStarted(this.bluetoothDevice);
                    cwr.notifySuccess(this.bluetoothDevice);
                    this.nextRequest(true);
                    return;
                }
                this.awaitingRequest = r;
                if (((AwaitingRequest)r).getTrigger() != null) {
                    ((TimeoutableRequest)r).notifyStarted(this.bluetoothDevice);
                    this.request = request = ((AwaitingRequest)r).getTrigger();
                }
            }
        }
        if (request.type == Request.Type.CONNECT) {
            cr = (ConnectRequest)request;
            cr.notifyStarted(cr.getDevice());
        } else if (this.bluetoothDevice != null) {
            request.notifyStarted(this.bluetoothDevice);
        } else {
            request.notifyInvalidRequest();
            this.awaitingRequest = null;
            this.nextRequest(true);
            return;
        }
        switch (request.type) {
            case CONNECT: {
                this.connectRequest = cr = (ConnectRequest)request;
                this.request = null;
                result = this.internalConnect(cr.getDevice(), cr);
                break;
            }
            case DISCONNECT: {
                result = this.internalDisconnect();
                break;
            }
            case CREATE_BOND: {
                result = this.internalCreateBond();
                break;
            }
            case REMOVE_BOND: {
                result = this.internalRemoveBond();
                break;
            }
            case SET: {
                this.requestQueue = (RequestQueue)request;
                this.nextRequest(true);
                return;
            }
            case READ: {
                result = this.internalReadCharacteristic(request.characteristic);
                break;
            }
            case WRITE: {
                WriteRequest wr = (WriteRequest)request;
                BluetoothGattCharacteristic characteristic = request.characteristic;
                if (characteristic != null) {
                    characteristic.setValue(wr.getData(this.mtu));
                    characteristic.setWriteType(wr.getWriteType());
                }
                result = this.internalWriteCharacteristic(characteristic);
                break;
            }
            case READ_DESCRIPTOR: {
                result = this.internalReadDescriptor(request.descriptor);
                break;
            }
            case WRITE_DESCRIPTOR: {
                WriteRequest wr = (WriteRequest)request;
                BluetoothGattDescriptor descriptor = request.descriptor;
                if (descriptor != null) {
                    descriptor.setValue(wr.getData(this.mtu));
                }
                result = this.internalWriteDescriptor(descriptor);
                break;
            }
            case NOTIFY: 
            case INDICATE: {
                WriteRequest wr = (WriteRequest)request;
                BluetoothGattCharacteristic characteristic = request.characteristic;
                if (characteristic != null) {
                    characteristic.setValue(wr.getData(this.mtu));
                    if (this.characteristicValues != null && this.characteristicValues.containsKey(characteristic)) {
                        this.characteristicValues.put(characteristic, characteristic.getValue());
                    }
                }
                result = this.internalSendNotification(request.characteristic, request.type == Request.Type.INDICATE);
                break;
            }
            case SET_VALUE: {
                SetValueRequest svr = (SetValueRequest)request;
                if (svr.characteristic == null) break;
                if (this.characteristicValues != null && this.characteristicValues.containsKey(svr.characteristic)) {
                    this.characteristicValues.put(svr.characteristic, svr.getData(this.mtu));
                } else {
                    svr.characteristic.setValue(svr.getData(this.mtu));
                }
                result = true;
                svr.notifySuccess(this.bluetoothDevice);
                this.nextRequest(true);
                break;
            }
            case SET_DESCRIPTOR_VALUE: {
                SetValueRequest svr = (SetValueRequest)request;
                if (svr.descriptor == null) break;
                if (this.descriptorValues != null && this.descriptorValues.containsKey(svr.descriptor)) {
                    this.descriptorValues.put(svr.descriptor, svr.getData(this.mtu));
                } else {
                    svr.descriptor.setValue(svr.getData(this.mtu));
                }
                result = true;
                svr.notifySuccess(this.bluetoothDevice);
                this.nextRequest(true);
                break;
            }
            case BEGIN_RELIABLE_WRITE: {
                result = this.internalBeginReliableWrite();
                if (!result) break;
                this.request.notifySuccess(this.bluetoothDevice);
                this.nextRequest(true);
                return;
            }
            case EXECUTE_RELIABLE_WRITE: {
                result = this.internalExecuteReliableWrite();
                break;
            }
            case ABORT_RELIABLE_WRITE: {
                result = this.internalAbortReliableWrite();
                break;
            }
            case ENABLE_NOTIFICATIONS: {
                result = this.internalEnableNotifications(request.characteristic);
                break;
            }
            case ENABLE_INDICATIONS: {
                result = this.internalEnableIndications(request.characteristic);
                break;
            }
            case DISABLE_NOTIFICATIONS: {
                result = this.internalDisableNotifications(request.characteristic);
                break;
            }
            case DISABLE_INDICATIONS: {
                result = this.internalDisableIndications(request.characteristic);
                break;
            }
            case READ_BATTERY_LEVEL: {
                result = this.internalReadBatteryLevel();
                break;
            }
            case ENABLE_BATTERY_LEVEL_NOTIFICATIONS: {
                result = this.internalSetBatteryNotifications(true);
                break;
            }
            case DISABLE_BATTERY_LEVEL_NOTIFICATIONS: {
                result = this.internalSetBatteryNotifications(false);
                break;
            }
            case ENABLE_SERVICE_CHANGED_INDICATIONS: {
                result = this.ensureServiceChangedEnabled();
                break;
            }
            case REQUEST_MTU: {
                MtuRequest mr = (MtuRequest)request;
                if (this.mtu != mr.getRequiredMtu() && Build.VERSION.SDK_INT >= 21) {
                    result = this.internalRequestMtu(mr.getRequiredMtu());
                    break;
                }
                result = this.connected;
                if (!result) break;
                mr.notifyMtuChanged(this.bluetoothDevice, this.mtu);
                mr.notifySuccess(this.bluetoothDevice);
                this.nextRequest(true);
                return;
            }
            case REQUEST_CONNECTION_PRIORITY: {
                ConnectionPriorityRequest cpr = (ConnectionPriorityRequest)request;
                if (Build.VERSION.SDK_INT >= 26) {
                    this.connectionPriorityOperationInProgress = true;
                    result = this.internalRequestConnectionPriority(cpr.getRequiredPriority());
                    break;
                }
                if (Build.VERSION.SDK_INT < 21 || !(result = this.internalRequestConnectionPriority(cpr.getRequiredPriority()))) break;
                BluetoothDevice device = this.bluetoothDevice;
                this.postDelayed(() -> {
                    cpr.notifySuccess(device);
                    this.nextRequest(true);
                }, 100L);
                break;
            }
            case SET_PREFERRED_PHY: {
                PhyRequest pr = (PhyRequest)request;
                if (Build.VERSION.SDK_INT >= 26) {
                    result = this.internalSetPreferredPhy(pr.getPreferredTxPhy(), pr.getPreferredRxPhy(), pr.getPreferredPhyOptions());
                    break;
                }
                result = this.connected;
                if (!result) break;
                pr.notifyLegacyPhy(this.bluetoothDevice);
                pr.notifySuccess(this.bluetoothDevice);
                this.nextRequest(true);
                return;
            }
            case READ_PHY: {
                PhyRequest pr = (PhyRequest)request;
                if (Build.VERSION.SDK_INT >= 26) {
                    result = this.internalReadPhy();
                    break;
                }
                result = this.connected;
                if (!result) break;
                pr.notifyLegacyPhy(this.bluetoothDevice);
                pr.notifySuccess(this.bluetoothDevice);
                this.nextRequest(true);
                return;
            }
            case READ_RSSI: {
                result = this.internalReadRssi();
                break;
            }
            case REFRESH_CACHE: {
                r = request;
                result = this.internalRefreshDeviceCache();
                if (!result) break;
                BluetoothDevice device = this.bluetoothDevice;
                this.postDelayed(() -> {
                    this.log(4, "Cache refreshed");
                    r.notifySuccess(device);
                    this.request = null;
                    if (this.awaitingRequest != null) {
                        this.awaitingRequest.notifyFail(device, -3);
                        this.awaitingRequest = null;
                    }
                    this.taskQueue.clear();
                    this.initQueue = null;
                    if (this.connected) {
                        this.onDeviceDisconnected();
                        this.log(2, "Discovering Services...");
                        this.log(3, "gatt.discoverServices()");
                        this.bluetoothGatt.discoverServices();
                    }
                }, 200L);
                break;
            }
            case SLEEP: {
                BluetoothDevice device = this.bluetoothDevice;
                if (device == null) break;
                SleepRequest sr = (SleepRequest)request;
                this.log(3, "sleep(" + sr.getDelay() + ")");
                this.postDelayed(() -> {
                    sr.notifySuccess(device);
                    this.nextRequest(true);
                }, sr.getDelay());
                result = true;
                break;
            }
        }
        if (!result) {
            this.request.notifyFail(this.bluetoothDevice, this.connected ? -3 : (BluetoothAdapter.getDefaultAdapter().isEnabled() ? -1 : -100));
            this.awaitingRequest = null;
            this.connectionPriorityOperationInProgress = false;
            this.nextRequest(true);
        }
    }

    private boolean isServiceChangedCCCD(@Nullable BluetoothGattDescriptor descriptor) {
        return descriptor != null && BleManager.SERVICE_CHANGED_CHARACTERISTIC.equals(descriptor.getCharacteristic().getUuid());
    }

    private boolean isServiceChangedCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
        return characteristic != null && BleManager.SERVICE_CHANGED_CHARACTERISTIC.equals(characteristic.getUuid());
    }

    @Deprecated
    private boolean isBatteryLevelCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
        return characteristic != null && BleManager.BATTERY_LEVEL_CHARACTERISTIC.equals(characteristic.getUuid());
    }

    private boolean isCCCD(@Nullable BluetoothGattDescriptor descriptor) {
        return descriptor != null && BleManager.CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID.equals(descriptor.getUuid());
    }

    private void log(int priority, @NonNull String message) {
        this.manager.log(priority, message);
    }

    private static interface ConnectionObserverRunnable {
        public void run(@NonNull ConnectionObserver var1);
    }

    private static interface BondingObserverRunnable {
        public void run(@NonNull BondingObserver var1);
    }

    @Deprecated
    private static interface CallbackRunnable {
        public void run(@NonNull BleManagerCallbacks var1);
    }
}

