/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.TimeoutableRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public class ConnectRequest
extends TimeoutableRequest {
    @NonNull
    private BluetoothDevice device;
    private int preferredPhy;
    @IntRange(from=0L)
    private int attempt = 0;
    @IntRange(from=0L)
    private int retries = 0;
    @IntRange(from=0L)
    private int delay = 0;
    private boolean autoConnect = false;

    ConnectRequest(@NonNull Request.Type type, @NonNull BluetoothDevice device) {
        super(type);
        this.device = device;
        this.preferredPhy = 1;
    }

    @Override
    @NonNull
    ConnectRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ConnectRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ConnectRequest timeout(@IntRange(from=0L) long timeout) {
        super.timeout(timeout);
        return this;
    }

    @Override
    @NonNull
    public ConnectRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ConnectRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    public ConnectRequest retry(@IntRange(from=0L) int count) {
        this.retries = count;
        this.delay = 0;
        return this;
    }

    public ConnectRequest retry(@IntRange(from=0L) int count, @IntRange(from=0L) int delay) {
        this.retries = count;
        this.delay = delay;
        return this;
    }

    public ConnectRequest useAutoConnect(boolean autoConnect) {
        this.autoConnect = autoConnect;
        return this;
    }

    public ConnectRequest usePreferredPhy(int phy) {
        this.preferredPhy = phy;
        return this;
    }

    @NonNull
    public BluetoothDevice getDevice() {
        return this.device;
    }

    int getPreferredPhy() {
        return this.preferredPhy;
    }

    boolean canRetry() {
        if (this.retries > 0) {
            --this.retries;
            return true;
        }
        return false;
    }

    boolean isFirstAttempt() {
        return this.attempt++ == 0;
    }

    @IntRange(from=0L)
    int getRetryDelay() {
        return this.delay;
    }

    boolean shouldAutoConnect() {
        return this.autoConnect;
    }
}

