/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.ReadProgressCallback;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.data.DataFilter;
import no.nordicsemi.android.ble.data.DataMerger;
import no.nordicsemi.android.ble.data.DataStream;

public class ValueChangedCallback {
    private ReadProgressCallback progressCallback;
    private DataReceivedCallback valueCallback;
    private DataMerger dataMerger;
    private DataStream buffer;
    private DataFilter filter;
    private final Handler handler;
    private int count = 0;

    ValueChangedCallback(Handler handler) {
        this.handler = handler;
    }

    @NonNull
    public ValueChangedCallback with(@NonNull DataReceivedCallback callback) {
        this.valueCallback = callback;
        return this;
    }

    @NonNull
    public ValueChangedCallback filter(@NonNull DataFilter filter) {
        this.filter = filter;
        return this;
    }

    @NonNull
    public ValueChangedCallback merge(@NonNull DataMerger merger) {
        this.dataMerger = merger;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public ValueChangedCallback merge(@NonNull DataMerger merger, @NonNull ReadProgressCallback callback) {
        this.dataMerger = merger;
        this.progressCallback = callback;
        return this;
    }

    ValueChangedCallback free() {
        this.valueCallback = null;
        this.dataMerger = null;
        this.progressCallback = null;
        this.buffer = null;
        return this;
    }

    boolean matches(byte[] packet) {
        return this.filter == null || this.filter.filter(packet);
    }

    void notifyValueChanged(@NonNull BluetoothDevice device, @Nullable byte[] value) {
        DataReceivedCallback valueCallback = this.valueCallback;
        if (valueCallback == null) {
            return;
        }
        if (this.dataMerger == null) {
            Data data = new Data(value);
            this.handler.post(() -> valueCallback.onDataReceived(device, data));
        } else {
            this.handler.post(() -> {
                if (this.progressCallback != null) {
                    this.progressCallback.onPacketReceived(device, value, this.count);
                }
            });
            if (this.buffer == null) {
                this.buffer = new DataStream();
            }
            if (this.dataMerger.merge(this.buffer, value, this.count++)) {
                Data data = this.buffer.toData();
                this.handler.post(() -> valueCallback.onDataReceived(device, data));
                this.buffer = null;
                this.count = 0;
            }
        }
    }
}

