/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.ble.AwaitingRequest;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.ReadProgressCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.callback.profile.ProfileReadResponse;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.data.DataFilter;
import no.nordicsemi.android.ble.data.DataMerger;
import no.nordicsemi.android.ble.data.DataStream;
import no.nordicsemi.android.ble.exception.BluetoothDisabledException;
import no.nordicsemi.android.ble.exception.DeviceDisconnectedException;
import no.nordicsemi.android.ble.exception.InvalidDataException;
import no.nordicsemi.android.ble.exception.InvalidRequestException;
import no.nordicsemi.android.ble.exception.RequestFailedException;

public final class WaitForValueChangedRequest
extends AwaitingRequest<DataReceivedCallback> {
    private ReadProgressCallback progressCallback;
    private DataMerger dataMerger;
    private DataStream buffer;
    private DataFilter filter;
    private boolean deviceDisconnected;
    private boolean bluetoothDisabled;
    private int count = 0;

    WaitForValueChangedRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    WaitForValueChangedRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    WaitForValueChangedRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest timeout(@IntRange(from=0L) long timeout) {
        super.timeout(timeout);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest with(@NonNull DataReceivedCallback callback) {
        super.with(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest trigger(@NonNull Operation trigger) {
        super.trigger(trigger);
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest filter(@NonNull DataFilter filter) {
        this.filter = filter;
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest merge(@NonNull DataMerger merger) {
        this.dataMerger = merger;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest merge(@NonNull DataMerger merger, @NonNull ReadProgressCallback callback) {
        this.dataMerger = merger;
        this.progressCallback = callback;
        return this;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull E response) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        E result = this.await(response);
        if (result != null && !result.isValid()) {
            throw new InvalidDataException(result);
        }
        return result;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull Class<E> responseClass) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        ProfileReadResponse response = (ProfileReadResponse)((Object)this.await(responseClass));
        if (response != null && !response.isValid()) {
            throw new InvalidDataException(response);
        }
        return (E)response;
    }

    @Deprecated
    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull Class<E> responseClass, @IntRange(from=0L) long timeout) throws InterruptedException, InvalidDataException, RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        return this.timeout(timeout).awaitValid(responseClass);
    }

    @Deprecated
    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull E response, @IntRange(from=0L) long timeout) throws InterruptedException, InvalidDataException, DeviceDisconnectedException, RequestFailedException, BluetoothDisabledException, InvalidRequestException {
        return this.timeout(timeout).awaitValid(response);
    }

    boolean matches(byte[] packet) {
        return this.filter == null || this.filter.filter(packet);
    }

    void notifyValueChanged(BluetoothDevice device, byte[] value) {
        DataReceivedCallback valueCallback = (DataReceivedCallback)this.valueCallback;
        if (valueCallback == null) {
            return;
        }
        if (this.dataMerger == null) {
            Data data = new Data(value);
            this.handler.post(() -> valueCallback.onDataReceived(device, data));
        } else {
            this.handler.post(() -> {
                if (this.progressCallback != null) {
                    this.progressCallback.onPacketReceived(device, value, this.count);
                }
            });
            if (this.buffer == null) {
                this.buffer = new DataStream();
            }
            if (this.dataMerger.merge(this.buffer, value, this.count++)) {
                Data data = this.buffer.toData();
                this.handler.post(() -> valueCallback.onDataReceived(device, data));
                this.buffer = null;
                this.count = 0;
            }
        }
    }

    boolean hasMore() {
        return this.count > 0;
    }
}

