/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import no.nordicsemi.android.ble.ConditionalWaitRequest;
import no.nordicsemi.android.ble.ConnectRequest;
import no.nordicsemi.android.ble.ConnectionPriorityRequest;
import no.nordicsemi.android.ble.DisconnectRequest;
import no.nordicsemi.android.ble.MtuRequest;
import no.nordicsemi.android.ble.PhyRequest;
import no.nordicsemi.android.ble.ReadRequest;
import no.nordicsemi.android.ble.ReadRssiRequest;
import no.nordicsemi.android.ble.ReliableWriteRequest;
import no.nordicsemi.android.ble.RequestHandler;
import no.nordicsemi.android.ble.SetValueRequest;
import no.nordicsemi.android.ble.SimpleRequest;
import no.nordicsemi.android.ble.SleepRequest;
import no.nordicsemi.android.ble.WaitForReadRequest;
import no.nordicsemi.android.ble.WaitForValueChangedRequest;
import no.nordicsemi.android.ble.WriteRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public abstract class Request {
    protected RequestHandler requestHandler;
    protected Handler handler;
    final ConditionVariable syncLock;
    final Type type;
    final BluetoothGattCharacteristic characteristic;
    final BluetoothGattDescriptor descriptor;
    BeforeCallback beforeCallback;
    SuccessCallback successCallback;
    FailCallback failCallback;
    InvalidRequestCallback invalidRequestCallback;
    BeforeCallback internalBeforeCallback;
    SuccessCallback internalSuccessCallback;
    FailCallback internalFailCallback;
    boolean enqueued;
    boolean started;
    boolean finished;

    Request(@NonNull Type type) {
        this.type = type;
        this.characteristic = null;
        this.descriptor = null;
        this.syncLock = new ConditionVariable(true);
    }

    Request(@NonNull Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        this.type = type;
        this.characteristic = characteristic;
        this.descriptor = null;
        this.syncLock = new ConditionVariable(true);
    }

    Request(@NonNull Type type, @Nullable BluetoothGattDescriptor descriptor) {
        this.type = type;
        this.characteristic = null;
        this.descriptor = descriptor;
        this.syncLock = new ConditionVariable(true);
    }

    @NonNull
    Request setRequestHandler(@NonNull RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
        if (this.handler == null) {
            this.handler = requestHandler.getHandler();
        }
        return this;
    }

    @NonNull
    public Request setHandler(@NonNull Handler handler) {
        this.handler = handler;
        return this;
    }

    @NonNull
    static ConnectRequest connect(@NonNull BluetoothDevice device) {
        return new ConnectRequest(Type.CONNECT, device);
    }

    @NonNull
    static DisconnectRequest disconnect() {
        return new DisconnectRequest(Type.DISCONNECT);
    }

    @Deprecated
    @NonNull
    public static SimpleRequest createBond() {
        return new SimpleRequest(Type.CREATE_BOND);
    }

    @Deprecated
    @NonNull
    public static SimpleRequest removeBond() {
        return new SimpleRequest(Type.REMOVE_BOND);
    }

    @Deprecated
    @NonNull
    public static ReadRequest newReadRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new ReadRequest(Type.READ, characteristic);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newWriteRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value) {
        return new WriteRequest(Type.WRITE, characteristic, value, 0, value != null ? value.length : 0, characteristic != null ? characteristic.getWriteType() : 2);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newWriteRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, int writeType) {
        return new WriteRequest(Type.WRITE, characteristic, value, 0, value != null ? value.length : 0, writeType);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newWriteRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new WriteRequest(Type.WRITE, characteristic, value, offset, length, characteristic != null ? characteristic.getWriteType() : 2);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newWriteRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length, int writeType) {
        return new WriteRequest(Type.WRITE, characteristic, value, offset, length, writeType);
    }

    @Deprecated
    @NonNull
    public static ReadRequest newReadRequest(@Nullable BluetoothGattDescriptor descriptor) {
        return new ReadRequest(Type.READ_DESCRIPTOR, descriptor);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newWriteRequest(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] value) {
        return new WriteRequest(Type.WRITE_DESCRIPTOR, descriptor, value, 0, value != null ? value.length : 0);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newWriteRequest(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new WriteRequest(Type.WRITE_DESCRIPTOR, descriptor, value, offset, length);
    }

    @NonNull
    static ReliableWriteRequest newReliableWriteRequest() {
        return new ReliableWriteRequest();
    }

    @NonNull
    static SimpleRequest newBeginReliableWriteRequest() {
        return new SimpleRequest(Type.BEGIN_RELIABLE_WRITE);
    }

    @NonNull
    static SimpleRequest newExecuteReliableWriteRequest() {
        return new SimpleRequest(Type.EXECUTE_RELIABLE_WRITE);
    }

    @NonNull
    static SimpleRequest newAbortReliableWriteRequest() {
        return new SimpleRequest(Type.ABORT_RELIABLE_WRITE);
    }

    @NonNull
    static WriteRequest newNotificationRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value) {
        return new WriteRequest(Type.NOTIFY, characteristic, value, 0, value != null ? value.length : 0);
    }

    @NonNull
    static WriteRequest newNotificationRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new WriteRequest(Type.NOTIFY, characteristic, value, offset, length);
    }

    @NonNull
    static WriteRequest newIndicationRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value) {
        return new WriteRequest(Type.INDICATE, characteristic, value, 0, value != null ? value.length : 0);
    }

    @NonNull
    static WriteRequest newIndicationRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new WriteRequest(Type.INDICATE, characteristic, value, offset, length);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newEnableNotificationsRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WriteRequest(Type.ENABLE_NOTIFICATIONS, characteristic);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newDisableNotificationsRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WriteRequest(Type.DISABLE_NOTIFICATIONS, characteristic);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newEnableIndicationsRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WriteRequest(Type.ENABLE_INDICATIONS, characteristic);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newDisableIndicationsRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WriteRequest(Type.DISABLE_INDICATIONS, characteristic);
    }

    @Deprecated
    @NonNull
    public static WaitForValueChangedRequest newWaitForNotificationRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WaitForValueChangedRequest(Type.WAIT_FOR_NOTIFICATION, characteristic);
    }

    @Deprecated
    @NonNull
    public static WaitForValueChangedRequest newWaitForIndicationRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WaitForValueChangedRequest(Type.WAIT_FOR_INDICATION, characteristic);
    }

    @NonNull
    static WaitForValueChangedRequest newWaitForWriteRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WaitForValueChangedRequest(Type.WAIT_FOR_WRITE, characteristic);
    }

    @NonNull
    static WaitForValueChangedRequest newWaitForWriteRequest(@Nullable BluetoothGattDescriptor descriptor) {
        return new WaitForValueChangedRequest(Type.WAIT_FOR_WRITE, descriptor);
    }

    @NonNull
    static WaitForReadRequest newWaitForReadRequest(@Nullable BluetoothGattCharacteristic characteristic) {
        return new WaitForReadRequest(Type.WAIT_FOR_READ, characteristic);
    }

    @NonNull
    static WaitForReadRequest newWaitForReadRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value) {
        return new WaitForReadRequest(Type.WAIT_FOR_READ, characteristic, value, 0, value != null ? value.length : 0);
    }

    @NonNull
    static WaitForReadRequest newWaitForReadRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new WaitForReadRequest(Type.WAIT_FOR_READ, characteristic, value, offset, length);
    }

    @NonNull
    static WaitForReadRequest newWaitForReadRequest(@Nullable BluetoothGattDescriptor descriptor) {
        return new WaitForReadRequest(Type.WAIT_FOR_READ, descriptor);
    }

    @NonNull
    static WaitForReadRequest newWaitForReadRequest(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] value) {
        return new WaitForReadRequest(Type.WAIT_FOR_READ, descriptor, value, 0, value != null ? value.length : 0);
    }

    @NonNull
    static WaitForReadRequest newWaitForReadRequest(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new WaitForReadRequest(Type.WAIT_FOR_READ, descriptor, value, offset, length);
    }

    @NonNull
    static <T> ConditionalWaitRequest<T> newConditionalWaitRequest(@NonNull ConditionalWaitRequest.Condition<T> condition, @Nullable T parameter) {
        return new ConditionalWaitRequest<T>(Type.WAIT_FOR_CONDITION, condition, parameter);
    }

    @NonNull
    static SetValueRequest newSetValueRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value) {
        return new SetValueRequest(Type.SET_VALUE, characteristic, value, 0, value != null ? value.length : 0);
    }

    @NonNull
    static SetValueRequest newSetValueRequest(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new SetValueRequest(Type.SET_VALUE, characteristic, value, offset, length);
    }

    @NonNull
    static SetValueRequest newSetValueRequest(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] value) {
        return new SetValueRequest(Type.SET_DESCRIPTOR_VALUE, descriptor, value, 0, value != null ? value.length : 0);
    }

    @NonNull
    static SetValueRequest newSetValueRequest(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        return new SetValueRequest(Type.SET_DESCRIPTOR_VALUE, descriptor, value, offset, length);
    }

    @Deprecated
    @NonNull
    public static ReadRequest newReadBatteryLevelRequest() {
        return new ReadRequest(Type.READ_BATTERY_LEVEL);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newEnableBatteryLevelNotificationsRequest() {
        return new WriteRequest(Type.ENABLE_BATTERY_LEVEL_NOTIFICATIONS);
    }

    @Deprecated
    @NonNull
    public static WriteRequest newDisableBatteryLevelNotificationsRequest() {
        return new WriteRequest(Type.DISABLE_BATTERY_LEVEL_NOTIFICATIONS);
    }

    @NonNull
    static WriteRequest newEnableServiceChangedIndicationsRequest() {
        return new WriteRequest(Type.ENABLE_SERVICE_CHANGED_INDICATIONS);
    }

    @Deprecated
    @NonNull
    public static MtuRequest newMtuRequest(@IntRange(from=23L, to=517L) int mtu) {
        return new MtuRequest(Type.REQUEST_MTU, mtu);
    }

    @Deprecated
    @NonNull
    public static ConnectionPriorityRequest newConnectionPriorityRequest(int priority) {
        return new ConnectionPriorityRequest(Type.REQUEST_CONNECTION_PRIORITY, priority);
    }

    @Deprecated
    @NonNull
    public static PhyRequest newSetPreferredPhyRequest(int txPhy, int rxPhy, int phyOptions) {
        return new PhyRequest(Type.SET_PREFERRED_PHY, txPhy, rxPhy, phyOptions);
    }

    @Deprecated
    @NonNull
    public static PhyRequest newReadPhyRequest() {
        return new PhyRequest(Type.READ_PHY);
    }

    @Deprecated
    @NonNull
    public static ReadRssiRequest newReadRssiRequest() {
        return new ReadRssiRequest(Type.READ_RSSI);
    }

    @Deprecated
    @NonNull
    public static SimpleRequest newRefreshCacheRequest() {
        return new SimpleRequest(Type.REFRESH_CACHE);
    }

    @Deprecated
    @NonNull
    public static SleepRequest newSleepRequest(@IntRange(from=0L) long delay) {
        return new SleepRequest(Type.SLEEP, delay);
    }

    @NonNull
    public Request done(@NonNull SuccessCallback callback) {
        this.successCallback = callback;
        return this;
    }

    @NonNull
    public Request fail(@NonNull FailCallback callback) {
        this.failCallback = callback;
        return this;
    }

    void internalBefore(@NonNull BeforeCallback callback) {
        this.internalBeforeCallback = callback;
    }

    void internalSuccess(@NonNull SuccessCallback callback) {
        this.internalSuccessCallback = callback;
    }

    void internalFail(@NonNull FailCallback callback) {
        this.internalFailCallback = callback;
    }

    @NonNull
    public Request invalid(@NonNull InvalidRequestCallback callback) {
        this.invalidRequestCallback = callback;
        return this;
    }

    @NonNull
    public Request before(@NonNull BeforeCallback callback) {
        this.beforeCallback = callback;
        return this;
    }

    public void enqueue() {
        this.requestHandler.enqueue(this);
    }

    void notifyStarted(@NonNull BluetoothDevice device) {
        if (!this.started) {
            this.started = true;
            this.handler.post(() -> {
                if (this.beforeCallback != null) {
                    this.beforeCallback.onRequestStarted(device);
                }
                if (this.internalBeforeCallback != null) {
                    this.internalBeforeCallback.onRequestStarted(device);
                }
            });
        }
    }

    void notifySuccess(@NonNull BluetoothDevice device) {
        if (!this.finished) {
            this.finished = true;
            this.handler.post(() -> {
                if (this.successCallback != null) {
                    this.successCallback.onRequestCompleted(device);
                }
                if (this.internalSuccessCallback != null) {
                    this.internalSuccessCallback.onRequestCompleted(device);
                }
            });
        }
    }

    void notifyFail(@NonNull BluetoothDevice device, int status) {
        if (!this.finished) {
            this.finished = true;
            this.handler.post(() -> {
                if (this.failCallback != null) {
                    this.failCallback.onRequestFailed(device, status);
                }
                if (this.internalFailCallback != null) {
                    this.internalFailCallback.onRequestFailed(device, status);
                }
            });
        }
    }

    void notifyInvalidRequest() {
        if (!this.finished) {
            this.finished = true;
            this.handler.post(() -> {
                if (this.invalidRequestCallback != null) {
                    this.invalidRequestCallback.onInvalidRequest();
                }
            });
        }
    }

    static void assertNotMainThread() throws IllegalStateException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot execute synchronous operation from the UI thread.");
        }
    }

    final class RequestCallback
    implements SuccessCallback,
    FailCallback,
    InvalidRequestCallback {
        static final int REASON_REQUEST_INVALID = -1000000;
        int status = 0;

        RequestCallback() {
        }

        @Override
        public void onRequestCompleted(@NonNull BluetoothDevice device) {
            Request.this.syncLock.open();
        }

        @Override
        public void onRequestFailed(@NonNull BluetoothDevice device, int status) {
            this.status = status;
            Request.this.syncLock.open();
        }

        @Override
        public void onInvalidRequest() {
            this.status = -1000000;
            Request.this.syncLock.open();
        }

        boolean isSuccess() {
            return this.status == 0;
        }
    }

    static enum Type {
        SET,
        CONNECT,
        DISCONNECT,
        CREATE_BOND,
        REMOVE_BOND,
        WRITE,
        NOTIFY,
        INDICATE,
        READ,
        WRITE_DESCRIPTOR,
        READ_DESCRIPTOR,
        BEGIN_RELIABLE_WRITE,
        EXECUTE_RELIABLE_WRITE,
        ABORT_RELIABLE_WRITE,
        ENABLE_NOTIFICATIONS,
        ENABLE_INDICATIONS,
        DISABLE_NOTIFICATIONS,
        DISABLE_INDICATIONS,
        WAIT_FOR_NOTIFICATION,
        WAIT_FOR_INDICATION,
        WAIT_FOR_READ,
        WAIT_FOR_WRITE,
        WAIT_FOR_CONDITION,
        SET_VALUE,
        SET_DESCRIPTOR_VALUE,
        READ_BATTERY_LEVEL,
        ENABLE_BATTERY_LEVEL_NOTIFICATIONS,
        DISABLE_BATTERY_LEVEL_NOTIFICATIONS,
        ENABLE_SERVICE_CHANGED_INDICATIONS,
        REQUEST_MTU,
        REQUEST_CONNECTION_PRIORITY,
        SET_PREFERRED_PHY,
        READ_PHY,
        READ_RSSI,
        REFRESH_CACHE,
        SLEEP;

    }
}

