/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble.error;

public class GattError {
    public static final int GATT_SUCCESS = 0;
    public static final int GATT_CONN_L2C_FAILURE = 1;
    public static final int GATT_CONN_TIMEOUT = 8;
    public static final int GATT_CONN_TERMINATE_PEER_USER = 19;
    public static final int GATT_CONN_TERMINATE_LOCAL_HOST = 22;
    public static final int GATT_CONN_FAIL_ESTABLISH = 62;
    public static final int GATT_CONN_LMP_TIMEOUT = 34;
    public static final int GATT_CONN_CANCEL = 256;
    public static final int GATT_ERROR = 133;
    public static final int GATT_INVALID_HANDLE = 1;
    public static final int GATT_READ_NOT_PERMIT = 2;
    public static final int GATT_WRITE_NOT_PERMIT = 3;
    public static final int GATT_INVALID_PDU = 4;
    public static final int GATT_INSUF_AUTHENTICATION = 5;
    public static final int GATT_REQ_NOT_SUPPORTED = 6;
    public static final int GATT_INVALID_OFFSET = 7;
    public static final int GATT_INSUF_AUTHORIZATION = 8;
    public static final int GATT_PREPARE_Q_FULL = 9;
    public static final int GATT_NOT_FOUND = 10;
    public static final int GATT_NOT_LONG = 11;
    public static final int GATT_INSUF_KEY_SIZE = 12;
    public static final int GATT_INVALID_ATTR_LEN = 13;
    public static final int GATT_ERR_UNLIKELY = 14;
    public static final int GATT_INSUF_ENCRYPTION = 15;
    public static final int GATT_UNSUPPORT_GRP_TYPE = 16;
    public static final int GATT_INSUF_RESOURCE = 17;
    public static final int GATT_PAIRING_WITH_UNIT_KEY_NOT_SUPPORTED = 41;
    public static final int GATT_CONTROLLER_BUSY = 58;
    public static final int GATT_UNACCEPT_CONN_INTERVAL = 59;
    public static final int GATT_ILLEGAL_PARAMETER = 135;
    public static final int GATT_NO_RESOURCES = 128;
    public static final int GATT_INTERNAL_ERROR = 129;
    public static final int GATT_WRONG_STATE = 130;
    public static final int GATT_DB_FULL = 131;
    public static final int GATT_BUSY = 132;
    public static final int GATT_CMD_STARTED = 134;
    public static final int GATT_PENDING = 136;
    public static final int GATT_AUTH_FAIL = 137;
    public static final int GATT_MORE = 138;
    public static final int GATT_INVALID_CFG = 139;
    public static final int GATT_SERVICE_STARTED = 140;
    public static final int GATT_ENCRYPTED_NO_MITM = 141;
    public static final int GATT_NOT_ENCRYPTED = 142;
    public static final int GATT_CONGESTED = 143;
    public static final int GATT_TIMEOUT = 147;
    public static final int GATT_CCCD_CFG_ERROR = 253;
    public static final int GATT_PROCEDURE_IN_PROGRESS = 254;
    public static final int GATT_VALUE_OUT_OF_RANGE = 255;
    public static final int TOO_MANY_OPEN_CONNECTIONS = 257;

    public static String parseConnectionError(int error) {
        return switch (error) {
            case 0 -> "SUCCESS";
            case 1 -> "GATT CONN L2C FAILURE";
            case 5 -> "GATT INSUF AUTHENTICATION";
            case 8 -> "GATT CONN TIMEOUT";
            case 19 -> "GATT CONN TERMINATE PEER USER";
            case 22 -> "GATT CONN TERMINATE LOCAL HOST";
            case 62 -> "GATT CONN FAIL ESTABLISH";
            case 34 -> "GATT CONN LMP TIMEOUT";
            case 256 -> "GATT CONN CANCEL ";
            case 133 -> "GATT ERROR";
            case 147 -> "GATT TIMEOUT";
            case 41 -> "GATT PAIRING WITH UNIT KEY NOT SUPPORTED";
            default -> "UNKNOWN (" + error + ")";
        };
    }

    public static String parse(int error) {
        return switch (error) {
            case 1 -> "GATT INVALID HANDLE";
            case 2 -> "GATT READ NOT PERMIT";
            case 3 -> "GATT WRITE NOT PERMIT";
            case 4 -> "GATT INVALID PDU";
            case 5 -> "GATT INSUF AUTHENTICATION";
            case 6 -> "GATT REQ NOT SUPPORTED";
            case 7 -> "GATT INVALID OFFSET";
            case 8 -> "GATT INSUF AUTHORIZATION";
            case 9 -> "GATT PREPARE Q FULL";
            case 10 -> "GATT NOT FOUND";
            case 11 -> "GATT NOT LONG";
            case 12 -> "GATT INSUF KEY SIZE";
            case 13 -> "GATT INVALID ATTR LEN";
            case 14 -> "GATT ERR UNLIKELY";
            case 15 -> "GATT INSUF ENCRYPTION";
            case 16 -> "GATT UNSUPPORT GRP TYPE";
            case 17 -> "GATT INSUF RESOURCE";
            case 41 -> "GATT PAIRING WITH UNIT KEY NOT SUPPORTED";
            case 34 -> "GATT CONN LMP TIMEOUT";
            case 58 -> "GATT CONTROLLER BUSY";
            case 59 -> "GATT UNACCEPT CONN INTERVAL";
            case 135 -> "GATT ILLEGAL PARAMETER";
            case 128 -> "GATT NO RESOURCES";
            case 129 -> "GATT INTERNAL ERROR";
            case 130 -> "GATT WRONG STATE";
            case 131 -> "GATT DB FULL";
            case 132 -> "GATT BUSY";
            case 133 -> "GATT ERROR";
            case 134 -> "GATT CMD STARTED";
            case 136 -> "GATT PENDING";
            case 137 -> "GATT AUTH FAIL";
            case 138 -> "GATT MORE";
            case 139 -> "GATT INVALID CFG";
            case 140 -> "GATT SERVICE STARTED";
            case 141 -> "GATT ENCRYPTED NO MITM";
            case 142 -> "GATT NOT ENCRYPTED";
            case 143 -> "GATT CONGESTED";
            case 147 -> "GATT TIMEOUT";
            case 253 -> "GATT CCCD CFG ERROR";
            case 254 -> "GATT PROCEDURE IN PROGRESS";
            case 255 -> "GATT VALUE OUT OF RANGE";
            case 257 -> "TOO MANY OPEN CONNECTIONS";
            default -> "UNKNOWN (" + error + ")";
        };
    }
}

