/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble.data;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import no.nordicsemi.android.ble.data.Data;

public class DataStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public boolean write(@Nullable byte[] data) {
        if (data == null) {
            return false;
        }
        return this.write(data, 0, data.length);
    }

    public boolean write(@Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        if (data == null || data.length < offset) {
            return false;
        }
        int len = Math.min(data.length - offset, length);
        this.buffer.write(data, offset, len);
        return true;
    }

    public boolean write(@Nullable Data data) {
        return data != null && this.write(data.getValue());
    }

    @IntRange(from=0L)
    public int size() {
        return this.buffer.size();
    }

    @NonNull
    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    @NonNull
    public Data toData() {
        return new Data(this.buffer.toByteArray());
    }
}

