/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import androidx.annotation.NonNull;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestQueue;
import no.nordicsemi.android.ble.WriteRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;

public final class ReliableWriteRequest
extends RequestQueue {
    private boolean initialized;
    private boolean closed;
    private boolean cancelled;

    @Override
    @NonNull
    ReliableWriteRequest setManager(@NonNull BleManager manager) {
        super.setManager(manager);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest add(@NonNull Operation operation) {
        super.add(operation);
        if (operation instanceof WriteRequest) {
            ((WriteRequest)operation).forceSplit();
        }
        return this;
    }

    @Override
    public void cancelQueue() {
        this.cancelled = true;
        super.cancelQueue();
    }

    public void abort() {
        this.cancelQueue();
    }

    @Override
    public int size() {
        int size = super.size();
        if (!this.initialized) {
            ++size;
        }
        if (!this.closed) {
            ++size;
        }
        return size;
    }

    @Override
    Request getNext() {
        if (!this.initialized) {
            this.initialized = true;
            return ReliableWriteRequest.newBeginReliableWriteRequest();
        }
        if (super.isEmpty()) {
            this.closed = true;
            if (this.cancelled) {
                return ReliableWriteRequest.newAbortReliableWriteRequest();
            }
            return ReliableWriteRequest.newExecuteReliableWriteRequest();
        }
        return super.getNext();
    }

    @Override
    boolean hasMore() {
        if (!this.initialized) {
            return super.hasMore();
        }
        return !this.closed;
    }
}

