/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

abstract class MainThreadBluetoothGattCallback
extends BluetoothGattCallback {
    private Handler mHandler;

    MainThreadBluetoothGattCallback() {
    }

    void setHandler(@NonNull Handler handler) {
        this.mHandler = handler;
    }

    private void runOnUiThread(@NonNull Runnable runnable) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    abstract void onConnectionStateChangeSafe(@NonNull BluetoothGatt var1, int var2, int var3);

    abstract void onServicesDiscoveredSafe(@NonNull BluetoothGatt var1, int var2);

    abstract void onCharacteristicReadSafe(@NonNull BluetoothGatt var1, @NonNull BluetoothGattCharacteristic var2, @Nullable byte[] var3, int var4);

    abstract void onCharacteristicWriteSafe(@NonNull BluetoothGatt var1, @NonNull BluetoothGattCharacteristic var2, @Nullable byte[] var3, int var4);

    abstract void onCharacteristicChangedSafe(@NonNull BluetoothGatt var1, @NonNull BluetoothGattCharacteristic var2, @Nullable byte[] var3);

    abstract void onDescriptorReadSafe(@NonNull BluetoothGatt var1, @NonNull BluetoothGattDescriptor var2, @Nullable byte[] var3, int var4);

    abstract void onDescriptorWriteSafe(@NonNull BluetoothGatt var1, @NonNull BluetoothGattDescriptor var2, @Nullable byte[] var3, int var4);

    abstract void onReadRemoteRssiSafe(@NonNull BluetoothGatt var1, @IntRange(from=-128L, to=20L) int var2, int var3);

    abstract void onReliableWriteCompletedSafe(@NonNull BluetoothGatt var1, int var2);

    @RequiresApi(api=21)
    abstract void onMtuChangedSafe(@NonNull BluetoothGatt var1, @IntRange(from=23L, to=517L) int var2, int var3);

    @RequiresApi(api=26)
    abstract void onPhyReadSafe(@NonNull BluetoothGatt var1, int var2, int var3, int var4);

    @RequiresApi(api=26)
    abstract void onPhyUpdateSafe(@NonNull BluetoothGatt var1, int var2, int var3, int var4);

    @RequiresApi(api=26)
    abstract void onConnectionUpdatedSafe(@NonNull BluetoothGatt var1, @IntRange(from=6L, to=3200L) int var2, @IntRange(from=0L, to=499L) int var3, @IntRange(from=10L, to=3200L) int var4, int var5);

    public final void onConnectionStateChange(@NonNull BluetoothGatt gatt, int status, int newState) {
        this.runOnUiThread(() -> this.onConnectionStateChangeSafe(gatt, status, newState));
    }

    public final void onServicesDiscovered(@NonNull BluetoothGatt gatt, int status) {
        this.runOnUiThread(() -> this.onServicesDiscoveredSafe(gatt, status));
    }

    public final void onCharacteristicRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, int status) {
        byte[] data = characteristic.getValue();
        this.runOnUiThread(() -> this.onCharacteristicReadSafe(gatt, characteristic, data, status));
    }

    public final void onCharacteristicWrite(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, int status) {
        byte[] data = characteristic.getValue();
        this.runOnUiThread(() -> this.onCharacteristicWriteSafe(gatt, characteristic, data, status));
    }

    public final void onCharacteristicChanged(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
        byte[] data = characteristic.getValue();
        this.runOnUiThread(() -> this.onCharacteristicChangedSafe(gatt, characteristic, data));
    }

    public final void onDescriptorRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor, int status) {
        byte[] data = descriptor.getValue();
        this.runOnUiThread(() -> this.onDescriptorReadSafe(gatt, descriptor, data, status));
    }

    public final void onDescriptorWrite(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor, int status) {
        byte[] data = descriptor.getValue();
        this.runOnUiThread(() -> this.onDescriptorWriteSafe(gatt, descriptor, data, status));
    }

    public final void onReadRemoteRssi(@NonNull BluetoothGatt gatt, @IntRange(from=-128L, to=20L) int rssi, int status) {
        this.runOnUiThread(() -> this.onReadRemoteRssiSafe(gatt, rssi, status));
    }

    public final void onReliableWriteCompleted(@NonNull BluetoothGatt gatt, int status) {
        this.runOnUiThread(() -> this.onReliableWriteCompletedSafe(gatt, status));
    }

    @RequiresApi(api=21)
    public final void onMtuChanged(@NonNull BluetoothGatt gatt, @IntRange(from=23L, to=517L) int mtu, int status) {
        this.runOnUiThread(() -> this.onMtuChangedSafe(gatt, mtu, status));
    }

    @RequiresApi(api=26)
    public final void onPhyRead(@NonNull BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
        this.runOnUiThread(() -> this.onPhyReadSafe(gatt, txPhy, rxPhy, status));
    }

    @RequiresApi(api=26)
    public final void onPhyUpdate(@NonNull BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
        this.runOnUiThread(() -> this.onPhyUpdateSafe(gatt, txPhy, rxPhy, status));
    }

    @RequiresApi(api=26)
    @Keep
    public final void onConnectionUpdated(@NonNull BluetoothGatt gatt, @IntRange(from=6L, to=3200L) int interval, @IntRange(from=0L, to=499L) int latency, @IntRange(from=10L, to=3200L) int timeout, int status) {
        this.runOnUiThread(() -> this.onConnectionUpdatedSafe(gatt, interval, latency, timeout, status));
    }
}

