/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble.utils;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;

public class ParserUtils {
    protected static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String parse(BluetoothGattCharacteristic characteristic) {
        return ParserUtils.parse(characteristic.getValue());
    }

    public static String parse(BluetoothGattDescriptor descriptor) {
        return ParserUtils.parse(descriptor.getValue());
    }

    public static String parse(byte[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        char[] out = new char[data.length * 3 - 1];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            out[j * 3] = HEX_ARRAY[v >>> 4];
            out[j * 3 + 1] = HEX_ARRAY[v & 0xF];
            if (j == data.length - 1) continue;
            out[j * 3 + 2] = 45;
        }
        return "(0x) " + new String(out);
    }
}

