/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.SimpleValueRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.ReadProgressCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.callback.profile.ProfileReadResponse;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.data.DataMerger;
import no.nordicsemi.android.ble.data.DataStream;
import no.nordicsemi.android.ble.exception.BluetoothDisabledException;
import no.nordicsemi.android.ble.exception.DeviceDisconnectedException;
import no.nordicsemi.android.ble.exception.InvalidDataException;
import no.nordicsemi.android.ble.exception.InvalidRequestException;
import no.nordicsemi.android.ble.exception.RequestFailedException;

public final class ReadRequest
extends SimpleValueRequest<DataReceivedCallback>
implements Operation {
    private ReadProgressCallback progressCallback;
    private DataMerger dataMerger;
    private DataStream buffer;
    private int count = 0;

    ReadRequest(@NonNull Request.Type type) {
        super(type);
    }

    ReadRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    ReadRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    ReadRequest setManager(@NonNull BleManager manager) {
        super.setManager(manager);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public ReadRequest with(@NonNull DataReceivedCallback callback) {
        super.with(callback);
        return this;
    }

    @NonNull
    public ReadRequest merge(@NonNull DataMerger merger) {
        this.dataMerger = merger;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public ReadRequest merge(@NonNull DataMerger merger, @NonNull ReadProgressCallback callback) {
        this.dataMerger = merger;
        this.progressCallback = callback;
        return this;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull Class<E> responseClass) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        ProfileReadResponse response = (ProfileReadResponse)this.await(responseClass);
        if (!response.isValid()) {
            throw new InvalidDataException(response);
        }
        return (E)response;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull E response) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        this.await(response);
        if (!response.isValid()) {
            throw new InvalidDataException(response);
        }
        return response;
    }

    void notifyValueChanged(@NonNull BluetoothDevice device, @Nullable byte[] value) {
        DataReceivedCallback valueCallback = (DataReceivedCallback)this.valueCallback;
        if (valueCallback == null) {
            return;
        }
        if (this.dataMerger == null) {
            valueCallback.onDataReceived(device, new Data(value));
        } else {
            if (this.progressCallback != null) {
                this.progressCallback.onPacketReceived(device, value, this.count);
            }
            if (this.buffer == null) {
                this.buffer = new DataStream();
            }
            if (this.dataMerger.merge(this.buffer, value, this.count++)) {
                valueCallback.onDataReceived(device, this.buffer.toData());
                this.buffer = null;
                this.count = 0;
            }
        }
    }

    boolean hasMore() {
        return this.count > 0;
    }
}

