/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Arrays;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.Operation;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.SimpleValueRequest;
import no.nordicsemi.android.ble.callback.BeforeCallback;
import no.nordicsemi.android.ble.callback.DataSentCallback;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.InvalidRequestCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.callback.WriteProgressCallback;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.data.DataSplitter;
import no.nordicsemi.android.ble.data.DefaultMtuSplitter;

public final class WriteRequest
extends SimpleValueRequest<DataSentCallback>
implements Operation {
    private static final DataSplitter MTU_SPLITTER = new DefaultMtuSplitter();
    private WriteProgressCallback progressCallback;
    private DataSplitter dataSplitter;
    private final byte[] data;
    private final int writeType;
    private byte[] currentChunk;
    private byte[] nextChunk;
    private int count = 0;
    private boolean complete = false;

    WriteRequest(@NonNull Request.Type type) {
        this(type, (BluetoothGattCharacteristic)null);
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
        this.data = null;
        this.writeType = 0;
        this.complete = true;
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length, int writeType) {
        super(type, characteristic);
        this.data = WriteRequest.copy(data, offset, length);
        this.writeType = writeType;
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, descriptor);
        this.data = WriteRequest.copy(data, offset, length);
        this.writeType = 2;
    }

    @Override
    @NonNull
    WriteRequest setManager(@NonNull BleManager manager) {
        super.setManager(manager);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public WriteRequest with(@NonNull DataSentCallback callback) {
        super.with(callback);
        return this;
    }

    @NonNull
    public WriteRequest split(@NonNull DataSplitter splitter) {
        this.dataSplitter = splitter;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public WriteRequest split(@NonNull DataSplitter splitter, @NonNull WriteProgressCallback callback) {
        this.dataSplitter = splitter;
        this.progressCallback = callback;
        return this;
    }

    @NonNull
    public WriteRequest split() {
        this.dataSplitter = MTU_SPLITTER;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public WriteRequest split(@NonNull WriteProgressCallback callback) {
        this.dataSplitter = MTU_SPLITTER;
        this.progressCallback = callback;
        return this;
    }

    void forceSplit() {
        if (this.dataSplitter == null) {
            this.split();
        }
    }

    byte[] getData(@IntRange(from=23L, to=517L) int mtu) {
        if (this.dataSplitter == null || this.data == null) {
            this.complete = true;
            this.currentChunk = this.data;
            return this.data;
        }
        int maxLength = this.writeType != 4 ? mtu - 3 : mtu - 12;
        byte[] chunk = this.nextChunk;
        if (chunk == null) {
            chunk = this.dataSplitter.chunk(this.data, this.count, maxLength);
        }
        if (chunk != null) {
            this.nextChunk = this.dataSplitter.chunk(this.data, this.count + 1, maxLength);
        }
        if (this.nextChunk == null) {
            this.complete = true;
        }
        this.currentChunk = chunk;
        return chunk;
    }

    boolean notifyPacketSent(@NonNull BluetoothDevice device, @Nullable byte[] data) {
        if (this.progressCallback != null) {
            this.progressCallback.onPacketSent(device, data, this.count);
        }
        ++this.count;
        if (this.complete && this.valueCallback != null) {
            ((DataSentCallback)this.valueCallback).onDataSent(device, new Data(this.data));
        }
        return Arrays.equals(data, this.currentChunk);
    }

    boolean hasMore() {
        return !this.complete;
    }

    int getWriteType() {
        return this.writeType;
    }

    private static byte[] copy(@Nullable byte[] value, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        if (value == null || offset > value.length) {
            return null;
        }
        int maxLength = Math.min(value.length - offset, length);
        byte[] copy = new byte[maxLength];
        System.arraycopy(value, offset, copy, 0, maxLength);
        return copy;
    }
}

