/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import no.nordicsemi.android.ble.callback.DataReceivedCallback;
import no.nordicsemi.android.ble.callback.ReadProgressCallback;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.data.DataMerger;
import no.nordicsemi.android.ble.data.DataStream;

public class ValueChangedCallback {
    private ReadProgressCallback progressCallback;
    private DataReceivedCallback valueCallback;
    private DataMerger dataMerger;
    private DataStream buffer;
    private int count = 0;

    ValueChangedCallback() {
    }

    @NonNull
    public ValueChangedCallback with(@NonNull DataReceivedCallback callback) {
        this.valueCallback = callback;
        return this;
    }

    @NonNull
    public ValueChangedCallback merge(@NonNull DataMerger merger) {
        this.dataMerger = merger;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public ValueChangedCallback merge(@NonNull DataMerger merger, @NonNull ReadProgressCallback callback) {
        this.dataMerger = merger;
        this.progressCallback = callback;
        return this;
    }

    ValueChangedCallback free() {
        this.valueCallback = null;
        this.dataMerger = null;
        this.progressCallback = null;
        this.buffer = null;
        return this;
    }

    void notifyValueChanged(@NonNull BluetoothDevice device, @Nullable byte[] value) {
        DataReceivedCallback valueCallback = this.valueCallback;
        if (valueCallback == null) {
            return;
        }
        if (this.dataMerger == null) {
            valueCallback.onDataReceived(device, new Data(value));
        } else {
            if (this.progressCallback != null) {
                this.progressCallback.onPacketReceived(device, value, this.count);
            }
            if (this.buffer == null) {
                this.buffer = new DataStream();
            }
            if (this.dataMerger.merge(this.buffer, value, this.count++)) {
                valueCallback.onDataReceived(device, this.buffer.toData());
                this.buffer = null;
                this.count = 0;
            }
        }
    }
}

