/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.TimeoutHandler;
import no.nordicsemi.android.ble.callback.FailCallback;
import no.nordicsemi.android.ble.callback.SuccessCallback;
import no.nordicsemi.android.ble.exception.BluetoothDisabledException;
import no.nordicsemi.android.ble.exception.DeviceDisconnectedException;
import no.nordicsemi.android.ble.exception.InvalidRequestException;
import no.nordicsemi.android.ble.exception.RequestFailedException;

abstract class TimeoutableRequest
extends Request {
    private TimeoutHandler timeoutHandler;
    private Runnable timeoutCallback;
    private Handler handler;
    protected long timeout;

    TimeoutableRequest(@NonNull Request.Type type) {
        super(type);
    }

    TimeoutableRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    TimeoutableRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    TimeoutableRequest setManager(@NonNull BleManager manager) {
        super.setManager(manager);
        this.handler = manager.mHandler;
        this.timeoutHandler = manager;
        return this;
    }

    @NonNull
    public TimeoutableRequest timeout(@IntRange(from=0L) long timeout) {
        if (this.timeoutCallback != null) {
            throw new IllegalStateException("Request already started");
        }
        this.timeout = timeout;
        return this;
    }

    @Override
    public final void enqueue() {
        super.enqueue();
    }

    @Deprecated
    public final void enqueue(@IntRange(from=0L) long timeout) {
        this.timeout(timeout).enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await() throws RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        TimeoutableRequest.assertNotMainThread();
        SuccessCallback sc = this.successCallback;
        FailCallback fc = this.failCallback;
        try {
            this.syncLock.close();
            Request.RequestCallback callback = new Request.RequestCallback();
            this.done(callback).fail(callback).invalid(callback).enqueue();
            if (!this.syncLock.block(this.timeout)) {
                throw new InterruptedException();
            }
            if (!callback.isSuccess()) {
                if (callback.status == -1) {
                    throw new DeviceDisconnectedException();
                }
                if (callback.status == -100) {
                    throw new BluetoothDisabledException();
                }
                if (callback.status == -1000000) {
                    throw new InvalidRequestException(this);
                }
                throw new RequestFailedException(this, callback.status);
            }
        }
        finally {
            this.successCallback = sc;
            this.failCallback = fc;
        }
    }

    @Deprecated
    public final void await(@IntRange(from=0L) long timeout) throws RequestFailedException, InterruptedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        this.timeout(timeout).await();
    }

    @Override
    void notifyStarted(@NonNull BluetoothDevice device) {
        if (this.timeout > 0L) {
            this.timeoutCallback = () -> {
                this.timeoutCallback = null;
                if (!this.finished) {
                    this.notifyFail(device, -5);
                    this.timeoutHandler.onRequestTimeout(this);
                }
            };
            this.handler.postDelayed(this.timeoutCallback, this.timeout);
        }
        super.notifyStarted(device);
    }

    @Override
    void notifySuccess(@NonNull BluetoothDevice device) {
        if (!this.finished) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifySuccess(device);
    }

    @Override
    void notifyFail(@NonNull BluetoothDevice device, int status) {
        if (!this.finished) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifyFail(device, status);
    }

    @Override
    void notifyInvalidRequest() {
        if (!this.finished) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifyInvalidRequest();
    }
}

