/*
 * Decompiled with CFR 0.152.
 */
package no.nordicsemi.android.ble;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.IntRange;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import no.nordicsemi.android.ble.BleManagerCallbacks;
import no.nordicsemi.android.ble.ConnectRequest;
import no.nordicsemi.android.ble.ConnectionPriorityRequest;
import no.nordicsemi.android.ble.DisconnectRequest;
import no.nordicsemi.android.ble.MainThreadBluetoothGattCallback;
import no.nordicsemi.android.ble.MtuRequest;
import no.nordicsemi.android.ble.PhyRequest;
import no.nordicsemi.android.ble.ReadRequest;
import no.nordicsemi.android.ble.ReadRssiRequest;
import no.nordicsemi.android.ble.ReliableWriteRequest;
import no.nordicsemi.android.ble.Request;
import no.nordicsemi.android.ble.RequestQueue;
import no.nordicsemi.android.ble.SleepRequest;
import no.nordicsemi.android.ble.TimeoutHandler;
import no.nordicsemi.android.ble.TimeoutableRequest;
import no.nordicsemi.android.ble.ValueChangedCallback;
import no.nordicsemi.android.ble.WaitForValueChangedRequest;
import no.nordicsemi.android.ble.WriteRequest;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.ble.error.GattError;
import no.nordicsemi.android.ble.utils.ILogger;
import no.nordicsemi.android.ble.utils.ParserUtils;

public abstract class BleManager<E extends BleManagerCallbacks>
extends TimeoutHandler
implements ILogger {
    private static final String TAG = "BleManager";
    private static final UUID CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private static final UUID BATTERY_SERVICE = UUID.fromString("0000180F-0000-1000-8000-00805f9b34fb");
    private static final UUID BATTERY_LEVEL_CHARACTERISTIC = UUID.fromString("00002A19-0000-1000-8000-00805f9b34fb");
    private static final UUID GENERIC_ATTRIBUTE_SERVICE = UUID.fromString("00001801-0000-1000-8000-00805f9b34fb");
    private static final UUID SERVICE_CHANGED_CHARACTERISTIC = UUID.fromString("00002A05-0000-1000-8000-00805f9b34fb");
    private final Object mLock = new Object();
    private final Context mContext;
    final Handler mHandler;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothDevice mBluetoothDevice;
    private BleManagerGattCallback mGattCallback;
    protected E mCallbacks;
    private boolean mUserDisconnected;
    private boolean mInitialConnection;
    private boolean mConnected;
    private long mConnectionTime;
    private static final long CONNECTION_TIMEOUT_THRESHOLD = 20000L;
    private boolean mReady;
    private boolean mServicesDiscovered;
    private boolean mServiceDiscoveryRequested;
    private int mConnectionCount = 0;
    private int mConnectionState = 0;
    @Deprecated
    @IntRange(from=-1L, to=100L)
    private int mBatteryValue = -1;
    private int mMtu = 23;
    private boolean mReliableWriteInProgress;
    private ConnectRequest mConnectRequest;
    private Request mRequest;
    private RequestQueue mRequestQueue;
    private final HashMap<BluetoothGattCharacteristic, ValueChangedCallback> mNotificationCallbacks = new HashMap();
    private WaitForValueChangedRequest mValueChangedRequest;
    @Deprecated
    private ValueChangedCallback mBatteryLevelNotificationCallback;
    private final BroadcastReceiver mBluetoothStateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 10);
            int previousState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 10);
            String stateString = "[Broadcast] Action received: android.bluetooth.adapter.action.STATE_CHANGED, state changed to " + this.state2String(state);
            BleManager.this.log(3, stateString);
            switch (state) {
                case 10: 
                case 13: {
                    if (BleManager.this.mConnected && previousState != 13 && previousState != 10) {
                        BleManager.this.mGattCallback.mOperationInProgress = true;
                        BleManager.this.mGattCallback.cancelQueue();
                        BleManager.this.mGattCallback.mInitQueue = null;
                        if (BleManager.this.mRequest != null && ((BleManager)BleManager.this).mRequest.type != Request.Type.DISCONNECT) {
                            BleManager.this.mRequest.notifyFail(BleManager.this.mBluetoothDevice, -100);
                            BleManager.this.mRequest = null;
                        }
                        if (BleManager.this.mValueChangedRequest != null) {
                            BleManager.this.mValueChangedRequest.notifyFail(BleManager.this.mBluetoothDevice, -100);
                            BleManager.this.mValueChangedRequest = null;
                        }
                        if (BleManager.this.mConnectRequest != null) {
                            BleManager.this.mConnectRequest.notifyFail(BleManager.this.mBluetoothDevice, -100);
                            BleManager.this.mConnectRequest = null;
                        }
                        BleManager.this.mUserDisconnected = true;
                        BleManager.this.mGattCallback.mOperationInProgress = false;
                        BleManager.this.mGattCallback.notifyDeviceDisconnected(BleManager.this.mBluetoothDevice);
                        break;
                    }
                    BleManager.this.close();
                }
            }
        }

        private String state2String(int state) {
            switch (state) {
                case 11: {
                    return "TURNING ON";
                }
                case 12: {
                    return "ON";
                }
                case 13: {
                    return "TURNING OFF";
                }
                case 10: {
                    return "OFF";
                }
            }
            return "UNKNOWN (" + state + ")";
        }
    };
    private BroadcastReceiver mBondingBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            int bondState = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
            int previousBondState = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
            if (BleManager.this.mBluetoothDevice == null || !device.getAddress().equals(BleManager.this.mBluetoothDevice.getAddress())) {
                return;
            }
            BleManager.this.log(3, "[Broadcast] Action received: android.bluetooth.device.action.BOND_STATE_CHANGED, bond state changed to: " + BleManager.this.bondStateToString(bondState) + " (" + bondState + ")");
            switch (bondState) {
                case 10: {
                    if (previousBondState == 11) {
                        BleManager.this.mCallbacks.onBondingFailed(device);
                        BleManager.this.log(5, "Bonding failed");
                        if (BleManager.this.mRequest == null) break;
                        BleManager.this.mRequest.notifyFail(device, -4);
                        BleManager.this.mRequest = null;
                        break;
                    }
                    if (previousBondState != 12 || BleManager.this.mRequest == null || ((BleManager)BleManager.this).mRequest.type != Request.Type.REMOVE_BOND) break;
                    BleManager.this.log(4, "Bond information removed");
                    BleManager.this.mRequest.notifySuccess(device);
                    BleManager.this.mRequest = null;
                    break;
                }
                case 11: {
                    BleManager.this.mCallbacks.onBondingRequired(device);
                    return;
                }
                case 12: {
                    BleManager.this.log(4, "Device bonded");
                    BleManager.this.mCallbacks.onBonded(device);
                    if (BleManager.this.mRequest != null && ((BleManager)BleManager.this).mRequest.type == Request.Type.CREATE_BOND) {
                        BleManager.this.mRequest.notifySuccess(device);
                        BleManager.this.mRequest = null;
                        break;
                    }
                    if (!BleManager.this.mServicesDiscovered && !BleManager.this.mServiceDiscoveryRequested) {
                        BleManager.this.mServiceDiscoveryRequested = true;
                        BleManager.this.mHandler.post(() -> {
                            BleManager.this.log(2, "Discovering services...");
                            BleManager.this.log(3, "gatt.discoverServices()");
                            BleManager.this.mBluetoothGatt.discoverServices();
                        });
                        return;
                    }
                    if (Build.VERSION.SDK_INT < 26 && BleManager.this.mRequest != null && ((BleManager)BleManager.this).mRequest.type != Request.Type.CREATE_BOND) {
                        BleManager.this.mGattCallback.enqueueFirst(BleManager.this.mRequest);
                        break;
                    }
                    return;
                }
            }
            BleManager.this.mGattCallback.nextRequest(true);
        }
    };
    private final BroadcastReceiver mPairingRequestBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
            if (BleManager.this.mBluetoothDevice == null || device == null || !device.getAddress().equals(BleManager.this.mBluetoothDevice.getAddress())) {
                return;
            }
            int variant = intent.getIntExtra("android.bluetooth.device.extra.PAIRING_VARIANT", 0);
            BleManager.this.log(3, "[Broadcast] Action received: android.bluetooth.device.action.PAIRING_REQUEST, pairing variant: " + BleManager.this.pairingVariantToString(variant) + " (" + variant + ")");
            BleManager.this.onPairingRequestReceived(device, variant);
        }
    };
    protected static final int PAIRING_VARIANT_PIN = 0;
    protected static final int PAIRING_VARIANT_PASSKEY = 1;
    protected static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    protected static final int PAIRING_VARIANT_CONSENT = 3;
    protected static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    protected static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    protected static final int PAIRING_VARIANT_OOB_CONSENT = 6;

    protected void onPairingRequestReceived(@NonNull BluetoothDevice device, int variant) {
    }

    public BleManager(@NonNull Context context) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void setGattCallbacks(@NonNull E callbacks) {
        this.mCallbacks = callbacks;
    }

    @NonNull
    protected abstract BleManagerGattCallback getGattCallback();

    @NonNull
    protected final Context getContext() {
        return this.mContext;
    }

    @Nullable
    public BluetoothDevice getBluetoothDevice() {
        return this.mBluetoothDevice;
    }

    public final boolean isConnected() {
        return this.mConnected;
    }

    protected final boolean isBonded() {
        return this.mBluetoothDevice != null && this.mBluetoothDevice.getBondState() == 12;
    }

    public final boolean isReady() {
        return this.mReady;
    }

    public final int getConnectionState() {
        return this.mConnectionState;
    }

    @Deprecated
    @IntRange(from=-1L, to=100L)
    public final int getBatteryValue() {
        return this.mBatteryValue;
    }

    @Override
    public void log(int priority, @NonNull String message) {
    }

    @Override
    public void log(int priority, @StringRes int messageRes, Object ... params) {
        String message = this.mContext.getString(messageRes, params);
        this.log(priority, message);
    }

    @Deprecated
    protected boolean shouldAutoConnect() {
        return false;
    }

    protected boolean shouldClearCacheWhenDisconnected() {
        return false;
    }

    @IntRange(from=0L)
    protected int getServiceDiscoveryDelay(boolean bonded) {
        return bonded ? 1600 : 300;
    }

    @NonNull
    public final ConnectRequest connect(@NonNull BluetoothDevice device) {
        if (this.mCallbacks == null) {
            throw new NullPointerException("Set callbacks using setGattCallbacks(E callbacks) before connecting");
        }
        if (device == null) {
            throw new NullPointerException("Bluetooth device not specified");
        }
        return Request.connect(device).useAutoConnect(this.shouldAutoConnect()).setManager(this);
    }

    @Deprecated
    @NonNull
    public final ConnectRequest connect(@NonNull BluetoothDevice device, int phy) {
        if (this.mCallbacks == null) {
            throw new NullPointerException("Set callbacks using setGattCallbacks(E callbacks) before connecting");
        }
        if (device == null) {
            throw new NullPointerException("Bluetooth device not specified");
        }
        return Request.connect(device).usePreferredPhy(phy).useAutoConnect(this.shouldAutoConnect()).setManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    private boolean internalConnect(@NonNull BluetoothDevice device, @Nullable ConnectRequest connectRequest) {
        boolean bluetoothEnabled = BluetoothAdapter.getDefaultAdapter().isEnabled();
        if (this.mConnected || !bluetoothEnabled) {
            BluetoothDevice currentDevice = this.mBluetoothDevice;
            if (currentDevice != null && currentDevice.equals((Object)device)) {
                this.mConnectRequest.notifySuccess(device);
            } else {
                this.mConnectRequest.notifyFail(device, bluetoothEnabled ? -4 : -100);
            }
            this.mConnectRequest = null;
            this.mGattCallback.nextRequest(true);
            return true;
        }
        this.mConnectionState = 1;
        Object currentDevice = this.mLock;
        synchronized (currentDevice) {
            if (this.mBluetoothGatt != null) {
                if (this.mInitialConnection) {
                    this.mInitialConnection = false;
                    this.mConnectionTime = 0L;
                    this.log(2, "Connecting...");
                    this.mCallbacks.onDeviceConnecting(device);
                    this.log(3, "gatt.connect()");
                    this.mBluetoothGatt.connect();
                    return true;
                }
                this.log(3, "gatt.close()");
                this.mBluetoothGatt.close();
                this.mBluetoothGatt = null;
                try {
                    this.log(3, "wait(200)");
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.mContext.registerReceiver(this.mBluetoothStateBroadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
                this.mContext.registerReceiver(this.mBondingBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
                this.mContext.registerReceiver(this.mPairingRequestBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.PAIRING_REQUEST"));
            }
        }
        boolean shouldAutoConnect = connectRequest.shouldAutoConnect();
        boolean bl = this.mUserDisconnected = !shouldAutoConnect;
        if (shouldAutoConnect) {
            this.mInitialConnection = true;
        }
        this.mBluetoothDevice = device;
        this.mGattCallback.setHandler(this.mHandler);
        this.log(2, connectRequest.isFirstAttempt() ? "Connecting..." : "Retrying...");
        this.mCallbacks.onDeviceConnecting(device);
        this.mConnectionTime = SystemClock.elapsedRealtime();
        if (Build.VERSION.SDK_INT >= 26) {
            int preferredPhy = connectRequest.getPreferredPhy();
            this.log(3, "gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE, " + this.phyMaskToString(preferredPhy) + ")");
            this.mBluetoothGatt = device.connectGatt(this.mContext, false, (BluetoothGattCallback)this.mGattCallback, 2, preferredPhy, this.mHandler);
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.log(3, "gatt = device.connectGatt(autoConnect = false, TRANSPORT_LE)");
            this.mBluetoothGatt = device.connectGatt(this.mContext, false, (BluetoothGattCallback)this.mGattCallback, 2);
            return true;
        }
        this.log(3, "gatt = device.connectGatt(autoConnect = false)");
        this.mBluetoothGatt = device.connectGatt(this.mContext, false, (BluetoothGattCallback)this.mGattCallback);
        return true;
    }

    @NonNull
    public final DisconnectRequest disconnect() {
        return Request.disconnect().setManager(this);
    }

    @MainThread
    private boolean internalDisconnect() {
        this.mUserDisconnected = true;
        this.mInitialConnection = false;
        this.mReady = false;
        if (this.mBluetoothGatt != null) {
            this.mConnectionState = 3;
            this.log(2, this.mConnected ? "Disconnecting..." : "Cancelling connection...");
            this.mCallbacks.onDeviceDisconnecting(this.mBluetoothGatt.getDevice());
            boolean wasConnected = this.mConnected;
            this.log(3, "gatt.disconnect()");
            this.mBluetoothGatt.disconnect();
            if (wasConnected) {
                return true;
            }
            this.mConnectionState = 0;
            this.log(4, "Disconnected");
            this.mCallbacks.onDeviceDisconnected(this.mBluetoothGatt.getDevice());
        }
        if (this.mRequest != null && this.mRequest.type == Request.Type.DISCONNECT) {
            if (this.mBluetoothDevice != null) {
                this.mRequest.notifySuccess(this.mBluetoothDevice);
            } else {
                this.mRequest.notifyInvalidRequest();
            }
        }
        this.mGattCallback.nextRequest(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.mContext.unregisterReceiver(this.mBluetoothStateBroadcastReceiver);
            this.mContext.unregisterReceiver(this.mBondingBroadcastReceiver);
            this.mContext.unregisterReceiver(this.mPairingRequestBroadcastReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothGatt != null) {
                if (this.shouldClearCacheWhenDisconnected()) {
                    if (this.internalRefreshDeviceCache()) {
                        this.log(4, "Cache refreshed");
                    } else {
                        this.log(5, "Refreshing failed");
                    }
                }
                this.log(3, "gatt.close()");
                this.mBluetoothGatt.close();
                this.mBluetoothGatt = null;
            }
            this.mConnected = false;
            this.mInitialConnection = false;
            this.mReliableWriteInProgress = false;
            this.mNotificationCallbacks.clear();
            this.mConnectionState = 0;
            if (this.mGattCallback != null) {
                this.mGattCallback.cancelQueue();
                this.mGattCallback.mInitQueue = null;
            }
            this.mGattCallback = null;
            this.mBluetoothDevice = null;
        }
    }

    @NonNull
    protected final Request createBond() {
        return Request.createBond().setManager(this);
    }

    @MainThread
    private boolean internalCreateBond() {
        BluetoothDevice device = this.mBluetoothDevice;
        if (device == null) {
            return false;
        }
        this.log(2, "Starting pairing...");
        if (device.getBondState() == 12) {
            this.log(5, "Device already bonded");
            this.mRequest.notifySuccess(device);
            this.mGattCallback.nextRequest(true);
            return true;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.log(3, "device.createBond()");
            return device.createBond();
        }
        try {
            Method createBond = device.getClass().getMethod("createBond", new Class[0]);
            this.log(3, "device.createBond() (hidden)");
            return (Boolean)createBond.invoke((Object)device, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while creating bond", (Throwable)e);
            return false;
        }
    }

    @NonNull
    protected final Request removeBond() {
        return Request.removeBond().setManager(this);
    }

    @MainThread
    private boolean internalRemoveBond() {
        BluetoothDevice device = this.mBluetoothDevice;
        if (device == null) {
            return false;
        }
        this.log(2, "Removing bond information...");
        if (device.getBondState() == 10) {
            this.log(5, "Device is not bonded");
            this.mRequest.notifySuccess(device);
            this.mGattCallback.nextRequest(true);
            return true;
        }
        try {
            Method removeBond = device.getClass().getMethod("removeBond", new Class[0]);
            this.log(3, "device.removeBond() (hidden)");
            return (Boolean)removeBond.invoke((Object)device, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while removing bond", (Throwable)e);
            return false;
        }
    }

    private boolean ensureServiceChangedEnabled() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        BluetoothDevice device = gatt.getDevice();
        if (device.getBondState() != 12) {
            return false;
        }
        BluetoothGattService gaService = gatt.getService(GENERIC_ATTRIBUTE_SERVICE);
        if (gaService == null) {
            return false;
        }
        BluetoothGattCharacteristic scCharacteristic = gaService.getCharacteristic(SERVICE_CHANGED_CHARACTERISTIC);
        if (scCharacteristic == null) {
            return false;
        }
        this.log(4, "Service Changed characteristic found on a bonded device");
        return this.internalEnableIndications(scCharacteristic);
    }

    @MainThread
    @NonNull
    protected final ValueChangedCallback setNotificationCallback(@Nullable BluetoothGattCharacteristic characteristic) {
        ValueChangedCallback callback = this.mNotificationCallbacks.get(characteristic);
        if (callback == null) {
            callback = new ValueChangedCallback();
            if (characteristic != null) {
                this.mNotificationCallbacks.put(characteristic, callback);
            }
        }
        return callback.free();
    }

    @NonNull
    protected final ValueChangedCallback setIndicationCallback(@Nullable BluetoothGattCharacteristic characteristic) {
        return this.setNotificationCallback(characteristic);
    }

    @NonNull
    protected final WaitForValueChangedRequest waitForNotification(@NonNull BluetoothGattCharacteristic characteristic) {
        return Request.newWaitForNotificationRequest(characteristic).setManager(this);
    }

    @NonNull
    protected final WaitForValueChangedRequest waitForIndication(@NonNull BluetoothGattCharacteristic characteristic) {
        return Request.newWaitForIndicationRequest(characteristic).setManager(this);
    }

    @NonNull
    protected final WriteRequest enableNotifications(@Nullable BluetoothGattCharacteristic characteristic) {
        return Request.newEnableNotificationsRequest(characteristic).setManager(this);
    }

    @MainThread
    private boolean internalEnableNotifications(BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || characteristic == null || !this.mConnected) {
            return false;
        }
        BluetoothGattDescriptor descriptor = BleManager.getCccd(characteristic, 16);
        if (descriptor != null) {
            this.log(3, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", true)");
            gatt.setCharacteristicNotification(characteristic, true);
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            this.log(2, "Enabling notifications for " + characteristic.getUuid());
            this.log(3, "gatt.writeDescriptor(" + CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID + ", value=0x01-00)");
            return this.internalWriteDescriptorWorkaround(descriptor);
        }
        return false;
    }

    @NonNull
    protected final WriteRequest disableNotifications(@Nullable BluetoothGattCharacteristic characteristic) {
        return Request.newDisableNotificationsRequest(characteristic).setManager(this);
    }

    @MainThread
    private boolean internalDisableNotifications(BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || characteristic == null || !this.mConnected) {
            return false;
        }
        BluetoothGattDescriptor descriptor = BleManager.getCccd(characteristic, 16);
        if (descriptor != null) {
            this.log(3, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", false)");
            gatt.setCharacteristicNotification(characteristic, false);
            descriptor.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
            this.log(2, "Disabling notifications and indications for " + characteristic.getUuid());
            this.log(3, "gatt.writeDescriptor(" + CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID + ", value=0x00-00)");
            return this.internalWriteDescriptorWorkaround(descriptor);
        }
        return false;
    }

    @NonNull
    protected final WriteRequest enableIndications(@Nullable BluetoothGattCharacteristic characteristic) {
        return Request.newEnableIndicationsRequest(characteristic).setManager(this);
    }

    @MainThread
    private boolean internalEnableIndications(BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || characteristic == null || !this.mConnected) {
            return false;
        }
        BluetoothGattDescriptor descriptor = BleManager.getCccd(characteristic, 32);
        if (descriptor != null) {
            this.log(3, "gatt.setCharacteristicNotification(" + characteristic.getUuid() + ", true)");
            gatt.setCharacteristicNotification(characteristic, true);
            descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
            this.log(2, "Enabling indications for " + characteristic.getUuid());
            this.log(3, "gatt.writeDescriptor(" + CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID + ", value=0x02-00)");
            return this.internalWriteDescriptorWorkaround(descriptor);
        }
        return false;
    }

    @NonNull
    protected final WriteRequest disableIndications(@Nullable BluetoothGattCharacteristic characteristic) {
        return Request.newDisableIndicationsRequest(characteristic).setManager(this);
    }

    @MainThread
    private boolean internalDisableIndications(BluetoothGattCharacteristic characteristic) {
        return this.internalDisableNotifications(characteristic);
    }

    private static BluetoothGattDescriptor getCccd(@Nullable BluetoothGattCharacteristic characteristic, int requiredProperty) {
        if (characteristic == null) {
            return null;
        }
        int properties = characteristic.getProperties();
        if ((properties & requiredProperty) == 0) {
            return null;
        }
        return characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID);
    }

    @NonNull
    protected final ReadRequest readCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
        return Request.newReadRequest(characteristic).setManager(this);
    }

    @MainThread
    private boolean internalReadCharacteristic(BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || characteristic == null || !this.mConnected) {
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 2) == 0) {
            return false;
        }
        this.log(2, "Reading characteristic " + characteristic.getUuid());
        this.log(3, "gatt.readCharacteristic(" + characteristic.getUuid() + ")");
        return gatt.readCharacteristic(characteristic);
    }

    @NonNull
    protected final WriteRequest writeCharacteristic(@Nullable BluetoothGattCharacteristic characteristic, @Nullable Data data) {
        return Request.newWriteRequest(characteristic, data != null ? data.getValue() : null).setManager(this);
    }

    @NonNull
    protected final WriteRequest writeCharacteristic(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data) {
        return Request.newWriteRequest(characteristic, data).setManager(this);
    }

    @NonNull
    protected final WriteRequest writeCharacteristic(@Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data, int offset, int length) {
        return Request.newWriteRequest(characteristic, data, offset, length).setManager(this);
    }

    @MainThread
    private boolean internalWriteCharacteristic(BluetoothGattCharacteristic characteristic) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || characteristic == null || !this.mConnected) {
            return false;
        }
        int properties = characteristic.getProperties();
        if ((properties & 0xC) == 0) {
            return false;
        }
        this.log(2, "Writing characteristic " + characteristic.getUuid() + " (" + this.writeTypeToString(characteristic.getWriteType()) + ")");
        this.log(3, "gatt.writeCharacteristic(" + characteristic.getUuid() + ")");
        return gatt.writeCharacteristic(characteristic);
    }

    @NonNull
    protected final ReadRequest readDescriptor(@Nullable BluetoothGattDescriptor descriptor) {
        return Request.newReadRequest(descriptor).setManager(this);
    }

    @MainThread
    private boolean internalReadDescriptor(BluetoothGattDescriptor descriptor) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || descriptor == null || !this.mConnected) {
            return false;
        }
        this.log(2, "Reading descriptor " + descriptor.getUuid());
        this.log(3, "gatt.readDescriptor(" + descriptor.getUuid() + ")");
        return gatt.readDescriptor(descriptor);
    }

    @NonNull
    protected final WriteRequest writeDescriptor(@Nullable BluetoothGattDescriptor descriptor, @Nullable Data data) {
        return Request.newWriteRequest(descriptor, data != null ? data.getValue() : null).setManager(this);
    }

    @NonNull
    protected final WriteRequest writeDescriptor(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] data) {
        return Request.newWriteRequest(descriptor, data).setManager(this);
    }

    @NonNull
    protected final WriteRequest writeDescriptor(@Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] data, int offset, int length) {
        return Request.newWriteRequest(descriptor, data, offset, length).setManager(this);
    }

    @MainThread
    private boolean internalWriteDescriptor(BluetoothGattDescriptor descriptor) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || descriptor == null || !this.mConnected) {
            return false;
        }
        this.log(2, "Writing descriptor " + descriptor.getUuid());
        this.log(3, "gatt.writeDescriptor(" + descriptor.getUuid() + ")");
        return this.internalWriteDescriptorWorkaround(descriptor);
    }

    @NonNull
    protected final RequestQueue beginAtomicRequestQueue() {
        return new RequestQueue().setManager(this);
    }

    @NonNull
    protected final ReliableWriteRequest beginReliableWrite() {
        return Request.newReliableWriteRequest().setManager(this);
    }

    @MainThread
    private boolean internalBeginReliableWrite() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        if (this.mReliableWriteInProgress) {
            return true;
        }
        this.log(2, "Beginning reliable write...");
        this.log(3, "gatt.beginReliableWrite()");
        this.mReliableWriteInProgress = gatt.beginReliableWrite();
        return this.mReliableWriteInProgress;
    }

    @MainThread
    private boolean internalExecuteReliableWrite() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        if (!this.mReliableWriteInProgress) {
            return false;
        }
        this.log(2, "Executing reliable write...");
        this.log(3, "gatt.executeReliableWrite()");
        return gatt.executeReliableWrite();
    }

    @MainThread
    private boolean internalAbortReliableWrite() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        if (!this.mReliableWriteInProgress) {
            return false;
        }
        this.log(2, "Aborting reliable write...");
        if (Build.VERSION.SDK_INT >= 19) {
            this.log(3, "gatt.abortReliableWrite()");
            gatt.abortReliableWrite();
        } else {
            this.log(3, "gatt.abortReliableWrite(device)");
            gatt.abortReliableWrite(this.mBluetoothDevice);
        }
        return true;
    }

    protected final boolean isReliableWriteInProgress() {
        return this.mReliableWriteInProgress;
    }

    @Deprecated
    protected void readBatteryLevel() {
        Request.newReadBatteryLevelRequest().setManager(this).with((device, data) -> {
            if (data.size() == 1) {
                int batteryLevel = data.getIntValue(17, 0);
                this.log(4, "Battery Level received: " + batteryLevel + "%");
                this.mBatteryValue = batteryLevel;
                BleManagerGattCallback callback = this.mGattCallback;
                if (callback != null) {
                    callback.onBatteryValueReceived(this.mBluetoothGatt, batteryLevel);
                }
                this.mCallbacks.onBatteryValueReceived(device, batteryLevel);
            }
        }).enqueue();
    }

    @Deprecated
    @MainThread
    private boolean internalReadBatteryLevel() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        BluetoothGattService batteryService = gatt.getService(BATTERY_SERVICE);
        if (batteryService == null) {
            return false;
        }
        BluetoothGattCharacteristic batteryLevelCharacteristic = batteryService.getCharacteristic(BATTERY_LEVEL_CHARACTERISTIC);
        return this.internalReadCharacteristic(batteryLevelCharacteristic);
    }

    @Deprecated
    protected void enableBatteryLevelNotifications() {
        if (this.mBatteryLevelNotificationCallback == null) {
            this.mBatteryLevelNotificationCallback = new ValueChangedCallback().with((device, data) -> {
                if (data.size() == 1) {
                    int batteryLevel;
                    this.mBatteryValue = batteryLevel = data.getIntValue(17, 0).intValue();
                    BleManagerGattCallback callback = this.mGattCallback;
                    if (callback != null) {
                        callback.onBatteryValueReceived(this.mBluetoothGatt, batteryLevel);
                    }
                    this.mCallbacks.onBatteryValueReceived(device, batteryLevel);
                }
            });
        }
        Request.newEnableBatteryLevelNotificationsRequest().setManager(this).done(device -> this.log(4, "Battery Level notifications enabled")).enqueue();
    }

    @Deprecated
    protected void disableBatteryLevelNotifications() {
        Request.newDisableBatteryLevelNotificationsRequest().setManager(this).done(device -> this.log(4, "Battery Level notifications disabled")).enqueue();
    }

    @Deprecated
    @MainThread
    private boolean internalSetBatteryNotifications(boolean enable) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        BluetoothGattService batteryService = gatt.getService(BATTERY_SERVICE);
        if (batteryService == null) {
            return false;
        }
        BluetoothGattCharacteristic batteryLevelCharacteristic = batteryService.getCharacteristic(BATTERY_LEVEL_CHARACTERISTIC);
        if (enable) {
            return this.internalEnableNotifications(batteryLevelCharacteristic);
        }
        return this.internalDisableNotifications(batteryLevelCharacteristic);
    }

    @MainThread
    private boolean internalWriteDescriptorWorkaround(BluetoothGattDescriptor descriptor) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || descriptor == null || !this.mConnected) {
            return false;
        }
        BluetoothGattCharacteristic parentCharacteristic = descriptor.getCharacteristic();
        int originalWriteType = parentCharacteristic.getWriteType();
        parentCharacteristic.setWriteType(2);
        boolean result = gatt.writeDescriptor(descriptor);
        parentCharacteristic.setWriteType(originalWriteType);
        return result;
    }

    protected final MtuRequest requestMtu(@IntRange(from=23L, to=517L) int mtu) {
        return Request.newMtuRequest(mtu).setManager(this);
    }

    @IntRange(from=23L, to=517L)
    protected final int getMtu() {
        return this.mMtu;
    }

    protected final void overrideMtu(@IntRange(from=23L, to=517L) int mtu) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mMtu = mtu;
        }
    }

    @RequiresApi(api=21)
    @MainThread
    private boolean internalRequestMtu(@IntRange(from=23L, to=517L) int mtu) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        this.log(2, "Requesting new MTU...");
        this.log(3, "gatt.requestMtu(" + mtu + ")");
        return gatt.requestMtu(mtu);
    }

    @RequiresApi(api=21)
    protected final ConnectionPriorityRequest requestConnectionPriority(int priority) {
        return Request.newConnectionPriorityRequest(priority).setManager(this);
    }

    @RequiresApi(api=21)
    @MainThread
    private boolean internalRequestConnectionPriority(int priority) {
        String priorityText;
        String text;
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        switch (priority) {
            case 1: {
                text = Build.VERSION.SDK_INT >= 23 ? "HIGH (11.25\u201315ms, 0, 20s)" : "HIGH (7.5\u201310ms, 0, 20s)";
                priorityText = "HIGH";
                break;
            }
            case 2: {
                text = "BALANCED (30\u201350ms, 0, 20s)";
                priorityText = "LOW POWER";
                break;
            }
            default: {
                text = "LOW POWER (100\u2013125ms, 2, 20s)";
                priorityText = "BALANCED";
            }
        }
        this.log(2, "Requesting connection priority: " + text + "...");
        this.log(3, "gatt.requestConnectionPriority(" + priorityText + ")");
        return gatt.requestConnectionPriority(priority);
    }

    protected final PhyRequest setPreferredPhy(int txPhy, int rxPhy, int phyOptions) {
        return Request.newSetPreferredPhyRequest(txPhy, rxPhy, phyOptions).setManager(this);
    }

    @RequiresApi(api=26)
    @MainThread
    private boolean internalSetPreferredPhy(int txPhy, int rxPhy, int phyOptions) {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        this.log(2, "Requesting preferred PHYs...");
        this.log(3, "gatt.setPreferredPhy(" + this.phyMaskToString(txPhy) + ", " + this.phyMaskToString(rxPhy) + ", coding option = " + this.phyCodedOptionToString(phyOptions) + ")");
        gatt.setPreferredPhy(txPhy, rxPhy, phyOptions);
        return true;
    }

    protected final PhyRequest readPhy() {
        return Request.newReadPhyRequest().setManager(this);
    }

    @RequiresApi(api=26)
    @MainThread
    private boolean internalReadPhy() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        this.log(2, "Reading PHY...");
        this.log(3, "gatt.readPhy()");
        gatt.readPhy();
        return true;
    }

    protected final ReadRssiRequest readRssi() {
        return Request.newReadRssiRequest().setManager(this);
    }

    @MainThread
    private boolean internalReadRssi() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null || !this.mConnected) {
            return false;
        }
        this.log(2, "Reading remote RSSI...");
        this.log(3, "gatt.readRemoteRssi()");
        return gatt.readRemoteRssi();
    }

    protected final Request refreshDeviceCache() {
        return Request.newRefreshCacheRequest().setManager(this);
    }

    @MainThread
    private boolean internalRefreshDeviceCache() {
        BluetoothGatt gatt = this.mBluetoothGatt;
        if (gatt == null) {
            return false;
        }
        this.log(2, "Refreshing device cache...");
        this.log(3, "gatt.refresh() (hidden)");
        try {
            Method refresh = gatt.getClass().getMethod("refresh", new Class[0]);
            return (Boolean)refresh.invoke((Object)gatt, new Object[0]);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"An exception occurred while refreshing device", (Throwable)e);
            this.log(5, "gatt.refresh() method not found");
            return false;
        }
    }

    protected final SleepRequest sleep(@IntRange(from=0L) long delay) {
        return Request.newSleepRequest(delay).setManager(this);
    }

    @Deprecated
    protected final void enqueue(@NonNull Request request) {
        BleManagerGattCallback callback = this.mGattCallback;
        if (callback == null) {
            callback = this.mGattCallback = this.getGattCallback();
        }
        BleManagerGattCallback finalCallback = callback;
        finalCallback.enqueue(request);
        this.runOnUiThread(() -> finalCallback.nextRequest(false));
    }

    protected final void clearQueue() {
        BleManagerGattCallback callback = this.mGattCallback;
        if (callback != null) {
            callback.cancelQueue();
        }
    }

    private void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            this.mHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    @MainThread
    void onRequestTimeout(@NonNull TimeoutableRequest request) {
        this.mRequest = null;
        this.mValueChangedRequest = null;
        if (request.type == Request.Type.CONNECT) {
            this.mConnectRequest = null;
            this.internalDisconnect();
            return;
        }
        if (request.type == Request.Type.DISCONNECT) {
            this.close();
            return;
        }
        BleManagerGattCallback callback = this.mGattCallback;
        if (callback != null) {
            callback.nextRequest(true);
        }
    }

    protected String pairingVariantToString(int variant) {
        switch (variant) {
            case 0: {
                return "PAIRING_VARIANT_PIN";
            }
            case 1: {
                return "PAIRING_VARIANT_PASSKEY";
            }
            case 2: {
                return "PAIRING_VARIANT_PASSKEY_CONFIRMATION";
            }
            case 3: {
                return "PAIRING_VARIANT_CONSENT";
            }
            case 4: {
                return "PAIRING_VARIANT_DISPLAY_PASSKEY";
            }
            case 5: {
                return "PAIRING_VARIANT_DISPLAY_PIN";
            }
            case 6: {
                return "PAIRING_VARIANT_OOB_CONSENT";
            }
        }
        return "UNKNOWN";
    }

    protected String bondStateToString(int state) {
        switch (state) {
            case 10: {
                return "BOND_NONE";
            }
            case 11: {
                return "BOND_BONDING";
            }
            case 12: {
                return "BOND_BONDED";
            }
        }
        return "UNKNOWN";
    }

    protected String writeTypeToString(int type) {
        switch (type) {
            case 2: {
                return "WRITE REQUEST";
            }
            case 1: {
                return "WRITE COMMAND";
            }
            case 4: {
                return "WRITE SIGNED";
            }
        }
        return "UNKNOWN: " + type;
    }

    protected String stateToString(int state) {
        switch (state) {
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
        }
        return "DISCONNECTED";
    }

    @RequiresApi(value=26)
    private String phyToString(int phy) {
        switch (phy) {
            case 1: {
                return "LE 1M";
            }
            case 2: {
                return "LE 2M";
            }
            case 3: {
                return "LE Coded";
            }
        }
        return "UNKNOWN (" + phy + ")";
    }

    @RequiresApi(value=26)
    private String phyMaskToString(int mask) {
        switch (mask) {
            case 1: {
                return "LE 1M";
            }
            case 2: {
                return "LE 2M";
            }
            case 4: {
                return "LE Coded";
            }
            case 3: {
                return "LE 1M or LE 2M";
            }
            case 5: {
                return "LE 1M or LE Coded";
            }
            case 6: {
                return "LE 2M or LE Coded";
            }
            case 7: {
                return "LE 1M, LE 2M or LE Coded";
            }
        }
        return "UNKNOWN (" + mask + ")";
    }

    @RequiresApi(value=26)
    private String phyCodedOptionToString(int option) {
        switch (option) {
            case 0: {
                return "No preferred";
            }
            case 1: {
                return "S2";
            }
            case 2: {
                return "S8";
            }
        }
        return "UNKNOWN (" + option + ")";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PairingVariant {
    }

    protected abstract class BleManagerGattCallback
    extends MainThreadBluetoothGattCallback {
        private static final String ERROR_CONNECTION_STATE_CHANGE = "Error on connection state change";
        private static final String ERROR_DISCOVERY_SERVICE = "Error on discovering services";
        private static final String ERROR_AUTH_ERROR_WHILE_BONDED = "Phone has lost bonding information";
        private static final String ERROR_READ_CHARACTERISTIC = "Error on reading characteristic";
        private static final String ERROR_WRITE_CHARACTERISTIC = "Error on writing characteristic";
        private static final String ERROR_READ_DESCRIPTOR = "Error on reading descriptor";
        private static final String ERROR_WRITE_DESCRIPTOR = "Error on writing descriptor";
        private static final String ERROR_MTU_REQUEST = "Error on mtu request";
        private static final String ERROR_CONNECTION_PRIORITY_REQUEST = "Error on connection priority request";
        private static final String ERROR_READ_RSSI = "Error on RSSI read";
        private static final String ERROR_READ_PHY = "Error on PHY read";
        private static final String ERROR_PHY_UPDATE = "Error on PHY update";
        private static final String ERROR_RELIABLE_WRITE = "Error on Execute Reliable Write";
        private final Deque<Request> mTaskQueue = new LinkedList<Request>();
        private Deque<Request> mInitQueue;
        private boolean mInitInProgress;
        private boolean mOperationInProgress;
        private boolean mConnectionPriorityOperationInProgress = false;

        protected BleManagerGattCallback() {
        }

        protected abstract boolean isRequiredServiceSupported(@NonNull BluetoothGatt var1);

        protected boolean isOptionalServiceSupported(@NonNull BluetoothGatt gatt) {
            return false;
        }

        @Deprecated
        protected Deque<Request> initGatt(@NonNull BluetoothGatt gatt) {
            return null;
        }

        protected void initialize() {
        }

        protected void onDeviceReady() {
            BleManager.this.mCallbacks.onDeviceReady(BleManager.this.mBluetoothGatt.getDevice());
        }

        protected void onManagerReady() {
        }

        protected abstract void onDeviceDisconnected();

        private void notifyDeviceDisconnected(@NonNull BluetoothDevice device) {
            boolean wasConnected = BleManager.this.mConnected;
            BleManager.this.mConnected = false;
            BleManager.this.mServicesDiscovered = false;
            BleManager.this.mServiceDiscoveryRequested = false;
            this.mInitInProgress = false;
            BleManager.this.mConnectionState = 0;
            if (!wasConnected) {
                BleManager.this.log(5, "Connection attempt timed out");
                BleManager.this.close();
                BleManager.this.mCallbacks.onDeviceDisconnected(device);
            } else if (BleManager.this.mUserDisconnected) {
                BleManager.this.log(4, "Disconnected");
                BleManager.this.close();
                BleManager.this.mCallbacks.onDeviceDisconnected(device);
                Request request = BleManager.this.mRequest;
                if (request != null && request.type == Request.Type.DISCONNECT) {
                    request.notifySuccess(device);
                }
            } else {
                BleManager.this.log(5, "Connection lost");
                BleManager.this.mCallbacks.onLinkLossOccurred(device);
            }
            this.onDeviceDisconnected();
        }

        @Deprecated
        protected void onCharacteristicRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
        }

        @Deprecated
        protected void onCharacteristicWrite(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
        }

        @Deprecated
        protected void onDescriptorRead(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor) {
        }

        @Deprecated
        protected void onDescriptorWrite(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor) {
        }

        @Deprecated
        protected void onBatteryValueReceived(@NonNull BluetoothGatt gatt, @IntRange(from=0L, to=100L) int value) {
        }

        @Deprecated
        protected void onCharacteristicNotified(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
        }

        @Deprecated
        protected void onCharacteristicIndicated(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic) {
        }

        @Deprecated
        protected void onMtuChanged(@NonNull BluetoothGatt gatt, @IntRange(from=23L, to=517L) int mtu) {
        }

        @Deprecated
        @TargetApi(value=26)
        protected void onConnectionUpdated(@NonNull BluetoothGatt gatt, @IntRange(from=6L, to=3200L) int interval, @IntRange(from=0L, to=499L) int latency, @IntRange(from=10L, to=3200L) int timeout) {
        }

        private void onError(BluetoothDevice device, String message, int errorCode) {
            BleManager.this.log(6, "Error (0x" + Integer.toHexString(errorCode) + "): " + GattError.parse(errorCode));
            BleManager.this.mCallbacks.onError(device, message, errorCode);
        }

        @Override
        final void onConnectionStateChangeSafe(@NonNull BluetoothGatt gatt, int status, int newState) {
            BleManager.this.log(3, "[Callback] Connection state changed with status: " + status + " and new state: " + newState + " (" + BleManager.this.stateToString(newState) + ")");
            if (status == 0 && newState == 2) {
                if (BleManager.this.mBluetoothDevice == null) {
                    Log.e((String)BleManager.TAG, (String)"Device received notification after disconnection.");
                    BleManager.this.log(3, "gatt.close()");
                    gatt.close();
                    return;
                }
                BleManager.this.log(4, "Connected to " + gatt.getDevice().getAddress());
                BleManager.this.mConnected = true;
                BleManager.this.mConnectionTime = 0L;
                BleManager.this.mConnectionState = 2;
                BleManager.this.mCallbacks.onDeviceConnected(gatt.getDevice());
                if (!BleManager.this.mServiceDiscoveryRequested) {
                    boolean bonded = gatt.getDevice().getBondState() == 12;
                    int delay = BleManager.this.getServiceDiscoveryDelay(bonded);
                    if (delay > 0) {
                        BleManager.this.log(3, "wait(" + delay + ")");
                    }
                    int connectionCount = ++BleManager.this.mConnectionCount;
                    BleManager.this.mHandler.postDelayed(() -> {
                        if (connectionCount != BleManager.this.mConnectionCount) {
                            return;
                        }
                        if (BleManager.this.mConnected && gatt.getDevice().getBondState() != 11) {
                            BleManager.this.mServiceDiscoveryRequested = true;
                            BleManager.this.log(2, "Discovering services...");
                            BleManager.this.log(3, "gatt.discoverServices()");
                            gatt.discoverServices();
                        }
                    }, (long)delay);
                }
            } else {
                if (newState == 0) {
                    boolean timeout;
                    long now = SystemClock.elapsedRealtime();
                    boolean canTimeout = BleManager.this.mConnectionTime > 0L;
                    boolean bl = timeout = canTimeout && now > BleManager.this.mConnectionTime + 20000L;
                    if (status != 0) {
                        BleManager.this.log(5, "Error: (0x" + Integer.toHexString(status) + "): " + GattError.parseConnectionError(status));
                    }
                    if (status != 0 && canTimeout && !timeout && BleManager.this.mConnectRequest != null && BleManager.this.mConnectRequest.canRetry()) {
                        int delay = BleManager.this.mConnectRequest.getRetryDelay();
                        if (delay > 0) {
                            BleManager.this.log(3, "wait(" + delay + ")");
                        }
                        BleManager.this.mHandler.postDelayed(() -> BleManager.this.internalConnect(gatt.getDevice(), BleManager.this.mConnectRequest), (long)delay);
                        return;
                    }
                    this.mOperationInProgress = true;
                    this.cancelQueue();
                    this.mInitQueue = null;
                    BleManager.this.mReady = false;
                    boolean wasConnected = BleManager.this.mConnected;
                    this.notifyDeviceDisconnected(gatt.getDevice());
                    if (BleManager.this.mRequest != null && ((BleManager)BleManager.this).mRequest.type != Request.Type.DISCONNECT && ((BleManager)BleManager.this).mRequest.type != Request.Type.REMOVE_BOND) {
                        BleManager.this.mRequest.notifyFail(gatt.getDevice(), status == 0 ? -1 : status);
                        BleManager.this.mRequest = null;
                    }
                    if (BleManager.this.mValueChangedRequest != null) {
                        BleManager.this.mValueChangedRequest.notifyFail(BleManager.this.mBluetoothDevice, -1);
                        BleManager.this.mValueChangedRequest = null;
                    }
                    if (BleManager.this.mConnectRequest != null) {
                        int reason = BleManager.this.mServicesDiscovered ? -2 : (status == 0 ? -1 : (status == 133 && timeout ? -5 : status));
                        BleManager.this.mConnectRequest.notifyFail(gatt.getDevice(), reason);
                        BleManager.this.mConnectRequest = null;
                    }
                    this.mOperationInProgress = false;
                    if (wasConnected && BleManager.this.mInitialConnection) {
                        BleManager.this.internalConnect(gatt.getDevice(), null);
                    } else {
                        BleManager.this.mInitialConnection = false;
                        this.nextRequest(false);
                    }
                    if (wasConnected || status == 0) {
                        return;
                    }
                } else if (status != 0) {
                    BleManager.this.log(6, "Error (0x" + Integer.toHexString(status) + "): " + GattError.parseConnectionError(status));
                }
                BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_CONNECTION_STATE_CHANGE, status);
            }
        }

        @Override
        final void onServicesDiscoveredSafe(@NonNull BluetoothGatt gatt, int status) {
            BleManager.this.mServiceDiscoveryRequested = false;
            if (status == 0) {
                BleManager.this.log(4, "Services discovered");
                BleManager.this.mServicesDiscovered = true;
                if (this.isRequiredServiceSupported(gatt)) {
                    boolean deprecatedApiUsed;
                    BleManager.this.log(2, "Primary service found");
                    boolean optionalServicesFound = this.isOptionalServiceSupported(gatt);
                    if (optionalServicesFound) {
                        BleManager.this.log(2, "Secondary service found");
                    }
                    BleManager.this.mCallbacks.onServicesDiscovered(gatt.getDevice(), optionalServicesFound);
                    this.mInitInProgress = true;
                    this.mOperationInProgress = true;
                    this.mInitQueue = this.initGatt(gatt);
                    boolean bl = deprecatedApiUsed = this.mInitQueue != null;
                    if (deprecatedApiUsed) {
                        for (Request request : this.mInitQueue) {
                            request.enqueued = true;
                        }
                    }
                    if (this.mInitQueue == null) {
                        this.mInitQueue = new LinkedList<Request>();
                    }
                    if (Build.VERSION.SDK_INT < 23 || Build.VERSION.SDK_INT == 26 || Build.VERSION.SDK_INT == 27 || Build.VERSION.SDK_INT == 28) {
                        this.enqueueFirst(Request.newEnableServiceChangedIndicationsRequest().setManager(BleManager.this));
                    }
                    if (deprecatedApiUsed) {
                        BleManager.this.readBatteryLevel();
                        if (BleManager.this.mCallbacks.shouldEnableBatteryLevelNotifications(gatt.getDevice())) {
                            BleManager.this.enableBatteryLevelNotifications();
                        }
                    }
                    this.initialize();
                    this.mInitInProgress = false;
                    this.nextRequest(true);
                } else {
                    BleManager.this.log(5, "Device is not supported");
                    BleManager.this.mCallbacks.onDeviceNotSupported(gatt.getDevice());
                    BleManager.this.internalDisconnect();
                }
            } else {
                Log.e((String)BleManager.TAG, (String)("onServicesDiscovered error " + status));
                this.onError(gatt.getDevice(), ERROR_DISCOVERY_SERVICE, status);
                if (BleManager.this.mConnectRequest != null) {
                    BleManager.this.mConnectRequest.notifyFail(gatt.getDevice(), -4);
                    BleManager.this.mConnectRequest = null;
                }
                BleManager.this.internalDisconnect();
            }
        }

        @Override
        final void onCharacteristicReadSafe(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, @Nullable byte[] data, int status) {
            if (status == 0) {
                BleManager.this.log(4, "Read Response received from " + characteristic.getUuid() + ", value: " + ParserUtils.parse(data));
                this.onCharacteristicRead(gatt, characteristic);
                if (BleManager.this.mRequest instanceof ReadRequest) {
                    ReadRequest request = (ReadRequest)BleManager.this.mRequest;
                    request.notifyValueChanged(gatt.getDevice(), data);
                    if (request.hasMore()) {
                        this.enqueueFirst(request);
                    } else {
                        request.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManager.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManager.TAG, (String)ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_AUTH_ERROR_WHILE_BONDED, status);
                    }
                    return;
                }
                Log.e((String)BleManager.TAG, (String)("onCharacteristicRead error " + status));
                if (BleManager.this.mRequest instanceof ReadRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                }
                BleManager.this.mValueChangedRequest = null;
                this.onError(gatt.getDevice(), ERROR_READ_CHARACTERISTIC, status);
            }
            this.nextRequest(true);
        }

        @Override
        final void onCharacteristicWriteSafe(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, @Nullable byte[] data, int status) {
            if (status == 0) {
                BleManager.this.log(4, "Data written to " + characteristic.getUuid() + ", value: " + ParserUtils.parse(data));
                this.onCharacteristicWrite(gatt, characteristic);
                if (BleManager.this.mRequest instanceof WriteRequest) {
                    WriteRequest request = (WriteRequest)BleManager.this.mRequest;
                    boolean valid = request.notifyPacketSent(gatt.getDevice(), data);
                    if (!valid && BleManager.this.mRequestQueue instanceof ReliableWriteRequest) {
                        request.notifyFail(gatt.getDevice(), -6);
                        BleManager.this.mRequestQueue.cancelQueue();
                    } else if (request.hasMore()) {
                        this.enqueueFirst(request);
                    } else {
                        request.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManager.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManager.TAG, (String)ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_AUTH_ERROR_WHILE_BONDED, status);
                    }
                    return;
                }
                Log.e((String)BleManager.TAG, (String)("onCharacteristicWrite error " + status));
                if (BleManager.this.mRequest instanceof WriteRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                    if (BleManager.this.mRequestQueue instanceof ReliableWriteRequest) {
                        BleManager.this.mRequestQueue.cancelQueue();
                    }
                }
                BleManager.this.mValueChangedRequest = null;
                this.onError(gatt.getDevice(), ERROR_WRITE_CHARACTERISTIC, status);
            }
            this.nextRequest(true);
        }

        @Override
        final void onReliableWriteCompletedSafe(@NonNull BluetoothGatt gatt, int status) {
            boolean execute = ((BleManager)BleManager.this).mRequest.type == Request.Type.EXECUTE_RELIABLE_WRITE;
            BleManager.this.mReliableWriteInProgress = false;
            if (status == 0) {
                if (execute) {
                    BleManager.this.log(4, "Reliable Write executed");
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                } else {
                    BleManager.this.log(5, "Reliable Write aborted");
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                    BleManager.this.mRequestQueue.notifyFail(gatt.getDevice(), -4);
                }
            } else {
                Log.e((String)BleManager.TAG, (String)("onReliableWriteCompleted execute " + execute + ", error " + status));
                BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                this.onError(gatt.getDevice(), ERROR_RELIABLE_WRITE, status);
            }
            this.nextRequest(true);
        }

        @Override
        void onDescriptorReadSafe(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor, @Nullable byte[] data, int status) {
            if (status == 0) {
                BleManager.this.log(4, "Read Response received from descr. " + descriptor.getUuid() + ", value: " + ParserUtils.parse(data));
                this.onDescriptorRead(gatt, descriptor);
                if (BleManager.this.mRequest instanceof ReadRequest) {
                    ReadRequest request = (ReadRequest)BleManager.this.mRequest;
                    request.notifyValueChanged(gatt.getDevice(), data);
                    if (request.hasMore()) {
                        this.enqueueFirst(request);
                    } else {
                        request.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManager.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManager.TAG, (String)ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_AUTH_ERROR_WHILE_BONDED, status);
                    }
                    return;
                }
                Log.e((String)BleManager.TAG, (String)("onDescriptorRead error " + status));
                if (BleManager.this.mRequest instanceof ReadRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                }
                BleManager.this.mValueChangedRequest = null;
                this.onError(gatt.getDevice(), ERROR_READ_DESCRIPTOR, status);
            }
            this.nextRequest(true);
        }

        @Override
        final void onDescriptorWriteSafe(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattDescriptor descriptor, @Nullable byte[] data, int status) {
            if (status == 0) {
                BleManager.this.log(4, "Data written to descr. " + descriptor.getUuid() + ", value: " + ParserUtils.parse(data));
                if (this.isServiceChangedCCCD(descriptor)) {
                    BleManager.this.log(4, "Service Changed notifications enabled");
                } else if (this.isCCCD(descriptor)) {
                    if (data != null && data.length == 2 && data[1] == 0) {
                        switch (data[0]) {
                            case 0: {
                                BleManager.this.mNotificationCallbacks.remove(descriptor.getCharacteristic());
                                BleManager.this.log(4, "Notifications and indications disabled");
                                break;
                            }
                            case 1: {
                                BleManager.this.log(4, "Notifications enabled");
                                break;
                            }
                            case 2: {
                                BleManager.this.log(4, "Indications enabled");
                            }
                        }
                        this.onDescriptorWrite(gatt, descriptor);
                    }
                } else {
                    this.onDescriptorWrite(gatt, descriptor);
                }
                if (BleManager.this.mRequest instanceof WriteRequest) {
                    WriteRequest request = (WriteRequest)BleManager.this.mRequest;
                    boolean valid = request.notifyPacketSent(gatt.getDevice(), data);
                    if (!valid && BleManager.this.mRequestQueue instanceof ReliableWriteRequest) {
                        request.notifyFail(gatt.getDevice(), -6);
                        BleManager.this.mRequestQueue.cancelQueue();
                    } else if (request.hasMore()) {
                        this.enqueueFirst(request);
                    } else {
                        request.notifySuccess(gatt.getDevice());
                    }
                }
            } else {
                if (status == 5 || status == 8 || status == 137) {
                    BleManager.this.log(5, "Authentication required (" + status + ")");
                    if (gatt.getDevice().getBondState() != 10) {
                        Log.w((String)BleManager.TAG, (String)ERROR_AUTH_ERROR_WHILE_BONDED);
                        BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_AUTH_ERROR_WHILE_BONDED, status);
                    }
                    return;
                }
                Log.e((String)BleManager.TAG, (String)("onDescriptorWrite error " + status));
                if (BleManager.this.mRequest instanceof WriteRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                    if (BleManager.this.mRequestQueue instanceof ReliableWriteRequest) {
                        BleManager.this.mRequestQueue.cancelQueue();
                    }
                }
                BleManager.this.mValueChangedRequest = null;
                this.onError(gatt.getDevice(), ERROR_WRITE_DESCRIPTOR, status);
            }
            this.nextRequest(true);
        }

        @Override
        final void onCharacteristicChangedSafe(@NonNull BluetoothGatt gatt, @NonNull BluetoothGattCharacteristic characteristic, @Nullable byte[] data) {
            if (this.isServiceChangedCharacteristic(characteristic)) {
                this.mOperationInProgress = true;
                this.cancelQueue();
                this.mInitQueue = null;
                BleManager.this.log(4, "Service Changed indication received");
                BleManager.this.log(2, "Discovering Services...");
                BleManager.this.log(3, "gatt.discoverServices()");
                gatt.discoverServices();
            } else {
                WaitForValueChangedRequest valueChangedRequest;
                ValueChangedCallback request;
                BluetoothGattDescriptor cccd = characteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID);
                boolean notifications = cccd == null || cccd.getValue() == null || cccd.getValue().length != 2 || cccd.getValue()[0] == 1;
                String dataString = ParserUtils.parse(data);
                if (notifications) {
                    BleManager.this.log(4, "Notification received from " + characteristic.getUuid() + ", value: " + dataString);
                    this.onCharacteristicNotified(gatt, characteristic);
                } else {
                    BleManager.this.log(4, "Indication received from " + characteristic.getUuid() + ", value: " + dataString);
                    this.onCharacteristicIndicated(gatt, characteristic);
                }
                if (BleManager.this.mBatteryLevelNotificationCallback != null && this.isBatteryLevelCharacteristic(characteristic)) {
                    BleManager.this.mBatteryLevelNotificationCallback.notifyValueChanged(gatt.getDevice(), data);
                }
                if ((request = (ValueChangedCallback)BleManager.this.mNotificationCallbacks.get(characteristic)) != null) {
                    request.notifyValueChanged(gatt.getDevice(), data);
                }
                if ((valueChangedRequest = BleManager.this.mValueChangedRequest) != null && valueChangedRequest.characteristic == characteristic) {
                    valueChangedRequest.notifyValueChanged(gatt.getDevice(), data);
                    if (!valueChangedRequest.hasMore()) {
                        valueChangedRequest.notifySuccess(gatt.getDevice());
                        BleManager.this.mValueChangedRequest = null;
                        this.nextRequest(true);
                    }
                }
            }
        }

        @Override
        @RequiresApi(api=21)
        final void onMtuChangedSafe(@NonNull BluetoothGatt gatt, @IntRange(from=23L, to=517L) int mtu, int status) {
            if (status == 0) {
                BleManager.this.log(4, "MTU changed to: " + mtu);
                BleManager.this.mMtu = mtu;
                this.onMtuChanged(gatt, mtu);
                if (BleManager.this.mRequest instanceof MtuRequest) {
                    ((MtuRequest)BleManager.this.mRequest).notifyMtuChanged(gatt.getDevice(), mtu);
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                }
            } else {
                Log.e((String)BleManager.TAG, (String)("onMtuChanged error: " + status + ", mtu: " + mtu));
                if (BleManager.this.mRequest instanceof MtuRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                    BleManager.this.mValueChangedRequest = null;
                }
                this.onError(gatt.getDevice(), ERROR_MTU_REQUEST, status);
            }
            this.nextRequest(true);
        }

        @Override
        @RequiresApi(api=26)
        final void onConnectionUpdatedSafe(@NonNull BluetoothGatt gatt, @IntRange(from=6L, to=3200L) int interval, @IntRange(from=0L, to=499L) int latency, @IntRange(from=10L, to=3200L) int timeout, int status) {
            if (status == 0) {
                BleManager.this.log(4, "Connection parameters updated (interval: " + (double)interval * 1.25 + "ms, latency: " + latency + ", timeout: " + timeout * 10 + "ms)");
                this.onConnectionUpdated(gatt, interval, latency, timeout);
                if (BleManager.this.mRequest instanceof ConnectionPriorityRequest) {
                    ((ConnectionPriorityRequest)BleManager.this.mRequest).notifyConnectionPriorityChanged(gatt.getDevice(), interval, latency, timeout);
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                }
            } else if (status == 59) {
                Log.e((String)BleManager.TAG, (String)("onConnectionUpdated received status: Unacceptable connection interval, interval: " + interval + ", latency: " + latency + ", timeout: " + timeout));
                BleManager.this.log(5, "Connection parameters update failed with status: UNACCEPT CONN INTERVAL (0x3b) (interval: " + (double)interval * 1.25 + "ms, latency: " + latency + ", timeout: " + timeout * 10 + "ms)");
                if (BleManager.this.mRequest instanceof ConnectionPriorityRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                    BleManager.this.mValueChangedRequest = null;
                }
            } else {
                Log.e((String)BleManager.TAG, (String)("onConnectionUpdated received status: " + status + ", interval: " + interval + ", latency: " + latency + ", timeout: " + timeout));
                BleManager.this.log(5, "Connection parameters update failed with status " + status + " (interval: " + (double)interval * 1.25 + "ms, latency: " + latency + ", timeout: " + timeout * 10 + "ms)");
                if (BleManager.this.mRequest instanceof ConnectionPriorityRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                    BleManager.this.mValueChangedRequest = null;
                }
                BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_CONNECTION_PRIORITY_REQUEST, status);
            }
            if (this.mConnectionPriorityOperationInProgress) {
                this.mConnectionPriorityOperationInProgress = false;
                this.nextRequest(true);
            }
        }

        @Override
        @RequiresApi(api=26)
        final void onPhyUpdateSafe(@NonNull BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
            if (status == 0) {
                BleManager.this.log(4, "PHY updated (TX: " + BleManager.this.phyToString(txPhy) + ", RX: " + BleManager.this.phyToString(rxPhy) + ")");
                if (BleManager.this.mRequest instanceof PhyRequest) {
                    ((PhyRequest)BleManager.this.mRequest).notifyPhyChanged(gatt.getDevice(), txPhy, rxPhy);
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                }
            } else {
                BleManager.this.log(5, "PHY updated failed with status " + status);
                if (BleManager.this.mRequest instanceof PhyRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                    BleManager.this.mValueChangedRequest = null;
                }
                BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_PHY_UPDATE, status);
            }
            if (BleManager.this.mRequest instanceof PhyRequest) {
                this.nextRequest(true);
            }
        }

        @Override
        @RequiresApi(api=26)
        final void onPhyReadSafe(@NonNull BluetoothGatt gatt, int txPhy, int rxPhy, int status) {
            if (status == 0) {
                BleManager.this.log(4, "PHY read (TX: " + BleManager.this.phyToString(txPhy) + ", RX: " + BleManager.this.phyToString(rxPhy) + ")");
                if (BleManager.this.mRequest instanceof PhyRequest) {
                    ((PhyRequest)BleManager.this.mRequest).notifyPhyChanged(gatt.getDevice(), txPhy, rxPhy);
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                }
            } else {
                BleManager.this.log(5, "PHY read failed with status " + status);
                if (BleManager.this.mRequest instanceof PhyRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                }
                BleManager.this.mValueChangedRequest = null;
                BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_READ_PHY, status);
            }
            this.nextRequest(true);
        }

        @Override
        final void onReadRemoteRssiSafe(@NonNull BluetoothGatt gatt, @IntRange(from=-128L, to=20L) int rssi, int status) {
            if (status == 0) {
                BleManager.this.log(4, "Remote RSSI received: " + rssi + " dBm");
                if (BleManager.this.mRequest instanceof ReadRssiRequest) {
                    ((ReadRssiRequest)BleManager.this.mRequest).notifyRssiRead(gatt.getDevice(), rssi);
                    BleManager.this.mRequest.notifySuccess(gatt.getDevice());
                }
            } else {
                BleManager.this.log(5, "Reading remote RSSI failed with status " + status);
                if (BleManager.this.mRequest instanceof ReadRssiRequest) {
                    BleManager.this.mRequest.notifyFail(gatt.getDevice(), status);
                }
                BleManager.this.mValueChangedRequest = null;
                BleManager.this.mCallbacks.onError(gatt.getDevice(), ERROR_READ_RSSI, status);
            }
            this.nextRequest(true);
        }

        private void enqueueFirst(@NonNull Request request) {
            Deque<Request> queue = this.mInitInProgress ? this.mInitQueue : this.mTaskQueue;
            queue.addFirst(request);
            request.enqueued = true;
        }

        private void enqueue(@NonNull Request request) {
            Deque<Request> queue = this.mInitInProgress ? this.mInitQueue : this.mTaskQueue;
            queue.add(request);
            request.enqueued = true;
        }

        protected void cancelQueue() {
            this.mTaskQueue.clear();
        }

        @MainThread
        private synchronized void nextRequest(boolean force) {
            ConnectRequest cr;
            if (BleManager.this.mGattCallback == null) {
                return;
            }
            if (force) {
                boolean bl = this.mOperationInProgress = BleManager.this.mValueChangedRequest != null;
            }
            if (this.mOperationInProgress) {
                return;
            }
            Request request = null;
            try {
                if (BleManager.this.mRequestQueue != null) {
                    if (BleManager.this.mRequestQueue.hasMore()) {
                        request = BleManager.this.mRequestQueue.getNext().setManager(BleManager.this);
                    } else {
                        BleManager.this.mRequestQueue.notifySuccess(BleManager.this.mBluetoothDevice);
                        BleManager.this.mRequestQueue = null;
                    }
                }
                if (request == null) {
                    request = this.mInitQueue != null ? this.mInitQueue.poll() : null;
                }
            }
            catch (Exception e) {
                request = null;
            }
            if (request == null) {
                if (this.mInitQueue != null) {
                    this.mInitQueue = null;
                    this.mOperationInProgress = true;
                    BleManager.this.mReady = true;
                    this.onDeviceReady();
                    if (BleManager.this.mConnectRequest != null) {
                        BleManager.this.mConnectRequest.notifySuccess(BleManager.this.mConnectRequest.getDevice());
                        BleManager.this.mConnectRequest = null;
                    }
                }
                try {
                    request = this.mTaskQueue.remove();
                }
                catch (Exception e) {
                    this.mOperationInProgress = false;
                    BleManager.this.mRequest = null;
                    this.onManagerReady();
                    return;
                }
            }
            boolean result = false;
            this.mOperationInProgress = true;
            BleManager.this.mRequest = request;
            int requiredProperty = 16;
            switch (request.type) {
                case WAIT_FOR_INDICATION: {
                    requiredProperty = 32;
                }
                case WAIT_FOR_NOTIFICATION: {
                    WaitForValueChangedRequest r = (WaitForValueChangedRequest)request;
                    boolean bl = result = BleManager.this.mConnected && BleManager.this.mBluetoothDevice != null && BleManager.getCccd(r.characteristic, requiredProperty) != null;
                    if (result) {
                        BleManager.this.mValueChangedRequest = r;
                        r.notifyStarted(BleManager.this.mBluetoothDevice);
                        if (r.getTrigger() == null) break;
                        request = r.getTrigger();
                        BleManager.this.mRequest = request;
                    }
                }
                default: {
                    if (request.type == Request.Type.CONNECT) {
                        cr = (ConnectRequest)request;
                        cr.notifyStarted(cr.getDevice());
                        break;
                    }
                    if (BleManager.this.mBluetoothDevice != null) {
                        request.notifyStarted(BleManager.this.mBluetoothDevice);
                        break;
                    }
                    request.notifyInvalidRequest();
                    BleManager.this.mValueChangedRequest = null;
                    this.nextRequest(true);
                    return;
                }
            }
            switch (request.type) {
                case CONNECT: {
                    cr = (ConnectRequest)request;
                    BleManager.this.mConnectRequest = cr;
                    BleManager.this.mRequest = null;
                    result = BleManager.this.internalConnect(cr.getDevice(), cr);
                    break;
                }
                case DISCONNECT: {
                    result = BleManager.this.internalDisconnect();
                    break;
                }
                case CREATE_BOND: {
                    result = BleManager.this.internalCreateBond();
                    break;
                }
                case REMOVE_BOND: {
                    result = BleManager.this.internalRemoveBond();
                    break;
                }
                case SET: {
                    BleManager.this.mRequestQueue = (RequestQueue)request;
                    this.nextRequest(true);
                    return;
                }
                case READ: {
                    result = BleManager.this.internalReadCharacteristic(request.characteristic);
                    break;
                }
                case WRITE: {
                    WriteRequest wr = (WriteRequest)request;
                    BluetoothGattCharacteristic characteristic = request.characteristic;
                    if (characteristic != null) {
                        characteristic.setValue(wr.getData(BleManager.this.mMtu));
                        characteristic.setWriteType(wr.getWriteType());
                    }
                    result = BleManager.this.internalWriteCharacteristic(characteristic);
                    break;
                }
                case READ_DESCRIPTOR: {
                    result = BleManager.this.internalReadDescriptor(request.descriptor);
                    break;
                }
                case WRITE_DESCRIPTOR: {
                    WriteRequest wr = (WriteRequest)request;
                    BluetoothGattDescriptor descriptor = request.descriptor;
                    if (descriptor != null) {
                        descriptor.setValue(wr.getData(BleManager.this.mMtu));
                    }
                    result = BleManager.this.internalWriteDescriptor(descriptor);
                    break;
                }
                case BEGIN_RELIABLE_WRITE: {
                    result = BleManager.this.internalBeginReliableWrite();
                    if (!result) break;
                    BleManager.this.mRequest.notifySuccess(BleManager.this.mBluetoothDevice);
                    this.nextRequest(true);
                    return;
                }
                case EXECUTE_RELIABLE_WRITE: {
                    result = BleManager.this.internalExecuteReliableWrite();
                    break;
                }
                case ABORT_RELIABLE_WRITE: {
                    result = BleManager.this.internalAbortReliableWrite();
                    break;
                }
                case ENABLE_NOTIFICATIONS: {
                    result = BleManager.this.internalEnableNotifications(request.characteristic);
                    break;
                }
                case ENABLE_INDICATIONS: {
                    result = BleManager.this.internalEnableIndications(request.characteristic);
                    break;
                }
                case DISABLE_NOTIFICATIONS: {
                    result = BleManager.this.internalDisableNotifications(request.characteristic);
                    break;
                }
                case DISABLE_INDICATIONS: {
                    result = BleManager.this.internalDisableIndications(request.characteristic);
                    break;
                }
                case READ_BATTERY_LEVEL: {
                    result = BleManager.this.internalReadBatteryLevel();
                    break;
                }
                case ENABLE_BATTERY_LEVEL_NOTIFICATIONS: {
                    result = BleManager.this.internalSetBatteryNotifications(true);
                    break;
                }
                case DISABLE_BATTERY_LEVEL_NOTIFICATIONS: {
                    result = BleManager.this.internalSetBatteryNotifications(false);
                    break;
                }
                case ENABLE_SERVICE_CHANGED_INDICATIONS: {
                    result = BleManager.this.ensureServiceChangedEnabled();
                    break;
                }
                case REQUEST_MTU: {
                    MtuRequest mr = (MtuRequest)request;
                    if (BleManager.this.mMtu != mr.getRequiredMtu() && Build.VERSION.SDK_INT >= 21) {
                        result = BleManager.this.internalRequestMtu(mr.getRequiredMtu());
                        break;
                    }
                    result = BleManager.this.mConnected;
                    if (!result) break;
                    mr.notifyMtuChanged(BleManager.this.mBluetoothDevice, BleManager.this.mMtu);
                    mr.notifySuccess(BleManager.this.mBluetoothDevice);
                    this.nextRequest(true);
                    return;
                }
                case REQUEST_CONNECTION_PRIORITY: {
                    ConnectionPriorityRequest cpr = (ConnectionPriorityRequest)request;
                    if (Build.VERSION.SDK_INT >= 26) {
                        this.mConnectionPriorityOperationInProgress = true;
                        result = BleManager.this.internalRequestConnectionPriority(cpr.getRequiredPriority());
                        break;
                    }
                    if (Build.VERSION.SDK_INT < 21 || !(result = BleManager.this.internalRequestConnectionPriority(cpr.getRequiredPriority()))) break;
                    BluetoothDevice device = BleManager.this.mBluetoothDevice;
                    BleManager.this.mHandler.postDelayed(() -> {
                        cpr.notifySuccess(device);
                        this.nextRequest(true);
                    }, 100L);
                    break;
                }
                case SET_PREFERRED_PHY: {
                    PhyRequest pr = (PhyRequest)request;
                    if (Build.VERSION.SDK_INT >= 26) {
                        result = BleManager.this.internalSetPreferredPhy(pr.getPreferredTxPhy(), pr.getPreferredRxPhy(), pr.getPreferredPhyOptions());
                        break;
                    }
                    result = BleManager.this.mConnected;
                    if (!result) break;
                    pr.notifyLegacyPhy(BleManager.this.mBluetoothDevice);
                    pr.notifySuccess(BleManager.this.mBluetoothDevice);
                    this.nextRequest(true);
                    return;
                }
                case READ_PHY: {
                    PhyRequest pr = (PhyRequest)request;
                    if (Build.VERSION.SDK_INT >= 26) {
                        result = BleManager.this.internalReadPhy();
                        break;
                    }
                    result = BleManager.this.mConnected;
                    if (!result) break;
                    pr.notifyLegacyPhy(BleManager.this.mBluetoothDevice);
                    pr.notifySuccess(BleManager.this.mBluetoothDevice);
                    this.nextRequest(true);
                    return;
                }
                case READ_RSSI: {
                    result = BleManager.this.internalReadRssi();
                    break;
                }
                case REFRESH_CACHE: {
                    result = BleManager.this.internalRefreshDeviceCache();
                    if (!result) break;
                    BluetoothDevice device = BleManager.this.mBluetoothDevice;
                    BleManager.this.mHandler.postDelayed(() -> {
                        BleManager.this.log(4, "Cache refreshed");
                        BleManager.this.mRequest.notifySuccess(device);
                        BleManager.this.mRequest = null;
                        if (BleManager.this.mValueChangedRequest != null) {
                            BleManager.this.mValueChangedRequest.notifyFail(device, -3);
                            BleManager.this.mValueChangedRequest = null;
                        }
                        this.cancelQueue();
                        this.mInitQueue = null;
                        if (BleManager.this.mConnected) {
                            this.onDeviceDisconnected();
                            BleManager.this.log(2, "Discovering Services...");
                            BleManager.this.log(3, "gatt.discoverServices()");
                            BleManager.this.mBluetoothGatt.discoverServices();
                        }
                    }, 200L);
                    break;
                }
                case SLEEP: {
                    BluetoothDevice device = BleManager.this.mBluetoothDevice;
                    if (device == null) break;
                    SleepRequest sr = (SleepRequest)request;
                    BleManager.this.log(3, "sleep(" + sr.getDelay() + ")");
                    BleManager.this.mHandler.postDelayed(() -> {
                        sr.notifySuccess(device);
                        this.nextRequest(true);
                    }, sr.getDelay());
                    result = true;
                    break;
                }
            }
            if (!result) {
                BleManager.this.mRequest.notifyFail(BleManager.this.mBluetoothDevice, BleManager.this.mConnected ? -3 : (BluetoothAdapter.getDefaultAdapter().isEnabled() ? -1 : -100));
                BleManager.this.mValueChangedRequest = null;
                this.mConnectionPriorityOperationInProgress = false;
                this.nextRequest(true);
            }
        }

        private boolean isServiceChangedCCCD(@Nullable BluetoothGattDescriptor descriptor) {
            return descriptor != null && SERVICE_CHANGED_CHARACTERISTIC.equals(descriptor.getCharacteristic().getUuid());
        }

        private boolean isServiceChangedCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
            return characteristic != null && SERVICE_CHANGED_CHARACTERISTIC.equals(characteristic.getUuid());
        }

        @Deprecated
        private boolean isBatteryLevelCharacteristic(@Nullable BluetoothGattCharacteristic characteristic) {
            return characteristic != null && BATTERY_LEVEL_CHARACTERISTIC.equals(characteristic.getUuid());
        }

        private boolean isCCCD(BluetoothGattDescriptor descriptor) {
            return descriptor != null && CLIENT_CHARACTERISTIC_CONFIG_DESCRIPTOR_UUID.equals(descriptor.getUuid());
        }
    }
}

