/*
 * Decompiled with CFR 0.152.
 */
package no.hackeriet.struts1Spring.struts;

import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class SpringBindingActionForm
extends ActionForm {
    private static final Log logger = LogFactory.getLog(SpringBindingActionForm.class);
    private static boolean defaultActionMessageAvailable = true;
    private Errors errors;
    private Locale locale;
    private MessageResources messageResources;

    public void expose(Errors errors, HttpServletRequest request) {
        this.errors = errors;
        this.locale = (Locale)request.getSession().getAttribute("org.apache.struts.action.LOCALE");
        this.messageResources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        if (errors != null && errors.hasErrors()) {
            ActionMessages actionMessages = (ActionMessages)request.getAttribute("org.apache.struts.action.ERROR");
            if (actionMessages == null) {
                request.setAttribute("org.apache.struts.action.ERROR", (Object)this.getActionMessages());
            } else {
                actionMessages.add(this.getActionMessages());
            }
        }
    }

    private ActionMessages getActionMessages() {
        ActionMessages actionMessages = new ActionMessages();
        for (ObjectError objectError : this.errors.getAllErrors()) {
            ActionMessage message;
            String effectiveMessageKey = this.findEffectiveMessageKey(objectError);
            if (effectiveMessageKey == null && !defaultActionMessageAvailable) {
                effectiveMessageKey = objectError.getCode();
            }
            ActionMessage actionMessage = message = effectiveMessageKey != null ? new ActionMessage(effectiveMessageKey, this.resolveArguments(objectError.getArguments())) : new ActionMessage(objectError.getDefaultMessage(), false);
            if (objectError instanceof FieldError) {
                FieldError fieldError = (FieldError)objectError;
                actionMessages.add(fieldError.getField(), message);
                continue;
            }
            actionMessages.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Final ActionMessages used for binding: " + actionMessages));
        }
        return actionMessages;
    }

    private Object[] resolveArguments(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return arguments;
        }
        for (int i = 0; i < arguments.length; ++i) {
            Object arg = arguments[i];
            if (!(arg instanceof MessageSourceResolvable)) continue;
            MessageSourceResolvable resolvable = (MessageSourceResolvable)arg;
            String[] codes = resolvable.getCodes();
            boolean resolved = false;
            if (this.messageResources != null) {
                for (int j = 0; j < codes.length; ++j) {
                    String code = codes[j];
                    if (!this.messageResources.isPresent(this.locale, code)) continue;
                    arguments[i] = this.messageResources.getMessage(this.locale, code, this.resolveArguments(resolvable.getArguments()));
                    resolved = true;
                    break;
                }
            }
            if (resolved) continue;
            arguments[i] = resolvable.getDefaultMessage();
        }
        return arguments;
    }

    private String findEffectiveMessageKey(ObjectError error) {
        if (this.messageResources != null) {
            String[] possibleMatches = error.getCodes();
            for (int i = 0; i < possibleMatches.length; ++i) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Looking for error code '" + possibleMatches[i] + "'"));
                }
                if (!this.messageResources.isPresent(this.locale, possibleMatches[i])) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found error code '" + possibleMatches[i] + "' in resource bundle"));
                }
                return possibleMatches[i];
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Could not find a suitable message error code, returning default message");
        }
        return null;
    }

    private Object getFieldValue(String propertyPath) throws NoSuchMethodException {
        if (this.errors == null) {
            throw new NoSuchMethodException("No bean properties exposed to Struts binding - performing Spring binding later on");
        }
        return this.errors.getFieldValue(propertyPath);
    }

    static {
        ConvertUtilsBean convUtils = new ConvertUtilsBean();
        SpringBindingAwarePropertyUtilsBean propUtils = new SpringBindingAwarePropertyUtilsBean();
        BeanUtilsBean beanUtils = new BeanUtilsBean(convUtils, (PropertyUtilsBean)propUtils);
        BeanUtilsBean.setInstance((BeanUtilsBean)beanUtils);
        try {
            ActionMessage.class.getConstructor(String.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException ex) {
            defaultActionMessageAvailable = false;
        }
    }

    private static class SpringBindingAwarePropertyUtilsBean
    extends PropertyUtilsBean {
        private SpringBindingAwarePropertyUtilsBean() {
        }

        public Object getNestedProperty(Object bean, String propertyPath) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (bean instanceof SpringBindingActionForm) {
                SpringBindingActionForm form = (SpringBindingActionForm)((Object)bean);
                return form.getFieldValue(propertyPath);
            }
            return super.getNestedProperty(bean, propertyPath);
        }
    }
}

