/*
 * Decompiled with CFR 0.152.
 */
package no.entur.mapstruct.spi.protobuf;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.util.Nouns;
import org.mapstruct.ap.spi.DefaultAccessorNamingStrategy;
import org.mapstruct.ap.spi.MapStructProcessingEnvironment;
import org.mapstruct.ap.spi.util.IntrospectorUtils;

public class ProtobufAccessorNamingStrategy
extends DefaultAccessorNamingStrategy {
    public static final String PROTOBUF_STRING_LIST_TYPE = "com.google.protobuf.ProtocolStringList";
    public static final String PROTOBUF_MESSAGE_OR_BUILDER = "com.google.protobuf.MessageLiteOrBuilder";
    public static final String PROTOBUF_GENERATED_MESSAGE = "com.google.protobuf.Message";
    public static final String BUILDER_LIST_SUFFIX = "BuilderList";
    protected static final Set<String> INTERNAL_METHODS = new HashSet<String>(Arrays.asList("newBuilder", "newBuilderForType", "parseFrom", "parseDelimitedFrom", "getDefaultInstance", "getDescriptor", "getDescriptorForType", "getDefaultInstanceForType", "clear", "clearField", "clearOneof", "mergeFrom", "setRepeatedField", "setUnknownFields", "getSerializedSize", "getAllFields", "getAllFieldsMutable", "getAllFieldsRaw", "getDescriptorForType", "getField", "getFieldRaw", "getOneofFieldDescriptor", "getParserForType", "getRepeatedField", "getRepeatedFieldCount", "getUnknownFields", "getInitializationErrorString", "getMemoizedSerializedSize", "getOneofFieldDescriptor", "getSerializedSize", "getMemoizedSerializedSize", "getSerializingExceptionMessage", "isInitialized", "mergeUnknownFields"));
    protected static final List<String> INTERNAL_SPECIAL_METHOD_ENDINGS = Arrays.asList("Value", "Count", "Bytes", "Map", "ValueList");
    protected static final List<String> INTERNAL_SPECIAL_METHOD_BEGINNINGS = Arrays.asList("remove", "clear", "mutable", "merge", "putAll", "getMutable");
    protected TypeMirror protobufMesageOrBuilderType;

    public void init(MapStructProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        TypeElement typeElement = this.elementUtils.getTypeElement(PROTOBUF_MESSAGE_OR_BUILDER);
        if (typeElement != null) {
            this.protobufMesageOrBuilderType = typeElement.asType();
        }
    }

    private boolean isSpecialMethod(ExecutableElement method) {
        boolean propertyMethodExists;
        String propertyMethod;
        if (!this.isMethodFromProtobufGeneratedClass(method)) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        for (String checkMethod : INTERNAL_SPECIAL_METHOD_ENDINGS) {
            if (!methodName.endsWith(checkMethod)) continue;
            propertyMethod = methodName.substring(0, methodName.length() - checkMethod.length());
            propertyMethodExists = method.getEnclosingElement().getEnclosedElements().stream().anyMatch(e -> e.getSimpleName().toString().equals(propertyMethod));
            if (!propertyMethodExists) continue;
            return true;
        }
        for (String checkMethod : INTERNAL_SPECIAL_METHOD_BEGINNINGS) {
            if (!methodName.startsWith(checkMethod)) continue;
            propertyMethod = "get" + methodName.substring(checkMethod.length());
            propertyMethodExists = method.getEnclosingElement().getEnclosedElements().stream().anyMatch(e -> e.getSimpleName().toString().equals(propertyMethod));
            if (!propertyMethodExists) continue;
            return true;
        }
        return this.isOneOfCaseSelector(method);
    }

    public boolean isGetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (methodName.endsWith("OrBuilder")) {
            return false;
        }
        if (methodName.endsWith("OrBuilderList")) {
            return false;
        }
        if (methodName.endsWith(BUILDER_LIST_SUFFIX)) {
            return false;
        }
        if (INTERNAL_METHODS.contains(methodName)) {
            return false;
        }
        if (this.isSpecialMethod(method)) {
            return false;
        }
        return super.isGetterMethod(method);
    }

    private boolean isOneOfCaseSelector(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        return methodName.startsWith("getOneOf") && methodName.endsWith("Case");
    }

    public boolean isSetterMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (INTERNAL_METHODS.contains(methodName)) {
            return false;
        }
        if (this.isSpecialMethod(method)) {
            return false;
        }
        return super.isSetterMethod(method);
    }

    protected boolean isFluentSetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (INTERNAL_METHODS.contains(methodName)) {
            return false;
        }
        if (methodName.startsWith("get")) {
            return false;
        }
        if (this.isOneOfCaseSelector(method)) {
            return false;
        }
        return super.isFluentSetter(method);
    }

    public boolean isAdderMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (INTERNAL_METHODS.contains(methodName)) {
            return false;
        }
        if (this.isOneOfCaseSelector(method)) {
            return false;
        }
        return super.isAdderMethod(method);
    }

    public boolean isPresenceCheckMethod(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (INTERNAL_METHODS.contains(methodName)) {
            return false;
        }
        if (this.isOneOfCaseSelector(method)) {
            return true;
        }
        return super.isPresenceCheckMethod(method);
    }

    public String getElementName(ExecutableElement adderMethod) {
        String methodName = super.getElementName(adderMethod);
        if (this.isMethodFromProtobufGeneratedClass(adderMethod)) {
            String singularizedMethodName;
            methodName = singularizedMethodName = Nouns.singularize((String)methodName);
        }
        return methodName;
    }

    public String getPropertyName(ExecutableElement getterOrSetterMethod) {
        TypeElement type;
        Element receiver;
        String methodName = getterOrSetterMethod.getSimpleName().toString();
        if ((this.isGetList(getterOrSetterMethod) || this.isSetList(getterOrSetterMethod)) && (receiver = getterOrSetterMethod.getEnclosingElement()) != null && (receiver.getKind() == ElementKind.CLASS || receiver.getKind() == ElementKind.INTERFACE) && this.isProtobufGeneratedMessage(type = (TypeElement)receiver)) {
            String propertyName = IntrospectorUtils.decapitalize((String)methodName.substring(3, methodName.length() - 4));
            return propertyName;
        }
        return super.getPropertyName(getterOrSetterMethod);
    }

    private boolean isGetList(ExecutableElement element) {
        return element.getSimpleName().toString().startsWith("get") && this.isListType(element.getReturnType());
    }

    private boolean isSetList(ExecutableElement element) {
        if (element.getSimpleName().toString().startsWith("set") && element.getParameters().size() == 1) {
            TypeMirror param = element.getParameters().get(0).asType();
            return this.isListType(param);
        }
        return false;
    }

    private boolean isListType(TypeMirror t) {
        return t.toString().startsWith(List.class.getCanonicalName()) || t.toString().startsWith(PROTOBUF_STRING_LIST_TYPE);
    }

    private boolean isProtobufGeneratedMessage(TypeElement type) {
        TypeMirror superType;
        List<? extends TypeMirror> interfaces = type.getInterfaces();
        if (interfaces != null) {
            for (TypeMirror typeMirror : interfaces) {
                DeclaredType declared;
                Element supertypeElement;
                if (typeMirror.toString().startsWith(PROTOBUF_MESSAGE_OR_BUILDER)) {
                    return true;
                }
                if (!(typeMirror instanceof DeclaredType) || !this.isProtobufGeneratedMessage((TypeElement)(supertypeElement = (declared = (DeclaredType)typeMirror).asElement()))) continue;
                return true;
            }
        }
        if ((superType = type.getSuperclass()) instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)superType;
            Element supertypeElement = declaredType.asElement();
            return this.isProtobufGeneratedMessage((TypeElement)supertypeElement);
        }
        return false;
    }

    private boolean isMethodFromProtobufGeneratedClass(ExecutableElement method) {
        Element receiver = method.getEnclosingElement();
        return this.protobufMesageOrBuilderType != null && receiver != null && this.typeUtils.isAssignable(receiver.asType(), this.protobufMesageOrBuilderType);
    }
}

