/*
 * Decompiled with CFR 0.152.
 */
package nl.topicus.plugins.maven.javassist;

import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import nl.topicus.plugins.maven.javassist.ILogger;
import nl.topicus.plugins.maven.javassist.TransformationException;

public abstract class ClassTransformer {
    private List<String> processInclusions = new ArrayList<String>();
    private List<String> processExclusions = new ArrayList<String>();
    private List<String> exclusions = new ArrayList<String>();
    private ILogger logger;

    public final ILogger getLogger() {
        return this.logger;
    }

    public final void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public List<String> getProcessInclusions() {
        return this.processInclusions;
    }

    public void setProcessInclusions(List<String> processInclusions) {
        this.processInclusions = processInclusions;
    }

    public List<String> getProcessExclusions() {
        return this.processExclusions;
    }

    public void setProcessExclusions(List<String> processExclusions) {
        this.processExclusions = processExclusions;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(List<String> exclusions) {
        this.exclusions = exclusions;
    }

    public abstract void applyTransformations(ClassPool var1, CtClass var2) throws TransformationException;

    public boolean processClassName(String className) {
        for (String exclusion : this.getProcessExclusions()) {
            if (!className.startsWith(exclusion)) continue;
            return false;
        }
        for (String inclusion : this.getProcessInclusions()) {
            if (!className.startsWith(inclusion)) continue;
            return true;
        }
        return false;
    }
}

